/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.junit.http;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Semaphore;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jgit.junit.http.AccessEvent;

class TestRequestLog
extends Handler.Wrapper {
    private static final int MAX = 16;
    private final List<AccessEvent> events = Collections.synchronizedList(new ArrayList());
    private final Semaphore active = new Semaphore(16, true);

    TestRequestLog() {
    }

    void clear() {
        try {
            while (true) {
                try {
                    this.active.acquire(16);
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
            this.events.clear();
        }
        finally {
            this.active.release(16);
        }
    }

    List<AccessEvent> getEvents() {
        try {
            while (true) {
                try {
                    this.active.acquire(16);
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
            List<AccessEvent> list = Collections.unmodifiableList(new ArrayList<AccessEvent>(this.events));
            return list;
        }
        finally {
            this.active.release(16);
        }
    }

    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        try {
            while (true) {
                try {
                    this.active.acquire();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
            AccessEvent event = new AccessEvent(request);
            this.events.add(event);
            boolean result = super.handle(request, response, callback);
            event.setResponse(response);
            boolean bl = result;
            return bl;
        }
        finally {
            this.active.release();
        }
    }
}

