/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.junit.http;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.helpers.MarkerIgnoringBase;

public class RecordingLogger
extends MarkerIgnoringBase {
    private static final long serialVersionUID = 1L;
    private static List<Warning> warnings = new ArrayList<Warning>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        List<Warning> list = warnings;
        synchronized (list) {
            warnings.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Warning> getWarnings() {
        List<Warning> list = warnings;
        synchronized (list) {
            ArrayList<Warning> copy = new ArrayList<Warning>(warnings);
            return Collections.unmodifiableList(copy);
        }
    }

    public RecordingLogger() {
        this("");
    }

    public RecordingLogger(String name) {
        this.name = name;
    }

    public boolean isTraceEnabled() {
        return false;
    }

    public void trace(String msg) {
    }

    public void trace(String format, Object arg) {
    }

    public void trace(String format, Object arg1, Object arg2) {
    }

    public void trace(String format, Object ... arguments) {
    }

    public void trace(String msg, Throwable t) {
    }

    public boolean isDebugEnabled() {
        return false;
    }

    public void debug(String msg) {
    }

    public void debug(String format, Object arg) {
    }

    public void debug(String format, Object arg1, Object arg2) {
    }

    public void debug(String format, Object ... arguments) {
    }

    public void debug(String msg, Throwable t) {
    }

    public boolean isInfoEnabled() {
        return false;
    }

    public void info(String msg) {
    }

    public void info(String format, Object arg) {
    }

    public void info(String format, Object arg1, Object arg2) {
    }

    public void info(String format, Object ... arguments) {
    }

    public void info(String msg, Throwable t) {
    }

    public boolean isWarnEnabled() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warn(String msg) {
        List<Warning> list = warnings;
        synchronized (list) {
            warnings.add(new Warning(msg));
        }
    }

    public void warn(String format, Object arg) {
        this.addWarnings(format, Collections.singleton(arg));
    }

    public void warn(String format, Object ... arguments) {
        this.addWarnings(format, arguments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addWarnings(String format, Object ... arguments) {
        List<Warning> list = warnings;
        synchronized (list) {
            int i = 0;
            int index = format.indexOf("{}");
            while (index >= 0) {
                format = format.replaceFirst("\\{\\}", "{" + i++ + "}");
                index = format.indexOf("{}");
            }
            warnings.add(new Warning(MessageFormat.format(format, arguments)));
        }
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.warn(format, new Object[]{arg1, arg2});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warn(String msg, Throwable t) {
        List<Warning> list = warnings;
        synchronized (list) {
            warnings.add(new Warning(msg, t));
        }
    }

    public boolean isErrorEnabled() {
        return false;
    }

    public void error(String msg) {
    }

    public void error(String format, Object arg) {
    }

    public void error(String format, Object arg1, Object arg2) {
    }

    public void error(String format, Object ... arguments) {
    }

    public void error(String msg, Throwable t) {
    }

    public static class Warning
    extends Exception {
        public Warning(String msg) {
            super(msg);
        }

        public Warning(String msg, Throwable cause) {
            super(msg, cause);
        }

        public Warning(Throwable thrown) {
            super(thrown);
        }
    }
}

