/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.junit.http;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.junit.LocalDiskRepositoryTestCase;
import org.eclipse.jgit.junit.TestRepository;
import org.eclipse.jgit.junit.http.AccessEvent;
import org.eclipse.jgit.junit.http.AppServer;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteRefUpdate;
import org.eclipse.jgit.transport.URIish;
import org.junit.Assert;

public abstract class HttpTestCase
extends LocalDiskRepositoryTestCase {
    protected static final String master = "refs/heads/master";
    protected AppServer server;

    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer();
    }

    public void tearDown() throws Exception {
        this.server.tearDown();
        super.tearDown();
    }

    protected AppServer createServer() {
        return new AppServer();
    }

    protected TestRepository<Repository> createTestRepository() throws IOException {
        FileRepository repository = this.createBareRepository();
        this.addRepoToClose((Repository)repository);
        return new TestRepository((Repository)repository);
    }

    protected URIish toURIish(String path) throws URISyntaxException {
        URI u = this.server.getURI().resolve(path);
        return new URIish(u.toString());
    }

    protected URIish toURIish(ServletContextHandler app, String name) throws URISyntaxException {
        Object p = app.getContextPath();
        if (!((String)p).endsWith("/") && !name.startsWith("/")) {
            p = (String)p + "/";
        }
        p = (String)p + name;
        return this.toURIish((String)p);
    }

    protected List<AccessEvent> getRequests() {
        return this.server.getRequests();
    }

    protected List<AccessEvent> getRequests(URIish base, String path) {
        return this.server.getRequests(base, path);
    }

    protected List<AccessEvent> getRequests(String path) {
        return this.server.getRequests(path);
    }

    protected static void fsck(Repository db, RevObject ... tips) throws Exception {
        Throwable throwable = null;
        Object var3_4 = null;
        try (TestRepository tr = new TestRepository(db);){
            tr.fsck(tips);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected static Set<RefSpec> mirror(String ... refs) {
        HashSet<RefSpec> r = new HashSet<RefSpec>();
        String[] stringArray = refs;
        int n = refs.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            RefSpec rs = new RefSpec(name);
            rs = rs.setDestination(name);
            rs = rs.setForceUpdate(true);
            r.add(rs);
            ++n2;
        }
        return r;
    }

    protected static Collection<RemoteRefUpdate> push(TestRepository from, RevCommit q) throws IOException {
        Repository db = from.getRepository();
        String srcExpr = q.name();
        String dstName = master;
        boolean forceUpdate = true;
        String localName = null;
        ObjectId oldId = null;
        RemoteRefUpdate u = new RemoteRefUpdate(db, srcExpr, master, true, localName, oldId);
        return Collections.singleton(u);
    }

    public static String loose(URIish base, AnyObjectId id) {
        String objectName = id.name();
        String d = objectName.substring(0, 2);
        String f = objectName.substring(2);
        return HttpTestCase.join(base, "objects/" + d + "/" + f);
    }

    public static String join(URIish base, String path) {
        Object dir;
        if (path.startsWith("/")) {
            Assert.fail((String)("Cannot join absolute path " + path + " to URIish " + String.valueOf(base)));
        }
        if (!((String)(dir = base.getPath())).endsWith("/")) {
            dir = (String)dir + "/";
        }
        return (String)dir + path;
    }

    protected static String rewriteUrl(String url, String newProtocol, int newPort) {
        int schemeEnd;
        Object newUrl = url;
        if (newProtocol != null && !newProtocol.isEmpty() && (schemeEnd = ((String)newUrl).indexOf("://")) >= 0) {
            newUrl = newProtocol + ((String)newUrl).substring(schemeEnd);
        }
        newUrl = newPort > 0 ? ((String)newUrl).replaceFirst(":\\d+/", ":" + newPort + "/") : ((String)newUrl).replaceFirst(":\\d+/", "/");
        return newUrl;
    }

    protected static URIish extendPath(URIish uri, String pathComponents) throws URISyntaxException {
        Object raw = uri.toString();
        Object newComponents = pathComponents;
        if (!((String)newComponents).startsWith("/")) {
            newComponents = "/" + (String)newComponents;
        }
        if (!((String)newComponents).endsWith("/")) {
            newComponents = (String)newComponents + "/";
        }
        int i = ((String)raw).lastIndexOf(47);
        raw = ((String)raw).substring(0, i) + (String)newComponents + ((String)raw).substring(i + 1);
        return new URIish((String)raw);
    }
}

