/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.http.server;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.eclipse.jgit.http.server.ServletUtils;
import org.eclipse.jgit.util.IO;

class TextFileServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private final String fileName;

    TextFileServlet(String name) {
        this.fileName = name;
    }

    public void doGet(HttpServletRequest req, HttpServletResponse rsp) throws IOException {
        try {
            rsp.setContentType("text/plain");
            ServletUtils.send(this.read(req), req, rsp);
        }
        catch (FileNotFoundException noFile) {
            rsp.sendError(404);
        }
    }

    private byte[] read(HttpServletRequest req) throws IOException {
        File gitdir = ServletUtils.getRepository((ServletRequest)req).getDirectory();
        if (gitdir == null) {
            throw new FileNotFoundException(this.fileName);
        }
        return IO.readFully((File)new File(gitdir, this.fileName));
    }
}

