/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server.mux;

import java.io.IOException;
import java.util.List;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.api.UpgradeResponse;
import org.eclipse.jetty.websocket.common.extensions.mux.MuxChannel;
import org.eclipse.jetty.websocket.common.extensions.mux.MuxException;
import org.eclipse.jetty.websocket.common.extensions.mux.Muxer;
import org.eclipse.jetty.websocket.common.extensions.mux.add.MuxAddServer;
import org.eclipse.jetty.websocket.server.mux.EmptyHttpInput;
import org.eclipse.jetty.websocket.server.mux.HttpChannelOverMux;
import org.eclipse.jetty.websocket.server.mux.HttpTransportOverMux;

public class MuxAddHandler
implements MuxAddServer {
    private Connector connector;
    private EndPoint endPoint;
    private UpgradeRequest baseHandshakeRequest;
    private UpgradeResponse baseHandshakeResponse;
    private int maximumHeaderSize = 32768;

    public UpgradeRequest getPhysicalHandshakeRequest() {
        return null;
    }

    public UpgradeResponse getPhysicalHandshakeResponse() {
        return null;
    }

    public void handshake(Muxer muxer, MuxChannel channel, UpgradeRequest request) throws MuxException, IOException {
        HttpTransportOverMux transport = new HttpTransportOverMux(muxer, channel);
        EmptyHttpInput input = new EmptyHttpInput();
        HttpConfiguration configuration = new HttpConfiguration();
        HttpChannelOverMux httpChannel = new HttpChannelOverMux(this.connector, configuration, this.endPoint, transport, input);
        HttpMethod method = HttpMethod.fromString((String)request.getMethod());
        HttpVersion version = HttpVersion.fromString((String)request.getHttpVersion());
        httpChannel.startRequest(method, request.getMethod(), request.getRequestURI().toASCIIString(), version);
        for (String headerName : request.getHeaders().keySet()) {
            HttpHeader header = (HttpHeader)HttpHeader.CACHE.getBest(headerName.getBytes(), 0, headerName.length());
            for (String value : (List)request.getHeaders().get(headerName)) {
                httpChannel.parsedHeader(new HttpField(header, value));
            }
        }
        httpChannel.headerComplete();
        httpChannel.messageComplete();
        httpChannel.run();
        throw new MuxException("Not a valid request");
    }
}

