/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server;

import java.util.concurrent.Executor;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.websocket.core.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.core.io.AbstractWebSocketConnection;
import org.eclipse.jetty.websocket.server.WebSocketServerFactory;

public class WebSocketServerConnection
extends AbstractWebSocketConnection {
    private final WebSocketServerFactory factory;
    private boolean connected;

    public WebSocketServerConnection(EndPoint endp, Executor executor, Scheduler scheduler, WebSocketPolicy policy, ByteBufferPool bufferPool, WebSocketServerFactory factory) {
        super(endp, executor, scheduler, policy, bufferPool);
        this.factory = factory;
        this.connected = false;
    }

    public void onClose() {
        super.onClose();
        this.factory.sessionClosed(this.getSession());
    }

    public void onOpen() {
        if (!this.connected) {
            this.factory.sessionOpened(this.getSession());
            this.connected = true;
        }
        super.onOpen();
    }
}

