/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.core.api.WebSocketBehavior;
import org.eclipse.jetty.websocket.core.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.server.WebSocketServerFactory;

public abstract class WebSocketServlet
extends HttpServlet {
    private final Logger LOG = Log.getLogger(((Object)((Object)this)).getClass());
    private WebSocketServerFactory webSocketFactory;

    public void destroy() {
        try {
            this.webSocketFactory.stop();
        }
        catch (Exception x) {
            this.LOG.ignore((Throwable)x);
        }
    }

    public void init() throws ServletException {
        try {
            String max;
            String bs = this.getInitParameter("bufferSize");
            WebSocketPolicy policy = new WebSocketPolicy(WebSocketBehavior.SERVER);
            if (bs != null) {
                policy.setBufferSize(Integer.parseInt(bs));
            }
            if ((max = this.getInitParameter("maxIdleTime")) != null) {
                policy.setIdleTimeout(Integer.parseInt(max));
            }
            if ((max = this.getInitParameter("maxTextMessageSize")) != null) {
                policy.setMaxTextMessageSize(Integer.parseInt(max));
            }
            if ((max = this.getInitParameter("maxBinaryMessageSize")) != null) {
                policy.setMaxBinaryMessageSize(Integer.parseInt(max));
            }
            this.webSocketFactory = new WebSocketServerFactory(policy);
            this.registerWebSockets(this.webSocketFactory);
            this.webSocketFactory.start();
        }
        catch (Exception x) {
            throw new ServletException((Throwable)x);
        }
    }

    public abstract void registerWebSockets(WebSocketServerFactory var1);

    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.webSocketFactory.isUpgradeRequest(request, response)) {
            if (this.webSocketFactory.acceptWebSocket(request, response)) {
                return;
            }
            if (response.isCommitted()) {
                return;
            }
        }
        super.service(request, response);
    }
}

