/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.client.impl;

import java.net.HttpCookie;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.MultiMap;
import org.eclipse.jetty.util.UrlEncoded;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.core.client.ClientUpgradeRequest;

public class DelegatedJettyClientUpgradeRequest
implements UpgradeRequest {
    private final ClientUpgradeRequest delegate;
    private SocketAddress localSocketAddress;
    private SocketAddress remoteSocketAddress;

    public DelegatedJettyClientUpgradeRequest(ClientUpgradeRequest delegate) {
        this.delegate = delegate;
    }

    public List<HttpCookie> getCookies() {
        return this.delegate.getCookies();
    }

    public String getHeader(String name) {
        return this.delegate.getHeaders().get(name);
    }

    public int getHeaderInt(String name) {
        HttpField field = this.delegate.getHeaders().getField(name);
        if (field == null) {
            return -1;
        }
        return field.getIntValue();
    }

    public List<String> getHeaders(String name) {
        return this.delegate.getHeaders().getValuesList(name);
    }

    public Map<String, List<String>> getHeaders() {
        return null;
    }

    public String getHost() {
        return this.delegate.getHost();
    }

    public String getHttpVersion() {
        return this.delegate.getVersion().toString();
    }

    public void configure(EndPoint endpoint) {
        this.localSocketAddress = endpoint.getLocalAddress();
        this.remoteSocketAddress = endpoint.getRemoteAddress();
    }

    public String getMethod() {
        return this.delegate.getMethod();
    }

    public String getOrigin() {
        return this.delegate.getHeaders().get(HttpHeader.ORIGIN);
    }

    public Map<String, List<String>> getParameterMap() {
        if (this.getQueryString() == null) {
            return Collections.emptyMap();
        }
        MultiMap params = new MultiMap();
        UrlEncoded.decodeTo((String)this.getQueryString(), (MultiMap)params, (Charset)StandardCharsets.UTF_8);
        return params;
    }

    public String getProtocolVersion() {
        return this.delegate.getHeaders().get(HttpHeader.SEC_WEBSOCKET_VERSION);
    }

    public String getQueryString() {
        return this.delegate.getQuery();
    }

    public URI getRequestURI() {
        return this.delegate.getURI();
    }

    public List<String> getSubProtocols() {
        return this.delegate.getHeaders().getValuesList(HttpHeader.SEC_WEBSOCKET_SUBPROTOCOL);
    }

    public boolean hasSubProtocol(String test) {
        HttpField field = this.delegate.getHeaders().getField(HttpHeader.SEC_WEBSOCKET_SUBPROTOCOL);
        if (field == null) {
            return false;
        }
        return field.contains(test);
    }

    public boolean isSecure() {
        return false;
    }

    public void addExtensions(ExtensionConfig ... configs) {
    }

    public void addExtensions(String ... configs) {
    }

    public Object getSession() {
        return null;
    }

    public Principal getUserPrincipal() {
        return null;
    }

    public void setCookies(List<HttpCookie> cookies) {
    }

    public List<ExtensionConfig> getExtensions() {
        List rawExtensions = this.delegate.getHeaders().getValuesList(HttpHeader.SEC_WEBSOCKET_EXTENSIONS);
        if (rawExtensions == null || rawExtensions.isEmpty()) {
            return Collections.emptyList();
        }
        return rawExtensions.stream().map(parameterizedName -> ExtensionConfig.parse((String)parameterizedName)).collect(Collectors.toList());
    }

    public void setExtensions(List<ExtensionConfig> configs) {
    }

    public void setHeader(String name, List<String> values) {
    }

    public void setHeader(String name, String value) {
    }

    public void setHeaders(Map<String, List<String>> headers) {
    }

    public void setSession(Object session) {
    }

    public void setSubProtocols(List<String> protocols) {
    }

    public void setSubProtocols(String ... protocols) {
    }
}

