/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.client;

import java.net.HttpCookie;
import java.net.URI;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;

public final class ClientUpgradeRequest
implements UpgradeRequest {
    private URI requestURI;
    private List<String> subProtocols = new ArrayList<String>(1);
    private List<ExtensionConfig> extensions = new ArrayList<ExtensionConfig>(1);
    private List<HttpCookie> cookies = new ArrayList<HttpCookie>(1);
    private Map<String, List<String>> headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
    private Map<String, List<String>> parameters = new HashMap<String, List<String>>(1);
    private String httpVersion;
    private String method;
    private String host;
    public static final String ABNF_REQUIRED_QUOTING = "\"'\\\n\r\t\f\b%+ ;=";

    public ClientUpgradeRequest() {
    }

    public ClientUpgradeRequest(URI uri) {
        this.requestURI = uri;
        String scheme = uri.getScheme();
        if (!HttpScheme.WS.is(scheme) || !HttpScheme.WSS.is(scheme)) {
            throw new IllegalArgumentException("URI scheme must be 'ws' or 'wss'");
        }
        this.host = this.requestURI.getHost();
    }

    public void addExtensions(ExtensionConfig ... configs) {
        Collections.addAll(this.extensions, configs);
    }

    public void addExtensions(String ... configs) {
        for (String config : configs) {
            this.extensions.add(ExtensionConfig.parse((String)config));
        }
    }

    public List<HttpCookie> getCookies() {
        return this.cookies;
    }

    public void setCookies(List<HttpCookie> cookies) {
        this.cookies.clear();
        if (cookies != null && !cookies.isEmpty()) {
            this.cookies.addAll(cookies);
        }
    }

    public List<ExtensionConfig> getExtensions() {
        return this.extensions;
    }

    public void setExtensions(List<ExtensionConfig> configs) {
        this.extensions.clear();
        if (configs != null) {
            this.extensions.addAll(configs);
        }
    }

    public String getHeader(String name) {
        List<String> values = this.headers.get(name);
        return ClientUpgradeRequest.joinValues(values);
    }

    public int getHeaderInt(String name) {
        List<String> values = this.headers.get(name);
        if (values == null) {
            return -1;
        }
        int size = values.size();
        if (size <= 0) {
            return -1;
        }
        if (size == 1) {
            return Integer.parseInt(values.get(0));
        }
        throw new NumberFormatException("Cannot convert multi-value header into int");
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public List<String> getHeaders(String name) {
        return this.headers.get(name);
    }

    public String getHost() {
        return this.host;
    }

    public String getHttpVersion() {
        return this.httpVersion;
    }

    public String getMethod() {
        return this.method;
    }

    public String getOrigin() {
        return this.getHeader(HttpHeader.ORIGIN.name());
    }

    public Map<String, List<String>> getParameterMap() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public String getProtocolVersion() {
        String version = this.getHeader("Sec-WebSocket-Version");
        return Objects.requireNonNullElse(version, "13");
    }

    public String getQueryString() {
        return this.requestURI.getQuery();
    }

    public URI getRequestURI() {
        return this.requestURI;
    }

    public Object getSession() {
        throw new UnsupportedOperationException("HttpSession not available on Client request");
    }

    public List<String> getSubProtocols() {
        return this.subProtocols;
    }

    public Principal getUserPrincipal() {
        throw new UnsupportedOperationException("User Principal not available on Client request");
    }

    public void setSubProtocols(String ... protocols) {
        this.subProtocols.clear();
        Collections.addAll(this.subProtocols, protocols);
    }

    public void setSubProtocols(List<String> subProtocols) {
        this.subProtocols.clear();
        if (subProtocols != null) {
            this.subProtocols.addAll(subProtocols);
        }
    }

    public boolean hasSubProtocol(String test) {
        for (String protocol : this.subProtocols) {
            if (!protocol.equalsIgnoreCase(test)) continue;
            return true;
        }
        return false;
    }

    public boolean isSecure() {
        throw new UnsupportedOperationException("Request.isSecure not available on Client request");
    }

    public void setHeader(String name, List<String> values) {
        this.headers.put(name, values);
    }

    public void setHeader(String name, String value) {
        ArrayList<String> values = new ArrayList<String>();
        values.add(value);
        this.setHeader(name, values);
    }

    public void setHeaders(Map<String, List<String>> headers) {
        this.headers.clear();
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            String name = entry.getKey();
            List<String> values = entry.getValue();
            this.setHeader(name, values);
        }
    }

    public void setSession(Object session) {
        throw new UnsupportedOperationException("HttpSession not available on Client request");
    }

    public static String joinValues(List<String> values) {
        if (values == null) {
            return null;
        }
        int size = values.size();
        if (size <= 0) {
            return null;
        }
        if (size == 1) {
            return values.get(0);
        }
        boolean needsDelim = false;
        StringBuilder ret = new StringBuilder();
        for (String value : values) {
            if (needsDelim) {
                ret.append(", ");
            }
            ClientUpgradeRequest.quoteIfNeeded(ret, value, ABNF_REQUIRED_QUOTING);
            needsDelim = true;
        }
        return ret.toString();
    }

    private static void quoteIfNeeded(StringBuilder buf, String str, String delim) {
        if (str == null) {
            return;
        }
        int len = str.length();
        if (len == 0) {
            return;
        }
        for (int i = 0; i < len; ++i) {
            int ch = str.codePointAt(i);
            if (delim.indexOf(ch) < 0) continue;
            buf.append('\"');
            buf.append(str);
            buf.append('\"');
            return;
        }
        buf.append(str);
    }
}

