/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.client.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jetty.client.HttpResponse;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.websocket.api.UpgradeResponse;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;

public class DelegatedJettyClientUpgradeResponse
implements UpgradeResponse {
    private HttpResponse delegate;

    public DelegatedJettyClientUpgradeResponse(HttpResponse response) {
        this.delegate = response;
    }

    public String getAcceptedSubProtocol() {
        return this.delegate.getHeaders().get(HttpHeader.SEC_WEBSOCKET_SUBPROTOCOL);
    }

    public String getHeader(String name) {
        return this.delegate.getHeaders().get(name);
    }

    public Set<String> getHeaderNames() {
        return this.delegate.getHeaders().getFieldNamesCollection();
    }

    public List<String> getHeaders(String name) {
        return this.delegate.getHeaders().getValuesList(name);
    }

    public Map<String, List<String>> getHeaders() {
        return null;
    }

    public int getStatusCode() {
        return this.delegate.getStatus();
    }

    public void addHeader(String name, String value) {
    }

    public void sendForbidden(String message) throws IOException {
    }

    public void setAcceptedSubProtocol(String protocol) {
    }

    public List<ExtensionConfig> getExtensions() {
        List rawExtensions = this.delegate.getHeaders().getValuesList(HttpHeader.SEC_WEBSOCKET_EXTENSIONS);
        if (rawExtensions == null || rawExtensions.isEmpty()) {
            return Collections.emptyList();
        }
        return rawExtensions.stream().map(parameterizedName -> ExtensionConfig.parse((String)parameterizedName)).collect(Collectors.toList());
    }

    public void setExtensions(List<ExtensionConfig> extensions) {
    }

    public void setHeader(String name, String value) {
    }

    public void setStatusCode(int statusCode) {
    }
}

