/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.javax.server.internal;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.Function;
import javax.servlet.ServletContext;
import javax.websocket.DeploymentException;
import javax.websocket.EndpointConfig;
import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerEndpoint;
import javax.websocket.server.ServerEndpointConfig;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.http.pathmap.UriTemplatePathSpec;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.websocket.core.Configuration;
import org.eclipse.jetty.websocket.core.WebSocketComponents;
import org.eclipse.jetty.websocket.core.client.WebSocketCoreClient;
import org.eclipse.jetty.websocket.core.exception.WebSocketException;
import org.eclipse.jetty.websocket.core.server.WebSocketServerComponents;
import org.eclipse.jetty.websocket.javax.client.internal.JavaxWebSocketClientContainer;
import org.eclipse.jetty.websocket.javax.common.JavaxWebSocketContainer;
import org.eclipse.jetty.websocket.javax.server.internal.AnnotatedServerEndpointConfig;
import org.eclipse.jetty.websocket.javax.server.internal.JavaxWebSocketCreator;
import org.eclipse.jetty.websocket.javax.server.internal.JavaxWebSocketServerFrameHandlerFactory;
import org.eclipse.jetty.websocket.util.server.internal.FrameHandlerFactory;
import org.eclipse.jetty.websocket.util.server.internal.WebSocketCreator;
import org.eclipse.jetty.websocket.util.server.internal.WebSocketMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject(value="JSR356 Server Container")
public class JavaxWebSocketServerContainer
extends JavaxWebSocketClientContainer
implements ServerContainer,
LifeCycle.Listener {
    public static final String JAVAX_WEBSOCKET_CONTAINER_ATTRIBUTE = ServerContainer.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger(JavaxWebSocketServerContainer.class);
    private final WebSocketMapping webSocketMapping;
    private final JavaxWebSocketServerFrameHandlerFactory frameHandlerFactory;
    private List<Class<?>> deferredEndpointClasses;
    private List<ServerEndpointConfig> deferredEndpointConfigs;

    public static JavaxWebSocketServerContainer getContainer(ServletContext servletContext) {
        return (JavaxWebSocketServerContainer)((Object)servletContext.getAttribute(JAVAX_WEBSOCKET_CONTAINER_ATTRIBUTE));
    }

    public static JavaxWebSocketServerContainer ensureContainer(ServletContext servletContext) {
        ServletContextHandler contextHandler = ServletContextHandler.getServletContextHandler((ServletContext)servletContext, (String)"Javax Websocket");
        if (contextHandler.getServer() == null) {
            throw new IllegalStateException("Server has not been set on the ServletContextHandler");
        }
        JavaxWebSocketServerContainer container = JavaxWebSocketServerContainer.getContainer(servletContext);
        if (container == null) {
            Function<WebSocketComponents, WebSocketCoreClient> coreClientSupplier = arg_0 -> JavaxWebSocketServerContainer.lambda$ensureContainer$0(servletContext, (ContextHandler)contextHandler, arg_0);
            container = new JavaxWebSocketServerContainer(WebSocketMapping.ensureMapping((ServletContext)servletContext, (String)"org.eclipse.jetty.websocket.util.server.internal.WebSocketMapping"), WebSocketServerComponents.ensureWebSocketComponents((ServletContext)servletContext), coreClientSupplier);
            contextHandler.addManaged((LifeCycle)container);
            contextHandler.addEventListener((EventListener)((Object)container));
        }
        servletContext.setAttribute(JAVAX_WEBSOCKET_CONTAINER_ATTRIBUTE, (Object)container);
        return container;
    }

    public JavaxWebSocketServerContainer(WebSocketMapping webSocketMapping) {
        this(webSocketMapping, new WebSocketComponents());
    }

    public JavaxWebSocketServerContainer(WebSocketMapping webSocketMapping, WebSocketComponents components) {
        super(components);
        this.webSocketMapping = webSocketMapping;
        this.frameHandlerFactory = new JavaxWebSocketServerFrameHandlerFactory((JavaxWebSocketContainer)this);
    }

    public JavaxWebSocketServerContainer(WebSocketMapping webSocketMapping, WebSocketComponents components, Function<WebSocketComponents, WebSocketCoreClient> coreClientSupplier) {
        super(components, coreClientSupplier);
        this.webSocketMapping = webSocketMapping;
        this.frameHandlerFactory = new JavaxWebSocketServerFrameHandlerFactory((JavaxWebSocketContainer)this);
    }

    public void lifeCycleStopping(LifeCycle context) {
        ContextHandler contextHandler = (ContextHandler)context;
        JavaxWebSocketServerContainer container = (JavaxWebSocketServerContainer)((Object)contextHandler.getBean(JavaxWebSocketServerContainer.class));
        if (container == this) {
            contextHandler.removeBean((Object)container);
            LifeCycle.stop((Object)((Object)container));
        }
    }

    public JavaxWebSocketServerFrameHandlerFactory getFrameHandlerFactory() {
        return this.frameHandlerFactory;
    }

    public void addEndpoint(Class<?> endpointClass) throws DeploymentException {
        if (endpointClass == null) {
            throw new DeploymentException("EndpointClass is null");
        }
        if (this.isStarted() || this.isStarting()) {
            try {
                ServerEndpoint anno = endpointClass.getAnnotation(ServerEndpoint.class);
                if (anno == null) {
                    throw new DeploymentException(String.format("Class must be @%s annotated: %s", ServerEndpoint.class.getName(), endpointClass.getName()));
                }
                AnnotatedServerEndpointConfig config = new AnnotatedServerEndpointConfig((JavaxWebSocketContainer)this, endpointClass, anno);
                this.addEndpointMapping((ServerEndpointConfig)config);
            }
            catch (WebSocketException e) {
                throw new DeploymentException("Unable to deploy: " + endpointClass.getName(), (Throwable)e);
            }
        } else {
            if (this.deferredEndpointClasses == null) {
                this.deferredEndpointClasses = new ArrayList();
            }
            this.deferredEndpointClasses.add(endpointClass);
        }
    }

    public void addEndpoint(ServerEndpointConfig providedConfig) throws DeploymentException {
        if (providedConfig == null) {
            throw new DeploymentException("ServerEndpointConfig is null");
        }
        if (this.isStarted() || this.isStarting()) {
            Class endpointClass = providedConfig.getEndpointClass();
            try {
                Object config;
                ServerEndpoint anno = endpointClass.getAnnotation(ServerEndpoint.class);
                Object object = config = anno == null ? providedConfig : new AnnotatedServerEndpointConfig((JavaxWebSocketContainer)this, endpointClass, anno, (EndpointConfig)providedConfig);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("addEndpoint({}) path={} endpoint={}", new Object[]{config, config.getPath(), endpointClass});
                }
                this.addEndpointMapping((ServerEndpointConfig)config);
            }
            catch (WebSocketException e) {
                throw new DeploymentException("Unable to deploy: " + endpointClass.getName(), (Throwable)e);
            }
        } else {
            if (this.deferredEndpointConfigs == null) {
                this.deferredEndpointConfigs = new ArrayList<ServerEndpointConfig>();
            }
            this.deferredEndpointConfigs.add(providedConfig);
        }
    }

    private void addEndpointMapping(ServerEndpointConfig config) throws WebSocketException {
        this.frameHandlerFactory.getMetadata(config.getEndpointClass(), (EndpointConfig)config);
        JavaxWebSocketCreator creator = new JavaxWebSocketCreator((JavaxWebSocketContainer)this, config, this.getExtensionRegistry());
        UriTemplatePathSpec pathSpec = new UriTemplatePathSpec(config.getPath());
        this.webSocketMapping.addMapping((PathSpec)pathSpec, (WebSocketCreator)creator, (FrameHandlerFactory)this.frameHandlerFactory, (Configuration.Customizer)this.defaultCustomizer);
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.deferredEndpointClasses != null) {
            for (Class<?> endpointClass : this.deferredEndpointClasses) {
                this.addEndpoint(endpointClass);
            }
            this.deferredEndpointClasses.clear();
        }
        if (this.deferredEndpointConfigs != null) {
            for (ServerEndpointConfig config : this.deferredEndpointConfigs) {
                this.addEndpoint(config);
            }
            this.deferredEndpointConfigs.clear();
        }
    }

    private static /* synthetic */ WebSocketCoreClient lambda$ensureContainer$0(ServletContext servletContext, ContextHandler contextHandler, WebSocketComponents wsComponents) {
        WebSocketCoreClient coreClient = (WebSocketCoreClient)servletContext.getAttribute(WebSocketCoreClient.WEBSOCKET_CORECLIENT_ATTRIBUTE);
        if (coreClient == null) {
            Executor executor;
            HttpClient httpClient = (HttpClient)servletContext.getAttribute("org.eclipse.jetty.websocket.javax.HttpClient");
            if (httpClient == null) {
                httpClient = (HttpClient)contextHandler.getServer().getAttribute("org.eclipse.jetty.websocket.javax.HttpClient");
            }
            Executor executor2 = executor = httpClient == null ? null : httpClient.getExecutor();
            if (executor == null) {
                executor = (Executor)servletContext.getAttribute("org.eclipse.jetty.server.Executor");
            }
            if (executor == null) {
                executor = contextHandler.getServer().getThreadPool();
            }
            if (httpClient != null && httpClient.getExecutor() == null) {
                httpClient.setExecutor(executor);
            }
            coreClient = new WebSocketCoreClient(httpClient, wsComponents);
            coreClient.getHttpClient().setName("Javax-WebSocketClient@" + Integer.toHexString(coreClient.getHttpClient().hashCode()));
            if (executor != null && httpClient == null) {
                coreClient.getHttpClient().setExecutor(executor);
            }
            servletContext.setAttribute(WebSocketCoreClient.WEBSOCKET_CORECLIENT_ATTRIBUTE, (Object)coreClient);
        }
        return coreClient;
    }
}

