/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jakarta.server.internal;

import jakarta.websocket.server.PathParam;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.eclipse.jetty.websocket.util.InvalidSignatureException;
import org.eclipse.jetty.websocket.util.InvokerUtils;

public class PathParamIdentifier
implements InvokerUtils.ParamIdentifier {
    public InvokerUtils.Arg getParamArg(Method method, Class<?> paramType, int idx) {
        Annotation[] annos = method.getParameterAnnotations()[idx];
        if (annos != null || annos.length > 0) {
            for (Annotation anno : annos) {
                if (!anno.annotationType().equals(PathParam.class)) continue;
                PathParamIdentifier.validateType(paramType);
                PathParam pathParam = (PathParam)anno;
                return new InvokerUtils.Arg(paramType, pathParam.value());
            }
        }
        return new InvokerUtils.Arg(paramType);
    }

    public static void validateType(Class<?> type) {
        if (!(String.class.isAssignableFrom(type) || Integer.TYPE.isAssignableFrom(type) || Long.TYPE.isAssignableFrom(type) || Short.TYPE.isAssignableFrom(type) || Float.TYPE.isAssignableFrom(type) || Double.TYPE.isAssignableFrom(type) || Boolean.TYPE.isAssignableFrom(type) || Character.TYPE.isAssignableFrom(type) || Byte.TYPE.isAssignableFrom(type))) {
            throw new InvalidSignatureException("Unsupported PathParam Type: " + type);
        }
    }
}

