/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jakarta.server.config;

import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.HandlesTypes;
import jakarta.websocket.DeploymentException;
import jakarta.websocket.Endpoint;
import jakarta.websocket.server.ServerApplicationConfig;
import jakarta.websocket.server.ServerContainer;
import jakarta.websocket.server.ServerEndpoint;
import jakarta.websocket.server.ServerEndpointConfig;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.listener.ContainerInitializer;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.thread.ThreadClassLoaderScope;
import org.eclipse.jetty.websocket.core.WebSocketComponents;
import org.eclipse.jetty.websocket.core.server.WebSocketServerComponents;
import org.eclipse.jetty.websocket.jakarta.server.internal.JakartaWebSocketServerContainer;
import org.eclipse.jetty.websocket.util.server.WebSocketUpgradeFilter;
import org.eclipse.jetty.websocket.util.server.internal.WebSocketMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@HandlesTypes(value={ServerApplicationConfig.class, ServerEndpoint.class, Endpoint.class})
public class JakartaWebSocketServletContainerInitializer
implements ServletContainerInitializer {
    public static final String ATTR_JAKARTA_SERVER_CONTAINER = ServerContainer.class.getName();
    public static final String ENABLE_KEY = "org.eclipse.jetty.websocket.jakarta";
    public static final String HTTPCLIENT_ATTRIBUTE = "org.eclipse.jetty.websocket.jakarta.HttpClient";
    private static final Logger LOG = LoggerFactory.getLogger(JakartaWebSocketServletContainerInitializer.class);

    private static Boolean isEnabledViaContext(ServletContext context, String keyName) {
        String cp = context.getInitParameter(keyName);
        if (cp != null) {
            return TypeUtil.isTrue((Object)cp);
        }
        Object enable = context.getAttribute(keyName);
        if (enable != null) {
            return TypeUtil.isTrue((Object)enable);
        }
        return null;
    }

    public static void configure(ServletContextHandler context, Configurator configurator) {
        if (!context.isStopped()) {
            throw new IllegalStateException("configure should be called before starting");
        }
        context.getServletContext().setExtendedListenerTypes(true);
        context.addEventListener((EventListener)ContainerInitializer.asContextListener((ServletContainerInitializer)new JakartaWebSocketServletContainerInitializer()).afterStartup(servletContext -> {
            JakartaWebSocketServerContainer serverContainer = JakartaWebSocketServerContainer.getContainer(servletContext);
            if (configurator != null) {
                try {
                    configurator.accept((ServletContext)servletContext, serverContainer);
                }
                catch (DeploymentException e) {
                    throw new RuntimeException("Failed to deploy WebSocket Endpoint", e);
                }
            }
        }));
    }

    private static ServerContainer initialize(ServletContextHandler context) {
        JakartaWebSocketServerContainer serverContainer = JakartaWebSocketServerContainer.getContainer((ServletContext)context.getServletContext());
        if (serverContainer == null) {
            WebSocketComponents components = WebSocketServerComponents.ensureWebSocketComponents((Server)context.getServer(), (ServletContext)context.getServletContext());
            FilterHolder filterHolder = WebSocketUpgradeFilter.ensureFilter((ServletContext)context.getServletContext());
            WebSocketMapping mapping = WebSocketMapping.ensureMapping((ServletContext)context.getServletContext(), (String)"org.eclipse.jetty.websocket.util.server.internal.WebSocketMapping");
            serverContainer = JakartaWebSocketServerContainer.ensureContainer((ServletContext)context.getServletContext());
            if (LOG.isDebugEnabled()) {
                LOG.debug("configureContext {} {} {} {}", new Object[]{mapping, components, filterHolder, serverContainer});
            }
        }
        return serverContainer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onStartup(Set<Class<?>> c, ServletContext context) throws ServletException {
        Boolean enableKey = JakartaWebSocketServletContainerInitializer.isEnabledViaContext(context, ENABLE_KEY);
        boolean websocketEnabled = true;
        if (enableKey != null) {
            websocketEnabled = enableKey;
        }
        if (!websocketEnabled) {
            LOG.info("Jakarta Websocket is disabled by configuration for context {}", (Object)context.getContextPath());
            return;
        }
        ServletContextHandler servletContextHandler = ServletContextHandler.getServletContextHandler((ServletContext)context, (String)"Jakarta WebSocket SCI");
        ServerContainer container = JakartaWebSocketServletContainerInitializer.initialize(servletContextHandler);
        try (ThreadClassLoaderScope scope = new ThreadClassLoaderScope(context.getClassLoader());){
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found {} classes", (Object)c.size());
            }
            HashSet<Class<? extends Endpoint>> discoveredExtendedEndpoints = new HashSet<Class<? extends Endpoint>>();
            HashSet discoveredAnnotatedEndpoints = new HashSet();
            HashSet<Class<? extends ServerApplicationConfig>> serverAppConfigs = new HashSet<Class<? extends ServerApplicationConfig>>();
            this.filterClasses(c, discoveredExtendedEndpoints, discoveredAnnotatedEndpoints, serverAppConfigs);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Discovered {} extends Endpoint classes", (Object)discoveredExtendedEndpoints.size());
                LOG.debug("Discovered {} @ServerEndpoint classes", (Object)discoveredAnnotatedEndpoints.size());
                LOG.debug("Discovered {} ServerApplicationConfig classes", (Object)serverAppConfigs.size());
            }
            boolean wasFiltered = false;
            HashSet deployableExtendedEndpointConfigs = new HashSet();
            HashSet deployableAnnotatedEndpoints = new HashSet();
            for (Class clazz : serverAppConfigs) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Found ServerApplicationConfig: {}", (Object)clazz);
                }
                try {
                    Set annotatedClasses;
                    ServerApplicationConfig config = (ServerApplicationConfig)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    Set seconfigs = config.getEndpointConfigs(discoveredExtendedEndpoints);
                    if (seconfigs != null) {
                        wasFiltered = true;
                        deployableExtendedEndpointConfigs.addAll(seconfigs);
                    }
                    if ((annotatedClasses = config.getAnnotatedEndpointClasses(discoveredAnnotatedEndpoints)) == null) continue;
                    wasFiltered = true;
                    deployableAnnotatedEndpoints.addAll(annotatedClasses);
                }
                catch (Exception e) {
                    throw new ServletException("Unable to instantiate: " + clazz.getName(), (Throwable)e);
                }
            }
            if (!wasFiltered) {
                deployableAnnotatedEndpoints.addAll(discoveredAnnotatedEndpoints);
                deployableExtendedEndpointConfigs = new HashSet();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Deploying {} ServerEndpointConfig(s)", (Object)deployableExtendedEndpointConfigs.size());
            }
            for (ServerEndpointConfig serverEndpointConfig : deployableExtendedEndpointConfigs) {
                try {
                    container.addEndpoint(serverEndpointConfig);
                }
                catch (DeploymentException e) {
                    throw new ServletException((Throwable)e);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Deploying {} @ServerEndpoint(s)", (Object)deployableAnnotatedEndpoints.size());
            }
            for (Class clazz : deployableAnnotatedEndpoints) {
                try {
                    container.addEndpoint(clazz);
                }
                catch (DeploymentException e) {
                    throw new ServletException((Throwable)e);
                    return;
                }
            }
        }
    }

    private void filterClasses(Set<Class<?>> c, Set<Class<? extends Endpoint>> discoveredExtendedEndpoints, Set<Class<?>> discoveredAnnotatedEndpoints, Set<Class<? extends ServerApplicationConfig>> serverAppConfigs) {
        for (Class<?> clazz : c) {
            ServerEndpoint endpoint;
            if (ServerApplicationConfig.class.isAssignableFrom(clazz)) {
                serverAppConfigs.add(clazz);
            }
            if (Endpoint.class.isAssignableFrom(clazz)) {
                discoveredExtendedEndpoints.add(clazz);
            }
            if ((endpoint = clazz.getAnnotation(ServerEndpoint.class)) == null) continue;
            discoveredAnnotatedEndpoints.add(clazz);
        }
    }

    public static interface Configurator {
        public void accept(ServletContext var1, ServerContainer var2) throws DeploymentException;
    }
}

