/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.extensions.compress;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.BadPayloadException;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.OpCode;
import org.eclipse.jetty.websocket.common.extensions.AbstractExtension;
import org.eclipse.jetty.websocket.common.extensions.compress.ByteAccumulator;
import org.eclipse.jetty.websocket.common.frames.DataFrame;

public class DeflateFrameExtension
extends AbstractExtension {
    private static final boolean BFINAL_HACK = Boolean.parseBoolean(System.getProperty("jetty.websocket.bfinal.hack", "true"));
    private static final Logger LOG = Log.getLogger(DeflateFrameExtension.class);
    private static final int OVERHEAD = 64;
    private static final byte[] TAIL = new byte[]{0, 0, -1, -1};
    private int bufferSize = 65536;
    private Deflater compressor;
    private Inflater decompressor;

    @Override
    public String getName() {
        return "deflate-frame";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incomingFrame(Frame frame) {
        if (OpCode.isControlFrame(frame.getOpCode()) || !frame.isRsv1()) {
            this.nextIncomingFrame(frame);
            return;
        }
        if (!frame.hasPayload()) {
            this.nextIncomingFrame(frame);
            return;
        }
        ByteBuffer payload = frame.getPayload();
        int inlen = payload.remaining();
        byte[] compressed = new byte[inlen + TAIL.length];
        payload.get(compressed, 0, inlen);
        System.arraycopy(TAIL, 0, compressed, inlen, TAIL.length);
        int maxSize = Math.max(this.getPolicy().getMaxTextMessageSize(), this.getPolicy().getMaxBinaryMessageBufferSize());
        ByteAccumulator accumulator = new ByteAccumulator(maxSize);
        DataFrame out = new DataFrame(frame);
        out.setRsv1(false);
        Inflater inflater = this.decompressor;
        synchronized (inflater) {
            this.decompressor.setInput(compressed, 0, compressed.length);
            while (this.decompressor.getRemaining() > 0 && !this.decompressor.finished()) {
                byte[] outbuf = new byte[Math.min(inlen * 2, this.bufferSize)];
                try {
                    int len = this.decompressor.inflate(outbuf);
                    if (len == 0) {
                        if (this.decompressor.needsInput()) {
                            throw new BadPayloadException("Unable to inflate frame, not enough input on frame");
                        }
                        if (this.decompressor.needsDictionary()) {
                            throw new BadPayloadException("Unable to inflate frame, frame erroneously says it needs a dictionary");
                        }
                    }
                    if (len <= 0) continue;
                    accumulator.addBuffer(outbuf, 0, len);
                }
                catch (DataFormatException e) {
                    LOG.warn((Throwable)e);
                    throw new BadPayloadException((Throwable)e);
                }
            }
        }
        out.setPayload(accumulator.getByteBuffer(this.getBufferPool()));
        this.nextIncomingFrame(out);
    }

    @Override
    public boolean isRsv1User() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void outgoingFrame(Frame frame, WriteCallback callback) {
        if (OpCode.isControlFrame(frame.getOpCode())) {
            this.nextOutgoingFrame(frame, callback);
            return;
        }
        if (!frame.hasPayload()) {
            this.nextOutgoingFrame(frame, callback);
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("outgoingFrame({}, {}) - {}", new Object[]{OpCode.name(frame.getOpCode()), callback != null ? callback.getClass().getSimpleName() : "<null>", BufferUtil.toDetailString((ByteBuffer)frame.getPayload())});
        }
        byte[] uncompressed = BufferUtil.toArray((ByteBuffer)frame.getPayload());
        ArrayList<DataFrame> dframes = new ArrayList<DataFrame>();
        Deflater deflater = this.compressor;
        synchronized (deflater) {
            if (!this.compressor.finished()) {
                this.compressor.setInput(uncompressed, 0, uncompressed.length);
                byte[] compressed = new byte[uncompressed.length + 64];
                while (!this.compressor.needsInput()) {
                    byte b0;
                    int len = this.compressor.deflate(compressed, 0, compressed.length, 2);
                    ByteBuffer outbuf = this.getBufferPool().acquire(len, true);
                    BufferUtil.clearToFill((ByteBuffer)outbuf);
                    if (len > 0) {
                        outbuf.put(compressed, 0, len - 4);
                    }
                    BufferUtil.flipToFlush((ByteBuffer)outbuf, (int)0);
                    if (len > 0 && BFINAL_HACK && ((b0 = outbuf.get(0)) & 1) != 0) {
                        b0 = (byte)(b0 ^ 1);
                        outbuf.put(0, b0);
                    }
                    DataFrame out = new DataFrame(frame);
                    out.setRsv1(true);
                    out.setBufferPool(this.getBufferPool());
                    out.setPayload(outbuf);
                    if (!this.compressor.needsInput()) {
                        out.setFin(false);
                    }
                    dframes.add(out);
                }
            }
        }
        for (DataFrame df : dframes) {
            if (df.isFin()) {
                this.nextOutgoingFrame(df, callback);
                continue;
            }
            this.nextOutgoingFrame(df, null);
        }
    }

    @Override
    public void setConfig(ExtensionConfig config) {
        super.setConfig(config);
        boolean nowrap = true;
        this.compressor = new Deflater(9, nowrap);
        this.compressor.setStrategy(0);
        this.decompressor = new Inflater(nowrap);
    }

    @Override
    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[]";
    }
}

