/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.api.extensions.OutgoingFrames;
import org.eclipse.jetty.websocket.common.BlockingWriteCallback;
import org.eclipse.jetty.websocket.common.LogicalConnection;
import org.eclipse.jetty.websocket.common.WebSocketFrame;
import org.eclipse.jetty.websocket.common.frames.BinaryFrame;
import org.eclipse.jetty.websocket.common.frames.ContinuationFrame;
import org.eclipse.jetty.websocket.common.frames.DataFrame;
import org.eclipse.jetty.websocket.common.frames.PingFrame;
import org.eclipse.jetty.websocket.common.frames.PongFrame;
import org.eclipse.jetty.websocket.common.frames.TextFrame;
import org.eclipse.jetty.websocket.common.io.FutureWriteCallback;

public class WebSocketRemoteEndpoint
implements RemoteEndpoint {
    private static final WriteCallback NOOP_CALLBACK = new WriteCallback(){

        public void writeSuccess() {
        }

        public void writeFailed(Throwable x) {
        }
    };
    private static final Logger LOG = Log.getLogger(WebSocketRemoteEndpoint.class);
    public final LogicalConnection connection;
    public final OutgoingFrames outgoing;
    private static final int ASYNC_MASK = 65535;
    private static final int BLOCK_MASK = 65536;
    private static final int STREAM_MASK = 131072;
    private static final int PARTIAL_TEXT_MASK = 262144;
    private static final int PARTIAL_BINARY_MASK = 524288;
    private final AtomicInteger msgState = new AtomicInteger();
    private final BlockingWriteCallback blocker = new BlockingWriteCallback();

    public WebSocketRemoteEndpoint(LogicalConnection connection, OutgoingFrames outgoing) {
        if (connection == null) {
            throw new IllegalArgumentException("LogicalConnection cannot be null");
        }
        this.connection = connection;
        this.outgoing = outgoing;
    }

    private void blockingWrite(WebSocketFrame frame) throws IOException {
        this.uncheckedSendFrame(frame, this.blocker);
        this.blocker.block();
    }

    private boolean lockMsg(MsgType type) {
        while (true) {
            int state = this.msgState.get();
            switch (type) {
                case BLOCKING: {
                    if ((state & 0xC0000) != 0) {
                        throw new IllegalStateException(String.format("Partial message pending %x for %s", new Object[]{state, type}));
                    }
                    if ((state & 0x10000) != 0) {
                        throw new IllegalStateException(String.format("Blocking message pending %x for %s", new Object[]{state, type}));
                    }
                    if (!this.msgState.compareAndSet(state, state | 0x10000)) break;
                    return state == 0;
                }
                case ASYNC: {
                    if ((state & 0xC0000) != 0) {
                        throw new IllegalStateException(String.format("Partial message pending %x for %s", new Object[]{state, type}));
                    }
                    if ((state & 0xFFFF) == 65535) {
                        throw new IllegalStateException(String.format("Too many async sends: %x", state));
                    }
                    if (!this.msgState.compareAndSet(state, state + 1)) break;
                    return state == 0;
                }
                case STREAMING: {
                    if ((state & 0xC0000) != 0) {
                        throw new IllegalStateException(String.format("Partial message pending %x for %s", new Object[]{state, type}));
                    }
                    if ((state & 0x20000) != 0) {
                        throw new IllegalStateException(String.format("Already streaming %x for %s", new Object[]{state, type}));
                    }
                    if (!this.msgState.compareAndSet(state, state | 0x20000)) break;
                    return state == 0;
                }
                case PARTIAL_BINARY: {
                    if (state == 524288) {
                        return false;
                    }
                    if (state == 0 && this.msgState.compareAndSet(0, state | 0x80000)) {
                        return true;
                    }
                    throw new IllegalStateException(String.format("Cannot send %s in state %x", new Object[]{type, state}));
                }
                case PARTIAL_TEXT: {
                    if (state == 262144) {
                        return false;
                    }
                    if (state == 0 && this.msgState.compareAndSet(0, state | 0x40000)) {
                        return true;
                    }
                    throw new IllegalStateException(String.format("Cannot send %s in state %x", new Object[]{type, state}));
                }
            }
        }
    }

    private void unlockMsg(MsgType type) {
        while (true) {
            int state = this.msgState.get();
            switch (type) {
                case BLOCKING: {
                    if ((state & 0x10000) == 0) {
                        throw new IllegalStateException(String.format("Not Blocking in state %x", state));
                    }
                    if (!this.msgState.compareAndSet(state, state & 0xFFFEFFFF)) break;
                    return;
                }
                case ASYNC: {
                    if ((state & 0xFFFF) == 0) {
                        throw new IllegalStateException(String.format("Not Async in %x", state));
                    }
                    if (!this.msgState.compareAndSet(state, state - 1)) break;
                    return;
                }
                case STREAMING: {
                    if ((state & 0x20000) == 0) {
                        throw new IllegalStateException(String.format("Not Streaming in state %x", state));
                    }
                    if (!this.msgState.compareAndSet(state, state & 0xFFFDFFFF)) break;
                    return;
                }
                case PARTIAL_BINARY: {
                    if (this.msgState.compareAndSet(524288, 0)) {
                        return;
                    }
                    throw new IllegalStateException(String.format("Not Partial Binary in state %x", state));
                }
                case PARTIAL_TEXT: {
                    if (this.msgState.compareAndSet(262144, 0)) {
                        return;
                    }
                    throw new IllegalStateException(String.format("Not Partial Text in state %x", state));
                }
            }
        }
    }

    public InetSocketAddress getInetSocketAddress() {
        return this.connection.getRemoteAddress();
    }

    private Future<Void> sendAsyncFrame(WebSocketFrame frame) {
        FutureWriteCallback future = new FutureWriteCallback();
        this.uncheckedSendFrame(frame, future);
        return future;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendBytes(ByteBuffer data) throws IOException {
        this.lockMsg(MsgType.BLOCKING);
        try {
            this.connection.getIOState().assertOutputOpen();
            if (LOG.isDebugEnabled()) {
                LOG.debug("sendBytes with {}", new Object[]{BufferUtil.toDetailString((ByteBuffer)data)});
            }
            this.blockingWrite(new BinaryFrame().setPayload(data));
        }
        finally {
            this.unlockMsg(MsgType.BLOCKING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Void> sendBytesByFuture(ByteBuffer data) {
        this.lockMsg(MsgType.ASYNC);
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("sendBytesByFuture with {}", new Object[]{BufferUtil.toDetailString((ByteBuffer)data)});
            }
            Future<Void> future = this.sendAsyncFrame(new BinaryFrame().setPayload(data));
            return future;
        }
        finally {
            this.unlockMsg(MsgType.ASYNC);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendBytes(ByteBuffer data, WriteCallback callback) {
        this.lockMsg(MsgType.ASYNC);
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("sendBytes({}, {})", new Object[]{BufferUtil.toDetailString((ByteBuffer)data), callback});
            }
            this.uncheckedSendFrame(new BinaryFrame().setPayload(data), callback == null ? NOOP_CALLBACK : callback);
        }
        finally {
            this.unlockMsg(MsgType.ASYNC);
        }
    }

    public void uncheckedSendFrame(WebSocketFrame frame, WriteCallback callback) {
        try {
            this.connection.getIOState().assertOutputOpen();
            this.outgoing.outgoingFrame((Frame)frame, callback);
        }
        catch (IOException e) {
            callback.writeFailed((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPartialBytes(ByteBuffer fragment, boolean isLast) throws IOException {
        boolean first = this.lockMsg(MsgType.PARTIAL_BINARY);
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("sendPartialBytes({}, {})", new Object[]{BufferUtil.toDetailString((ByteBuffer)fragment), isLast});
            }
            DataFrame frame = first ? new BinaryFrame() : new ContinuationFrame();
            frame.setPayload(fragment);
            frame.setFin(isLast);
            this.blockingWrite(frame);
        }
        finally {
            if (isLast) {
                this.unlockMsg(MsgType.PARTIAL_BINARY);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPartialString(String fragment, boolean isLast) throws IOException {
        boolean first = this.lockMsg(MsgType.PARTIAL_TEXT);
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("sendPartialString({}, {})", new Object[]{fragment, isLast});
            }
            DataFrame frame = first ? new TextFrame() : new ContinuationFrame();
            frame.setPayload(BufferUtil.toBuffer((String)fragment, (Charset)StandardCharsets.UTF_8));
            frame.setFin(isLast);
            this.blockingWrite(frame);
        }
        finally {
            if (isLast) {
                this.unlockMsg(MsgType.PARTIAL_TEXT);
            }
        }
    }

    public void sendPing(ByteBuffer applicationData) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendPing with {}", new Object[]{BufferUtil.toDetailString((ByteBuffer)applicationData)});
        }
        this.sendAsyncFrame(new PingFrame().setPayload(applicationData));
    }

    public void sendPong(ByteBuffer applicationData) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendPong with {}", new Object[]{BufferUtil.toDetailString((ByteBuffer)applicationData)});
        }
        this.sendAsyncFrame(new PongFrame().setPayload(applicationData));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendString(String text) throws IOException {
        this.lockMsg(MsgType.BLOCKING);
        try {
            TextFrame frame = new TextFrame().setPayload(text);
            if (LOG.isDebugEnabled()) {
                LOG.debug("sendString with {}", new Object[]{BufferUtil.toDetailString((ByteBuffer)frame.getPayload())});
            }
            this.blockingWrite(frame);
        }
        finally {
            this.unlockMsg(MsgType.BLOCKING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<Void> sendStringByFuture(String text) {
        this.lockMsg(MsgType.ASYNC);
        try {
            TextFrame frame = new TextFrame().setPayload(text);
            if (LOG.isDebugEnabled()) {
                LOG.debug("sendStringByFuture with {}", new Object[]{BufferUtil.toDetailString((ByteBuffer)frame.getPayload())});
            }
            Future<Void> future = this.sendAsyncFrame(frame);
            return future;
        }
        finally {
            this.unlockMsg(MsgType.ASYNC);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendString(String text, WriteCallback callback) {
        this.lockMsg(MsgType.ASYNC);
        try {
            TextFrame frame = new TextFrame().setPayload(text);
            if (LOG.isDebugEnabled()) {
                LOG.debug("sendString({},{})", new Object[]{BufferUtil.toDetailString((ByteBuffer)frame.getPayload()), callback});
            }
            this.uncheckedSendFrame(frame, callback == null ? NOOP_CALLBACK : callback);
        }
        finally {
            this.unlockMsg(MsgType.ASYNC);
        }
    }

    private static enum MsgType {
        BLOCKING,
        ASYNC,
        STREAMING,
        PARTIAL_TEXT,
        PARTIAL_BINARY;

    }
}

