/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.io;

import java.nio.ByteBuffer;
import java.nio.channels.InterruptedByTimeoutException;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.util.FutureCallback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.io.AbstractWebSocketConnection;

public abstract class FrameBytes
extends FutureCallback<Void>
implements Runnable {
    private static final Logger LOG = Log.getLogger(FrameBytes.class);
    protected final AbstractWebSocketConnection connection;
    protected final Frame frame;
    protected volatile Scheduler.Task task;

    protected FrameBytes(AbstractWebSocketConnection connection, Frame frame) {
        this.connection = connection;
        this.frame = frame;
    }

    private void cancelTask() {
        Scheduler.Task task = this.task;
        if (task != null) {
            task.cancel();
        }
    }

    public void completed(Void v) {
        super.completed((Object)v);
        if (LOG.isDebugEnabled()) {
            LOG.debug("completed({}) - {}", new Object[]{v, this.getClass().getName()});
        }
        this.cancelTask();
        this.connection.complete(this);
        this.frame.notifySendSuccess();
    }

    public void failed(Void v, Throwable x) {
        super.failed((Object)v, x);
        if (x instanceof EofException) {
            LOG.warn("failed(" + v + ") - " + EofException.class, new Object[0]);
        } else {
            LOG.warn("failed(" + v + ")", x);
        }
        this.cancelTask();
        this.frame.notifySendFailed(x);
    }

    public abstract ByteBuffer getByteBuffer();

    @Override
    public void run() {
        this.connection.close();
        this.failed(null, (Throwable)new InterruptedByTimeoutException());
    }

    public String toString() {
        return this.frame.toString();
    }
}

