/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.io;

import java.nio.ByteBuffer;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.io.AbstractWebSocketConnection;
import org.eclipse.jetty.websocket.common.io.FrameBytes;

public class DataFrameBytes
extends FrameBytes {
    private static final Logger LOG = Log.getLogger(DataFrameBytes.class);
    private ByteBuffer buffer;

    public DataFrameBytes(AbstractWebSocketConnection connection, Frame frame) {
        super(connection, frame);
    }

    @Override
    public void completed(Void result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("completed({}) - frame.remaining() = {}", new Object[]{result, this.frame.remaining()});
        }
        this.connection.getBufferPool().release(this.buffer);
        if (this.frame.remaining() > 0) {
            LOG.debug("More to send", new Object[0]);
            this.connection.getQueue().prepend(this);
            this.connection.complete(this);
        } else {
            LOG.debug("Send complete", new Object[0]);
            super.completed(result);
        }
        this.connection.flush();
    }

    @Override
    public ByteBuffer getByteBuffer() {
        try {
            int windowSize = this.connection.getInputBufferSize();
            this.buffer = this.connection.getGenerator().generate(windowSize, this.frame);
            return this.buffer;
        }
        catch (Throwable x) {
            this.failed(null, x);
            return null;
        }
    }
}

