/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.common.extensions.mux;

import java.io.IOException;
import java.util.concurrent.Future;
import javax.net.websocket.SendResult;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.LogicalConnection;
import org.eclipse.jetty.websocket.common.extensions.AbstractExtension;
import org.eclipse.jetty.websocket.common.extensions.mux.Muxer;

public abstract class AbstractMuxExtension
extends AbstractExtension {
    private Muxer muxer;

    public abstract void configureMuxer(Muxer var1);

    public void incomingFrame(Frame frame) {
        this.muxer.incomingFrame(frame);
    }

    public Future<SendResult> outgoingFrame(Frame frame) throws IOException {
        return null;
    }

    @Override
    public void setConnection(LogicalConnection connection) {
        super.setConnection(connection);
        if (this.muxer != null) {
            throw new RuntimeException("Cannot reset muxer physical connection once established");
        }
        this.muxer = new Muxer(connection);
        this.configureMuxer(this.muxer);
    }
}

