/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.api;

import org.eclipse.jetty.websocket.api.MessageTooLargeException;
import org.eclipse.jetty.websocket.api.WebSocketBehavior;

public class WebSocketPolicy {
    private static final int KB = 1024;
    private long maxMessageSize = 65536L;
    private long idleTimeout = 300000L;
    private int inputBufferSize = 4096;
    private final WebSocketBehavior behavior;

    public static WebSocketPolicy newClientPolicy() {
        return new WebSocketPolicy(WebSocketBehavior.CLIENT);
    }

    public static WebSocketPolicy newServerPolicy() {
        return new WebSocketPolicy(WebSocketBehavior.SERVER);
    }

    public WebSocketPolicy(WebSocketBehavior behavior) {
        this.behavior = behavior;
    }

    public void assertValidMessageSize(int requestedSize) {
        if (this.maxMessageSize > 0L && (long)requestedSize > this.maxMessageSize) {
            throw new MessageTooLargeException("Requested message size [" + requestedSize + "] exceeds maximum size [" + this.maxMessageSize + "]");
        }
    }

    public WebSocketPolicy clonePolicy() {
        WebSocketPolicy clone = new WebSocketPolicy(this.behavior);
        clone.idleTimeout = this.idleTimeout;
        clone.maxMessageSize = this.maxMessageSize;
        clone.inputBufferSize = this.inputBufferSize;
        return clone;
    }

    public WebSocketBehavior getBehavior() {
        return this.behavior;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public int getInputBufferSize() {
        return this.inputBufferSize;
    }

    public long getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public void setInputBufferSize(int inputBufferSize) {
        this.inputBufferSize = inputBufferSize;
    }

    public void setMaxMessageSize(long maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }
}

