/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server.config;

import java.util.EventListener;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.listener.ContainerInitializer;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.core.WebSocketComponents;
import org.eclipse.jetty.websocket.server.JettyWebSocketServerContainer;
import org.eclipse.jetty.websocket.servlet.WebSocketMapping;
import org.eclipse.jetty.websocket.servlet.WebSocketUpgradeFilter;

public class JettyWebSocketServletContainerInitializer
implements ServletContainerInitializer {
    private static final Logger LOG = Log.getLogger(JettyWebSocketServletContainerInitializer.class);

    public static void configure(ServletContextHandler context, Configurator configurator) {
        context.addEventListener((EventListener)ContainerInitializer.asContextListener((ServletContainerInitializer)new JettyWebSocketServletContainerInitializer()).afterStartup(servletContext -> {
            if (configurator != null) {
                JettyWebSocketServerContainer container = JettyWebSocketServerContainer.getContainer(servletContext);
                configurator.accept((ServletContext)servletContext, container);
            }
        }));
    }

    public static JettyWebSocketServerContainer initialize(ServletContextHandler context) {
        WebSocketComponents components = WebSocketComponents.ensureWebSocketComponents((ServletContext)context.getServletContext());
        FilterHolder filterHolder = WebSocketUpgradeFilter.ensureFilter((ServletContext)context.getServletContext());
        WebSocketMapping mapping = WebSocketMapping.ensureMapping((ServletContext)context.getServletContext(), (String)"org.eclipse.jetty.websocket.servlet.WebSocketMapping");
        JettyWebSocketServerContainer container = JettyWebSocketServerContainer.ensureContainer((ServletContext)context.getServletContext());
        if (LOG.isDebugEnabled()) {
            LOG.debug("configureContext {} {} {} {}", new Object[]{container, mapping, filterHolder, components});
        }
        return container;
    }

    public void onStartup(Set<Class<?>> c, ServletContext context) {
        ServletContextHandler contextHandler = ServletContextHandler.getServletContextHandler((ServletContext)context, (String)"Jetty WebSocket SCI");
        JettyWebSocketServletContainerInitializer.initialize(contextHandler);
    }

    public static interface Configurator {
        public void accept(ServletContext var1, JettyWebSocketServerContainer var2);
    }
}

