/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.common.JettyExtensionConfig;
import org.eclipse.jetty.websocket.servlet.ServletUpgradeResponse;

public class JettyServerUpgradeResponse {
    private ServletUpgradeResponse upgradeResponse;

    JettyServerUpgradeResponse(ServletUpgradeResponse response) {
        this.upgradeResponse = response;
    }

    public void addHeader(String name, String value) {
        this.upgradeResponse.addHeader(name, value);
    }

    public void setHeader(String name, String value) {
        this.upgradeResponse.setHeader(name, value);
    }

    public void setHeader(String name, List<String> values) {
        this.upgradeResponse.setHeader(name, values);
    }

    public String getAcceptedSubProtocol() {
        return this.upgradeResponse.getAcceptedSubProtocol();
    }

    public List<ExtensionConfig> getExtensions() {
        return this.upgradeResponse.getExtensions().stream().map(JettyExtensionConfig::new).collect(Collectors.toList());
    }

    public String getHeader(String name) {
        return this.upgradeResponse.getHeader(name);
    }

    public Set<String> getHeaderNames() {
        return this.upgradeResponse.getHeaderNames();
    }

    public Map<String, List<String>> getHeadersMap() {
        return this.upgradeResponse.getHeadersMap();
    }

    public List<String> getHeaders(String name) {
        return this.upgradeResponse.getHeaders(name);
    }

    public int getStatusCode() {
        return this.upgradeResponse.getStatusCode();
    }

    public boolean isCommitted() {
        return this.upgradeResponse.isCommitted();
    }

    public void sendError(int statusCode, String message) throws IOException {
        this.upgradeResponse.sendError(statusCode, message);
    }

    public void sendForbidden(String message) throws IOException {
        this.upgradeResponse.sendForbidden(message);
    }

    public void setAcceptedSubProtocol(String protocol) {
        this.upgradeResponse.setAcceptedSubProtocol(protocol);
    }

    public void setExtensions(List<ExtensionConfig> configs) {
        this.upgradeResponse.setExtensions(configs.stream().map(c -> new org.eclipse.jetty.websocket.core.ExtensionConfig(c.getName(), c.getParameters())).collect(Collectors.toList()));
    }

    public void setStatusCode(int statusCode) {
        this.upgradeResponse.setStatusCode(statusCode);
    }
}

