/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jsr356.server.deploy;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import javax.websocket.Endpoint;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class DiscoveredEndpoints {
    private static final Logger LOG = Log.getLogger(DiscoveredEndpoints.class);
    private Set<LocatedClass> extendedEndpoints = new HashSet<LocatedClass>();
    private Set<LocatedClass> annotatedEndpoints = new HashSet<LocatedClass>();

    public static URI getArchiveURI(Class<?> clazz) {
        String resourceName = clazz.getName().replace('.', '/') + ".class";
        URL classUrl = clazz.getClassLoader().getResource(resourceName);
        if (classUrl == null) {
            return null;
        }
        try {
            URI uri = classUrl.toURI();
            String scheme = uri.getScheme();
            if (scheme.equalsIgnoreCase("jar")) {
                String ssp = uri.getSchemeSpecificPart();
                int idx = ssp.indexOf("!/");
                if (idx >= 0) {
                    ssp = ssp.substring(0, idx);
                }
                return URI.create(ssp);
            }
        }
        catch (URISyntaxException e) {
            LOG.warn("Class reference not a valid URI? " + classUrl, (Throwable)e);
        }
        return null;
    }

    public void addAnnotatedEndpoint(Class<?> endpoint) {
        this.annotatedEndpoints.add(new LocatedClass(endpoint));
    }

    public void addExtendedEndpoint(Class<? extends Endpoint> endpoint) {
        this.extendedEndpoints.add(new LocatedClass(endpoint));
    }

    public Set<Class<?>> getAnnotatedEndpoints() {
        HashSet endpoints = new HashSet();
        for (LocatedClass lc : this.annotatedEndpoints) {
            endpoints.add(lc.clazz);
        }
        return endpoints;
    }

    public void getArchiveSpecificAnnnotatedEndpoints(URI archiveURI, Set<Class<?>> archiveSpecificEndpoints) {
        for (LocatedClass lc : this.annotatedEndpoints) {
            if (archiveURI != null && !lc.location.getPath().equals(archiveURI.getPath())) continue;
            archiveSpecificEndpoints.add(lc.clazz);
        }
    }

    public void getArchiveSpecificExtendedEndpoints(URI archiveURI, Set<Class<? extends Endpoint>> archiveSpecificEndpoints) {
        for (LocatedClass lc : this.extendedEndpoints) {
            if (archiveURI != null && (!lc.location.getPath().equals(archiveURI.getPath()) || !Endpoint.class.isAssignableFrom(lc.clazz))) continue;
            archiveSpecificEndpoints.add(lc.clazz);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DiscoveredEndpoints [extendedEndpoints=");
        builder.append(this.extendedEndpoints);
        builder.append(", annotatedEndpoints=");
        builder.append(this.annotatedEndpoints);
        builder.append("]");
        return builder.toString();
    }

    private static class LocatedClass {
        private Class<?> clazz;
        private URI location;

        public LocatedClass(Class<?> clazz) {
            this.clazz = clazz;
            this.location = DiscoveredEndpoints.getArchiveURI(clazz);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("LocatedClass[");
            builder.append(this.clazz.getName());
            builder.append("]");
            return builder.toString();
        }
    }
}

