/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jsr356.endpoints;

import java.util.Map;
import javax.websocket.CloseReason;
import javax.websocket.EndpointConfig;
import javax.websocket.Session;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.extensions.Frame;
import org.eclipse.jetty.websocket.common.CloseInfo;
import org.eclipse.jetty.websocket.common.WebSocketSession;
import org.eclipse.jetty.websocket.common.events.AbstractEventDriver;
import org.eclipse.jetty.websocket.common.events.EventDriver;
import org.eclipse.jetty.websocket.jsr356.JsrSession;
import org.eclipse.jetty.websocket.jsr356.endpoints.EndpointInstance;
import org.eclipse.jetty.websocket.jsr356.metadata.EndpointMetadata;

public abstract class AbstractJsrEventDriver
extends AbstractEventDriver
implements EventDriver {
    protected final EndpointMetadata metadata;
    protected final EndpointConfig config;
    protected JsrSession jsrsession;
    private boolean hasCloseBeenCalled = false;

    public AbstractJsrEventDriver(WebSocketPolicy policy, EndpointInstance endpointInstance) {
        super(policy, endpointInstance.getEndpoint());
        this.config = endpointInstance.getConfig();
        this.metadata = endpointInstance.getMetadata();
    }

    public EndpointConfig getConfig() {
        return this.config;
    }

    public Session getJsrSession() {
        return this.jsrsession;
    }

    public EndpointMetadata getMetadata() {
        return this.metadata;
    }

    public abstract void init(JsrSession var1);

    public final void onClose(CloseInfo close) {
        if (this.hasCloseBeenCalled) {
            return;
        }
        this.hasCloseBeenCalled = true;
        CloseReason.CloseCode closecode = CloseReason.CloseCodes.getCloseCode((int)close.getStatusCode());
        CloseReason closereason = new CloseReason(closecode, close.getReason());
        this.onClose(closereason);
    }

    protected abstract void onClose(CloseReason var1);

    public void onFrame(Frame frame) {
    }

    public final void openSession(WebSocketSession session) {
        this.jsrsession = (JsrSession)session;
        this.jsrsession.init(this.config);
        this.init(this.jsrsession);
        super.openSession(session);
    }

    public void setEndpointconfig(EndpointConfig endpointconfig) {
        throw new RuntimeException("Why are you reconfiguring the endpoint?");
    }

    public abstract void setPathParameters(Map<String, String> var1);
}

