/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.version.issues;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jetty.toolchain.version.issues.IssueSyntax;

public class IssuePatterns {
    private List<Entry> list = new ArrayList<Entry>();

    public void add(IssueSyntax type, String regex) {
        Entry entry = new Entry();
        entry.syntax = type;
        entry.pattern = Pattern.compile(regex, 2);
        this.list.add(entry);
    }

    public Match find(String line) {
        for (Entry entry : this.list) {
            Matcher mat = entry.pattern.matcher(line);
            if (!mat.find()) continue;
            Match ret = new Match();
            ret.matcher = mat;
            ret.syntax = entry.syntax;
            return ret;
        }
        return null;
    }

    public Set<String> findAllIds(String line) {
        if (StringUtils.isBlank((CharSequence)line)) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> ids = new HashSet<String>();
        for (Entry entry : this.list) {
            Matcher mat = entry.pattern.matcher(line);
            int offset = 0;
            while (mat.find(offset)) {
                ids.add(mat.group(1));
                offset = mat.end();
            }
        }
        return ids;
    }

    private class Entry {
        IssueSyntax syntax;
        Pattern pattern;

        private Entry() {
        }
    }

    public class Match {
        private Matcher matcher;
        public IssueSyntax syntax;

        public String group(int group) {
            return this.matcher.group(group);
        }

        public int end() {
            return this.matcher.end();
        }
    }
}

