/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.version;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.FileUtils;
import org.eclipse.jetty.toolchain.version.AbstractVersionMojo;
import org.eclipse.jetty.toolchain.version.Release;
import org.eclipse.jetty.toolchain.version.VersionPattern;
import org.eclipse.jetty.toolchain.version.VersionText;
import org.eclipse.jetty.toolchain.version.git.GitCommand;

public class UpdateVersionTextMojo
extends AbstractVersionMojo {
    private String version;
    private String versionTextKey;
    private String versionTagKey;
    private boolean sortExisting = false;
    private boolean refreshTags = false;
    private boolean updateDate = false;
    private boolean copyGenerated;
    private boolean attachArtifact;
    private File versionTextOuputFile;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.hasVersionTextFile("gen-version-text")) {
            return;
        }
        try {
            String currentTagId;
            String commitMessage = "Updating VERSION.txt";
            VersionPattern verTextPattern = new VersionPattern(this.versionTextKey);
            VersionPattern verTagPattern = new VersionPattern(this.versionTagKey);
            VersionText versionText = new VersionText(verTextPattern);
            versionText.read(this.versionTextInputFile);
            versionText.setSortExisting(this.sortExisting);
            String updateVersionText = verTextPattern.toVersionId(this.version);
            String updateVersionGit = verTagPattern.toVersionId(this.version);
            this.getLog().debug((CharSequence)("raw version = " + this.version));
            this.getLog().debug((CharSequence)("updateVersionText (as it appears in VERSION.txt) = " + updateVersionText));
            this.getLog().debug((CharSequence)("updateVersionGit (as it appears to git tags) = " + updateVersionGit));
            Release rel = versionText.findRelease(updateVersionText);
            if (rel == null) {
                rel = new Release(updateVersionText);
                this.getLog().debug((CharSequence)("Not Found, creating new rel = " + rel));
                commitMessage = "Creating new version " + updateVersionText + " in VERSION.txt";
            } else {
                this.getLog().debug((CharSequence)("Using existing rel = " + rel));
                commitMessage = "Updating version " + updateVersionText + " in VERSION.txt";
            }
            this.getLog().info((CharSequence)("Updating version section: " + this.version));
            String priorTextVersion = versionText.getPriorVersion(updateVersionText);
            if (priorTextVersion == null) {
                priorTextVersion = versionText.getReleases().get(0).getVersion();
            }
            this.getLog().debug((CharSequence)("Prior version in VERSION.txt is " + priorTextVersion));
            GitCommand git = new GitCommand();
            git.setWorkDir(this.basedir);
            git.setLog(this.getLog());
            if (this.refreshTags) {
                this.getLog().info((CharSequence)"Fetching git tags from remote ...");
                if (!git.fetchTags()) {
                    throw new MojoFailureException("Unable to fetch git tags?");
                }
            }
            if (!verTextPattern.isMatch(priorTextVersion)) {
                StringBuilder err = new StringBuilder();
                err.append("Prior version [").append(priorTextVersion);
                err.append("] is not a valid version identifier.");
                err.append(" Does not conform to expected pattern [");
                err.append(this.versionTextKey).append("]");
                throw new MojoExecutionException(err.toString());
            }
            String priorGitVersion = verTextPattern.getLastVersion(this.versionTagKey);
            String priorTagId = git.findTagMatching(priorGitVersion);
            if (priorTagId == null) {
                this.getLog().warn((CharSequence)("Unable to find git tag id for prior version id [" + priorGitVersion + "] (defined in VERSION.txt as [" + priorTextVersion + "])"));
                this.getLog().info((CharSequence)("Adding empty version section to top for version id [" + updateVersionText + "]"));
                versionText.replaceOrPrepend(rel);
                this.generateVersion(versionText);
                return;
            }
            this.getLog().debug((CharSequence)("Tag for prior version [" + priorGitVersion + "] is " + priorTagId));
            String priorCommitId = git.getTagCommitId(priorTagId);
            this.getLog().debug((CharSequence)("Commit ID from [" + priorTagId + "]: " + priorCommitId));
            String currentCommitId = "HEAD";
            if (this.refreshTags && (currentTagId = git.findTagMatching(updateVersionText)) != null) {
                currentCommitId = git.getTagCommitId(currentTagId);
            }
            this.getLog().debug((CharSequence)("Commit ID to [" + updateVersionText + "]: " + currentCommitId));
            git.populateIssuesForRange(priorCommitId, currentCommitId, rel);
            if (rel.getReleasedOn() == null && this.updateDate) {
                rel.setReleasedOn(new Date());
            }
            versionText.replaceOrPrepend(rel);
            this.generateVersion(versionText);
            this.getLog().info((CharSequence)("Update complete. Here's your git command. (Copy/Paste)\ngit commit -m \"" + commitMessage + "\" " + this.versionTextInputFile.getName()));
        }
        catch (IOException e) {
            throw new MojoFailureException("Unable to generate replacement VERSION.txt", (Throwable)e);
        }
    }

    private void generateVersion(VersionText versionText) throws MojoFailureException, IOException {
        this.ensureDirectoryExists(this.versionTextOuputFile.getCanonicalFile().getParentFile());
        versionText.write(this.versionTextOuputFile);
        this.getLog().debug((CharSequence)("New VERSION.txt written at " + this.versionTextOuputFile.getAbsolutePath()));
        if (this.attachArtifact) {
            this.getLog().info((CharSequence)"Attaching generated VERSION.txt");
            this.getLog().debug((CharSequence)("Classifier = " + this.classifier));
            this.getLog().debug((CharSequence)("Type = " + this.type));
            this.projectHelper.attachArtifact(this.project, this.type, this.classifier, this.versionTextOuputFile);
        }
        if (this.copyGenerated) {
            this.getLog().info((CharSequence)"Copying generated VERSION.txt over input VERSION.txt");
            FileUtils.copyFile((File)this.versionTextOuputFile, (File)this.versionTextInputFile);
        }
    }
}

