/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.version.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public final class DateUtil {
    public static final TimeZone UTC = TimeZone.getTimeZone("UTC");

    public static SimpleDateFormat createIso8601Format() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
    }

    public static SimpleDateFormat createRfc2822Format() {
        return new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z");
    }

    public static String formatIso8601(Date date) {
        SimpleDateFormat formatter = DateUtil.createIso8601Format();
        formatter.setTimeZone(UTC);
        return formatter.format(date);
    }

    public static String formatRfc2822(Date date) {
        SimpleDateFormat formatter = DateUtil.createRfc2822Format();
        formatter.setTimeZone(UTC);
        return formatter.format(date);
    }

    public static Date parseIso8601(String rawstr) throws ParseException {
        return DateUtil.createIso8601Format().parse(rawstr);
    }
}

