/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.toolchain.version.issues;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.jetty.toolchain.version.issues.Issue;

public class IssueParser {
    private final List<Pattern> issue_id_patterns = new ArrayList<Pattern>();

    public IssueParser() {
        this.issue_id_patterns.add(Pattern.compile("^.[Bb]ug ([0-9]{6,}). "));
        this.issue_id_patterns.add(Pattern.compile("^([0-9]{6,}) "));
        this.issue_id_patterns.add(Pattern.compile("^.[Bb]ug (JETTY-[0-9]{2,}). "));
        this.issue_id_patterns.add(Pattern.compile("(JETTY-[0-9]{2,})[^0-9]"));
    }

    public Issue parseKnownIssue(String rawissue) {
        String raw = rawissue;
        if (StringUtils.isBlank((String)(raw = raw.replaceFirst("^ *[\\*\\+-] *", "")))) {
            return null;
        }
        Issue issue = this.parsePossibleIssue(raw);
        if (issue != null) {
            return issue;
        }
        raw = raw.trim();
        String specialId = "zz-" + raw.substring(0, Math.min(raw.length(), 70)).toLowerCase();
        return new Issue(specialId, raw);
    }

    public Issue parsePossibleIssue(String rawissue) {
        if (StringUtils.isBlank((String)rawissue)) {
            return null;
        }
        for (Pattern pat : this.issue_id_patterns) {
            String subject;
            Matcher mat = pat.matcher(subject = rawissue.trim());
            if (!mat.find()) continue;
            String id = mat.group(1);
            if ((subject = subject.substring(mat.end())).startsWith("- ")) {
                subject = subject.substring(2);
            }
            return new Issue(id, subject.trim());
        }
        return null;
    }
}

