/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.eclipse.jetty.io.AsyncEndPoint;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.nio.IndirectNIOBuffer;
import org.eclipse.jetty.io.nio.SelectChannelEndPoint;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.websocket.FrameHandlerD0;
import org.eclipse.jetty.websocket.FrameHandlerD1;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketBuffers;
import org.eclipse.jetty.websocket.WebSocketGenerator;
import org.eclipse.jetty.websocket.WebSocketGeneratorD00;
import org.eclipse.jetty.websocket.WebSocketGeneratorD01;
import org.eclipse.jetty.websocket.WebSocketParser;
import org.eclipse.jetty.websocket.WebSocketParserD00;
import org.eclipse.jetty.websocket.WebSocketParserD01;

public class WebSocketConnection
implements Connection,
WebSocket.Outbound {
    final IdleCheck _idle;
    final EndPoint _endp;
    final WebSocketParser _parser;
    final WebSocketGenerator _generator;
    final long _timestamp;
    final WebSocket _websocket;
    String _key1;
    String _key2;
    ByteArrayBuffer _hixieBytes;

    public WebSocketConnection(WebSocket websocket, EndPoint endpoint, int draft) throws IOException {
        this(websocket, endpoint, new WebSocketBuffers(8192), System.currentTimeMillis(), 300000, draft);
    }

    public WebSocketConnection(WebSocket websocket, EndPoint endpoint, WebSocketBuffers buffers, long timestamp, int maxIdleTime, int draft) throws IOException {
        if (endpoint instanceof AsyncEndPoint) {
            ((AsyncEndPoint)endpoint).cancelIdle();
        }
        this._endp = endpoint;
        this._endp.setMaxIdleTime(maxIdleTime);
        this._timestamp = timestamp;
        this._websocket = websocket;
        switch (draft) {
            case 1: {
                this._generator = new WebSocketGeneratorD01(buffers, this._endp);
                this._parser = new WebSocketParserD01(buffers, endpoint, new FrameHandlerD1(this, this._websocket));
                break;
            }
            default: {
                this._generator = new WebSocketGeneratorD00(buffers, this._endp);
                this._parser = new WebSocketParserD00(buffers, endpoint, new FrameHandlerD0(this._websocket));
            }
        }
        if (this._endp instanceof SelectChannelEndPoint) {
            final SelectChannelEndPoint scep = (SelectChannelEndPoint)this._endp;
            scep.cancelIdle();
            this._idle = new IdleCheck(){

                public void access(EndPoint endp) {
                    scep.scheduleIdle();
                }
            };
            scep.scheduleIdle();
        } else {
            this._idle = new IdleCheck(){

                public void access(EndPoint endp) {
                }
            };
        }
    }

    public void setHixieKeys(String key1, String key2) {
        this._key1 = key1;
        this._key2 = key2;
        this._hixieBytes = new IndirectNIOBuffer(16);
    }

    public Connection handle() throws IOException {
        try {
            if (this._hixieBytes != null) {
                Buffer buffer = this._parser.getBuffer();
                if (buffer != null && buffer.length() > 0) {
                    int l = buffer.length();
                    if (l > 8 - this._hixieBytes.length()) {
                        l = 8 - this._hixieBytes.length();
                    }
                    this._hixieBytes.put(buffer.peek(buffer.getIndex(), l));
                    buffer.skip(l);
                }
                while (this._endp.isOpen()) {
                    if (this._hixieBytes.length() == 8) {
                        this.doTheHixieHixieShake();
                        this._endp.flush((Buffer)this._hixieBytes);
                        this._hixieBytes = null;
                        this._endp.flush();
                        break;
                    }
                    int filled = this._endp.fill((Buffer)this._hixieBytes);
                    if (filled >= 0) continue;
                    this._endp.close();
                    break;
                }
                this._websocket.onConnect(this);
                WebSocketConnection filled = this;
                return filled;
            }
            boolean progress = true;
            while (progress) {
                int flushed = this._generator.flush();
                int filled = this._parser.parseNext();
                boolean bl = progress = flushed > 0 || filled > 0;
                if (filled >= 0 && flushed >= 0) continue;
                this._endp.close();
                break;
            }
        }
        catch (IOException e) {
            try {
                this._endp.close();
            }
            catch (IOException e2) {
                Log.ignore((Throwable)e2);
            }
            throw e;
        }
        finally {
            if (this._endp.isOpen()) {
                this._idle.access(this._endp);
                this.checkWriteable();
            }
        }
        return this;
    }

    private void doTheHixieHixieShake() {
        byte[] result = WebSocketConnection.doTheHixieHixieShake(WebSocketConnection.hixieCrypt(this._key1), WebSocketConnection.hixieCrypt(this._key2), this._hixieBytes.asArray());
        this._hixieBytes.clear();
        this._hixieBytes.put(result);
    }

    public boolean isOpen() {
        return this._endp != null && this._endp.isOpen();
    }

    public boolean isIdle() {
        return this._parser.isBufferEmpty() && this._generator.isBufferEmpty();
    }

    public boolean isSuspended() {
        return false;
    }

    public void closed() {
        this._websocket.onDisconnect();
    }

    public long getTimeStamp() {
        return this._timestamp;
    }

    public void sendMessage(String content) throws IOException {
        this.sendMessage((byte)0, content);
    }

    public void sendMessage(byte frame, String content) throws IOException {
        this._generator.addFrame(frame, content, this._endp.getMaxIdleTime());
        this._generator.flush();
        this.checkWriteable();
        this._idle.access(this._endp);
    }

    public void sendMessage(byte opcode, byte[] content, int offset, int length) throws IOException {
        this._generator.addFrame(opcode, content, offset, length, this._endp.getMaxIdleTime());
        this._generator.flush();
        this.checkWriteable();
        this._idle.access(this._endp);
    }

    public void sendFragment(boolean more, byte opcode, byte[] content, int offset, int length) throws IOException {
        this._generator.addFragment(more, opcode, content, offset, length, this._endp.getMaxIdleTime());
        this._generator.flush();
        this.checkWriteable();
        this._idle.access(this._endp);
    }

    public void disconnect() {
        try {
            this._generator.flush(this._endp.getMaxIdleTime());
            this._endp.close();
        }
        catch (IOException e) {
            Log.ignore((Throwable)e);
        }
    }

    public void fill(Buffer buffer) {
        this._parser.fill(buffer);
    }

    private void checkWriteable() {
        if (!this._generator.isBufferEmpty() && this._endp instanceof AsyncEndPoint) {
            ((AsyncEndPoint)this._endp).scheduleWrite();
        }
    }

    static long hixieCrypt(String key) {
        long number = 0L;
        int spaces = 0;
        for (char c : key.toCharArray()) {
            if (Character.isDigit(c)) {
                number = number * 10L + (long)(c - 48);
                continue;
            }
            if (c != ' ') continue;
            ++spaces;
        }
        return number / (long)spaces;
    }

    public static byte[] doTheHixieHixieShake(long key1, long key2, byte[] key3) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] fodder = new byte[16];
            fodder[0] = (byte)(0xFFL & key1 >> 24);
            fodder[1] = (byte)(0xFFL & key1 >> 16);
            fodder[2] = (byte)(0xFFL & key1 >> 8);
            fodder[3] = (byte)(0xFFL & key1);
            fodder[4] = (byte)(0xFFL & key2 >> 24);
            fodder[5] = (byte)(0xFFL & key2 >> 16);
            fodder[6] = (byte)(0xFFL & key2 >> 8);
            fodder[7] = (byte)(0xFFL & key2);
            for (int i = 0; i < 8; ++i) {
                fodder[8 + i] = key3[i];
            }
            md.update(fodder);
            byte[] result = md.digest();
            return result;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    private static interface IdleCheck {
        public void access(EndPoint var1);
    }
}

