/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.webapp;

import java.util.List;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.AbstractConfiguration;
import org.eclipse.jetty.webapp.MetaData;
import org.eclipse.jetty.webapp.WebAppContext;

public class FragmentConfiguration
extends AbstractConfiguration {
    public static final String FRAGMENT_RESOURCES = "org.eclipse.jetty.webFragments";

    public void preConfigure(WebAppContext context) throws Exception {
        if (!context.isConfigurationDiscovered()) {
            return;
        }
        this.findWebFragments(context, context.getMetaData());
    }

    public void configure(WebAppContext context) throws Exception {
        if (!context.isConfigurationDiscovered()) {
            return;
        }
        context.getMetaData().orderFragments();
    }

    public void postConfigure(WebAppContext context) throws Exception {
        context.setAttribute(FRAGMENT_RESOURCES, null);
    }

    public void findWebFragments(WebAppContext context, MetaData metaData) throws Exception {
        List frags = (List)context.getAttribute(FRAGMENT_RESOURCES);
        if (frags != null) {
            for (Resource frag : frags) {
                metaData.addFragment(frag, Resource.newResource((String)("jar:" + frag.getURL() + "!/META-INF/web-fragment.xml")));
            }
        }
    }
}

