/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util.ssl;

import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIMatcher;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.X509ExtendedKeyManager;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.ssl.SniX509ExtendedKeyManager;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class ExtendedSslContextFactory
extends SslContextFactory {
    static final Logger LOG = Log.getLogger(ExtendedSslContextFactory.class);
    private final Map<String, String> _aliases = new HashMap<String, String>();
    private final Map<String, String> _wild = new HashMap<String, String>();
    private boolean _useCipherSuitesOrder = true;

    public boolean isUseCipherSuitesOrder() {
        return this._useCipherSuitesOrder;
    }

    public void setUseCipherSuitesOrder(boolean useCipherSuitesOrder) {
        this._useCipherSuitesOrder = useCipherSuitesOrder;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this._aliases.clear();
        if (this._factory._keyStore != null) {
            for (String alias : Collections.list(this._factory._keyStore.aliases())) {
                boolean[] b;
                X509Certificate x509;
                Certificate certificate = this._factory._keyStore.getCertificate(alias);
                if (!"X.509".equals(certificate.getType()) || (x509 = (X509Certificate)certificate).getKeyUsage() != null && (b = x509.getKeyUsage())[5]) continue;
                boolean named = false;
                Collection<List<?>> altNames = x509.getSubjectAlternativeNames();
                if (altNames != null) {
                    for (List<?> list : altNames) {
                        if (((Number)list.get(0)).intValue() != 2) continue;
                        String cn = list.get(1).toString();
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Certificate san alias={} cn={} in {}", alias, cn, this._factory);
                        }
                        if (cn == null) continue;
                        named = true;
                        this._aliases.put(cn, alias);
                    }
                }
                if (named) continue;
                LdapName name = new LdapName(x509.getSubjectX500Principal().getName("RFC2253"));
                for (Rdn rdn : name.getRdns()) {
                    if (!rdn.getType().equalsIgnoreCase("cn")) continue;
                    String cn = rdn.getValue().toString();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Certificate cn alias={} cn={} in {}", alias, cn, this._factory);
                    }
                    if (cn == null || !cn.contains(".") || cn.contains(" ")) continue;
                    this._aliases.put(cn, alias);
                }
            }
        }
        this._wild.clear();
        for (String name : this._aliases.keySet()) {
            if (!name.startsWith("*.")) continue;
            this._wild.put(name.substring(1), this._aliases.get(name));
        }
        LOG.info("x509={} for {}", this._aliases, this);
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        this._aliases.clear();
    }

    @Override
    protected KeyManager[] getKeyManagers(KeyStore keyStore) throws Exception {
        KeyManager[] managers = super.getKeyManagers(keyStore);
        if (managers != null) {
            for (int idx = 0; idx < managers.length; ++idx) {
                if (!(managers[idx] instanceof X509ExtendedKeyManager)) continue;
                managers[idx] = new SniX509ExtendedKeyManager((X509ExtendedKeyManager)managers[idx], this.getCertAlias());
            }
        }
        LOG.debug("managers={} for {}", managers, this);
        return managers;
    }

    @Override
    public void customize(SSLEngine sslEngine) {
        super.customize(sslEngine);
        SSLParameters sslParams = sslEngine.getSSLParameters();
        sslParams.setUseCipherSuitesOrder(this._useCipherSuitesOrder);
        sslParams.setSNIMatchers(Collections.singletonList(new AliasSNIMatcher()));
        sslEngine.setSSLParameters(sslParams);
    }

    class AliasSNIMatcher
    extends SNIMatcher {
        private String _alias;
        private SNIHostName _name;

        protected AliasSNIMatcher() {
            super(0);
        }

        @Override
        public boolean matches(SNIServerName serverName) {
            LOG.debug("matches={} for {}", serverName, this);
            if (ExtendedSslContextFactory.this._aliases.size() == 0 && ExtendedSslContextFactory.this._wild.size() == 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No SNI ready certificates for {} in {}", serverName, ExtendedSslContextFactory.this);
                }
                return true;
            }
            if (serverName instanceof SNIHostName) {
                this._name = (SNIHostName)serverName;
                if (this._name == null || ExtendedSslContextFactory.this._aliases.size() == 0) {
                    return true;
                }
                this._alias = (String)ExtendedSslContextFactory.this._aliases.get(this._name.getAsciiName());
                if (this._alias != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("matched {}->{}", this._name.getAsciiName(), this._alias);
                    }
                    return true;
                }
                String domain = this._name.getAsciiName();
                domain = domain.substring(domain.indexOf(46));
                this._alias = (String)ExtendedSslContextFactory.this._wild.get(domain);
                if (this._alias != null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("wild match {}->{}", this._name.getAsciiName(), this._alias);
                    }
                    return true;
                }
            }
            return false;
        }

        public String getAlias() {
            return this._alias;
        }

        public String getServerName() {
            return this._name == null ? null : this._name.getAsciiName();
        }
    }
}

