/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.internal;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.WritePendingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.ComplianceViolation;
import org.eclipse.jetty.http.HostPortHttpField;
import org.eclipse.jetty.http.HttpCompliance;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http.Trailers;
import org.eclipse.jetty.http.UriCompliance;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.io.Retainable;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.io.RetainableByteBufferPool;
import org.eclipse.jetty.io.WriteFlusher;
import org.eclipse.jetty.io.ssl.SslConnection;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.ConnectionMetaData;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpStream;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.TunnelSupport;
import org.eclipse.jetty.server.internal.HttpChannelState;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.HostPort;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.NanoTime;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.thread.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpConnection
extends AbstractConnection
implements Runnable,
WriteFlusher.Listener,
Connection.UpgradeFrom,
Connection.UpgradeTo,
ConnectionMetaData {
    private static final Logger LOG = LoggerFactory.getLogger(HttpConnection.class);
    private static final HttpField PREAMBLE_UPGRADE_H2C = new HttpField(HttpHeader.UPGRADE, "h2c");
    private static final ThreadLocal<HttpConnection> __currentConnection = new ThreadLocal();
    private static final AtomicLong __connectionIdGenerator = new AtomicLong();
    private final TunnelSupport _tunnelSupport = new TunnelSupportOverHTTP1();
    private final AtomicLong _streamIdGenerator = new AtomicLong();
    private final long _id;
    private final HttpConfiguration _configuration;
    private final Connector _connector;
    private final HttpChannel _httpChannel;
    private final RequestHandler _requestHandler;
    private final HttpParser _parser;
    private final HttpGenerator _generator;
    private final ByteBufferPool _bufferPool;
    private final RetainableByteBufferPool _retainableByteBufferPool;
    private final AtomicReference<HttpStreamOverHTTP1> _stream = new AtomicReference();
    private final Attributes.Lazy _attributes = new Attributes.Lazy();
    private final DemandContentCallback _demandContentCallback = new DemandContentCallback();
    private final SendCallback _sendCallback = new SendCallback();
    private final boolean _recordHttpComplianceViolations;
    private final LongAdder bytesIn = new LongAdder();
    private final LongAdder bytesOut = new LongAdder();
    private final AtomicBoolean _handling = new AtomicBoolean(false);
    private final HttpFields.Mutable _headerBuilder = HttpFields.build();
    private volatile RetainableByteBuffer _retainableByteBuffer;
    private HttpFields.Mutable _trailers;
    private Runnable _onRequest;
    private long _requests;
    private boolean _useInputDirectByteBuffers;
    private boolean _useOutputDirectByteBuffers;

    public static HttpConnection getCurrentConnection() {
        return __currentConnection.get();
    }

    protected static HttpConnection setCurrentConnection(HttpConnection connection) {
        HttpConnection last = __currentConnection.get();
        __currentConnection.set(connection);
        return last;
    }

    public HttpConnection(HttpConfiguration configuration, Connector connector, EndPoint endPoint, boolean recordComplianceViolations) {
        super(endPoint, connector.getExecutor());
        this._id = __connectionIdGenerator.getAndIncrement();
        this._configuration = configuration;
        this._connector = connector;
        this._bufferPool = this._connector.getByteBufferPool();
        this._retainableByteBufferPool = this._bufferPool.asRetainableByteBufferPool();
        this._generator = this.newHttpGenerator();
        this._httpChannel = this.newHttpChannel(connector.getServer(), configuration);
        this._requestHandler = this.newRequestHandler();
        this._parser = this.newHttpParser(configuration.getHttpCompliance());
        this._recordHttpComplianceViolations = recordComplianceViolations;
        if (LOG.isDebugEnabled()) {
            LOG.debug("New HTTP Connection {}", (Object)this);
        }
    }

    public Invocable.InvocationType getInvocationType() {
        return this.getServer().getInvocationType();
    }

    public boolean isRecordHttpComplianceViolations() {
        return this._recordHttpComplianceViolations;
    }

    protected HttpGenerator newHttpGenerator() {
        return new HttpGenerator(this._configuration.getSendServerVersion(), this._configuration.getSendXPoweredBy());
    }

    protected HttpParser newHttpParser(HttpCompliance compliance) {
        HttpParser parser = new HttpParser((HttpParser.RequestHandler)this._requestHandler, this.getHttpConfiguration().getRequestHeaderSize(), compliance);
        parser.setHeaderCacheSize(this.getHttpConfiguration().getHeaderCacheSize());
        parser.setHeaderCacheCaseSensitive(this.getHttpConfiguration().isHeaderCacheCaseSensitive());
        return parser;
    }

    protected HttpChannel newHttpChannel(Server server, HttpConfiguration configuration) {
        return new HttpChannelState(this);
    }

    protected HttpStreamOverHTTP1 newHttpStream(String method, String uri, HttpVersion version) {
        return new HttpStreamOverHTTP1(method, uri, version);
    }

    protected RequestHandler newRequestHandler() {
        return new RequestHandler();
    }

    public Server getServer() {
        return this._connector.getServer();
    }

    @Override
    public Connector getConnector() {
        return this._connector;
    }

    public HttpChannel getHttpChannel() {
        return this._httpChannel;
    }

    public HttpParser getParser() {
        return this._parser;
    }

    public HttpGenerator getGenerator() {
        return this._generator;
    }

    @Override
    public String getId() {
        return "%s@%x#%d".formatted(this.getEndPoint().getRemoteSocketAddress(), this.hashCode(), this._id);
    }

    @Override
    public HttpConfiguration getHttpConfiguration() {
        return this._configuration;
    }

    @Override
    public HttpVersion getHttpVersion() {
        HttpStreamOverHTTP1 stream = this._stream.get();
        return stream != null ? stream._version : HttpVersion.HTTP_1_1;
    }

    @Override
    public String getProtocol() {
        return this.getHttpVersion().asString();
    }

    @Override
    public Connection getConnection() {
        return this;
    }

    @Override
    public boolean isPersistent() {
        return this._generator.isPersistent(this.getHttpVersion());
    }

    @Override
    public boolean isSecure() {
        return this.getEndPoint() instanceof SslConnection.DecryptedEndPoint;
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return this.getEndPoint().getRemoteSocketAddress();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        SocketAddress override;
        HttpConfiguration config = this.getHttpConfiguration();
        if (config != null && (override = config.getLocalAddress()) != null) {
            return override;
        }
        return this.getEndPoint().getLocalSocketAddress();
    }

    @Override
    public HostPort getServerAuthority() {
        HostPort authority = ConnectionMetaData.getServerAuthority(this.getHttpConfiguration(), this);
        if (authority == null) {
            authority = new HostPort(this.getLocalSocketAddress().toString(), -1);
        }
        return authority;
    }

    public Object removeAttribute(String name) {
        return this._attributes.removeAttribute(name);
    }

    public Object setAttribute(String name, Object attribute) {
        return this._attributes.setAttribute(name, attribute);
    }

    public Object getAttribute(String name) {
        return this._attributes.getAttribute(name);
    }

    public Set<String> getAttributeNameSet() {
        return this._attributes.getAttributeNameSet();
    }

    public void clearAttributes() {
        this._attributes.clearAttributes();
    }

    public long getMessagesIn() {
        return this._requests;
    }

    public long getMessagesOut() {
        return this._requests;
    }

    public boolean isUseInputDirectByteBuffers() {
        return this._useInputDirectByteBuffers;
    }

    public void setUseInputDirectByteBuffers(boolean useInputDirectByteBuffers) {
        this._useInputDirectByteBuffers = useInputDirectByteBuffers;
    }

    public boolean isUseOutputDirectByteBuffers() {
        return this._useOutputDirectByteBuffers;
    }

    public void setUseOutputDirectByteBuffers(boolean useOutputDirectByteBuffers) {
        this._useOutputDirectByteBuffers = useOutputDirectByteBuffers;
    }

    public ByteBuffer onUpgradeFrom() {
        if (!this.isRequestBufferEmpty()) {
            ByteBuffer unconsumed = ByteBuffer.allocateDirect(this._retainableByteBuffer.remaining());
            unconsumed.put(this._retainableByteBuffer.getBuffer());
            unconsumed.flip();
            this.releaseRequestBuffer();
            return unconsumed;
        }
        return null;
    }

    public void onUpgradeTo(ByteBuffer buffer) {
        BufferUtil.append((ByteBuffer)this.getRequestBuffer(), (ByteBuffer)buffer);
    }

    public void onFlushed(long bytes) throws IOException {
    }

    void releaseRequestBuffer() {
        if (this._retainableByteBuffer != null && !this._retainableByteBuffer.hasRemaining()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("releaseRequestBuffer {}", (Object)this);
            }
            if (this._retainableByteBuffer.release()) {
                this._retainableByteBuffer = null;
            } else {
                throw new IllegalStateException("unreleased buffer " + String.valueOf(this._retainableByteBuffer));
            }
        }
    }

    private ByteBuffer getRequestBuffer() {
        if (this._retainableByteBuffer == null) {
            this._retainableByteBuffer = this._retainableByteBufferPool.acquire(this.getInputBufferSize(), this.isUseInputDirectByteBuffers());
        }
        return this._retainableByteBuffer.getBuffer();
    }

    public boolean isRequestBufferEmpty() {
        return this._retainableByteBuffer == null || this._retainableByteBuffer.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFillable() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">>onFillable enter {} {} {}", new Object[]{this, this._httpChannel, this._retainableByteBuffer});
        }
        HttpConnection last = HttpConnection.setCurrentConnection(this);
        try {
            while (this.getEndPoint().isOpen()) {
                int filled;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("onFillable fill and parse {} {} {}", new Object[]{this, this._httpChannel, this._retainableByteBuffer});
                }
                if ((filled = this.fillRequestBuffer()) < 0 && this.getEndPoint().isOutputShutdown()) {
                    this.close();
                }
                boolean handle = this.parseRequestBuffer();
                if (this.getEndPoint().getConnection() != this) break;
                if (handle) {
                    Request request = this._httpChannel.getRequest();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("HANDLE {} {}", (Object)request, (Object)this);
                    }
                    this._handling.set(true);
                    Runnable onRequest = this._onRequest;
                    this._onRequest = null;
                    onRequest.run();
                    if (this._handling.compareAndSet(true, false)) {
                        if (!LOG.isDebugEnabled()) break;
                        LOG.debug("request !complete {} {}", (Object)request, (Object)this);
                        break;
                    }
                    if (this.getEndPoint().getConnection() == this) continue;
                    if (!LOG.isDebugEnabled()) break;
                    LOG.debug("upgraded {} -> {}", (Object)this, (Object)this.getEndPoint().getConnection());
                    break;
                }
                if (filled < 0) {
                    this.getEndPoint().shutdownOutput();
                    break;
                }
                if (this._requestHandler._failure != null) break;
                if (filled != 0) continue;
                this.fillInterested();
                break;
            }
        }
        catch (Throwable x) {
            try {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("caught exception {} {}", new Object[]{this, this._httpChannel, x});
                    }
                    if (this._retainableByteBuffer != null) {
                        this._retainableByteBuffer.clear();
                        this.releaseRequestBuffer();
                    }
                }
                finally {
                    this.getEndPoint().close(x);
                }
            }
            catch (Throwable throwable) {
                HttpConnection.setCurrentConnection(last);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("<<onFillable exit {} {} {}", new Object[]{this, this._httpChannel, this._retainableByteBuffer});
                }
                throw throwable;
            }
            HttpConnection.setCurrentConnection(last);
            if (LOG.isDebugEnabled()) {
                LOG.debug("<<onFillable exit {} {} {}", new Object[]{this, this._httpChannel, this._retainableByteBuffer});
            }
        }
        HttpConnection.setCurrentConnection(last);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<<onFillable exit {} {} {}", new Object[]{this, this._httpChannel, this._retainableByteBuffer});
        }
    }

    void parseAndFillForContent() {
        if (this._parser.isTerminated()) {
            this._requestHandler.messageComplete();
            return;
        }
        while (!(!this._parser.inContentState() || this.parseRequestBuffer() || this._parser.inContentState() && this.fillRequestBuffer() <= 0)) {
        }
    }

    private int fillRequestBuffer() {
        if (this._retainableByteBuffer != null && this._retainableByteBuffer.isRetained()) {
            RetainableByteBuffer newBuffer = this._retainableByteBufferPool.acquire(this.getInputBufferSize(), this.isUseInputDirectByteBuffers());
            if (LOG.isDebugEnabled()) {
                LOG.debug("replace buffer {} <- {} in {}", new Object[]{this._retainableByteBuffer, newBuffer, this});
            }
            this._retainableByteBuffer.release();
            this._retainableByteBuffer = newBuffer;
        }
        if (this.isRequestBufferEmpty()) {
            ByteBuffer requestBuffer = this.getRequestBuffer();
            try {
                int filled = this.getEndPoint().fill(requestBuffer);
                if (filled == 0) {
                    filled = this.getEndPoint().fill(requestBuffer);
                }
                if (filled > 0) {
                    this.bytesIn.add(filled);
                } else if (filled < 0) {
                    this._parser.atEOF();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} filled {} {}", new Object[]{this, filled, this._retainableByteBuffer});
                }
                return filled;
            }
            catch (IOException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Unable to fill from endpoint {}", (Object)this.getEndPoint(), (Object)e);
                }
                this._parser.atEOF();
                return -1;
            }
        }
        return 0;
    }

    private boolean parseRequestBuffer() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} parse {}", (Object)this, (Object)this._retainableByteBuffer);
        }
        boolean handle = this._parser.parseNext(this._retainableByteBuffer == null ? BufferUtil.EMPTY_BUFFER : this._retainableByteBuffer.getBuffer());
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} parsed {} {}", new Object[]{this, handle, this._parser});
        }
        if (this._retainableByteBuffer != null && !this._retainableByteBuffer.isRetained()) {
            this.releaseRequestBuffer();
        }
        return handle;
    }

    private boolean upgrade(HttpStreamOverHTTP1 stream) {
        if (stream.upgrade()) {
            this._httpChannel.recycle();
            this._parser.close();
            this._generator.reset();
            return true;
        }
        return false;
    }

    protected void onFillInterestedFailed(Throwable cause) {
        this._parser.close();
        super.onFillInterestedFailed(cause);
    }

    public void onOpen() {
        super.onOpen();
        if (this.isRequestBufferEmpty()) {
            this.fillInterested();
        } else {
            this.getExecutor().execute(this);
        }
    }

    public void onClose(Throwable cause) {
        if (cause == null) {
            this._sendCallback.close();
        } else {
            this._sendCallback.failed(cause);
        }
        super.onClose(cause);
    }

    @Override
    public void run() {
        this.onFillable();
    }

    public void asyncReadFillInterested() {
        this.getEndPoint().tryFillInterested((Callback)this._demandContentCallback);
    }

    public long getBytesIn() {
        return this.bytesIn.longValue();
    }

    public long getBytesOut() {
        return this.bytesOut.longValue();
    }

    public String toConnectionString() {
        return String.format("%s@%x[p=%s,g=%s]=>%s", this.getClass().getSimpleName(), this.hashCode(), this._parser, this._generator, this._httpChannel);
    }

    private class TunnelSupportOverHTTP1
    implements TunnelSupport {
        private TunnelSupportOverHTTP1() {
        }

        @Override
        public String getProtocol() {
            return null;
        }

        @Override
        public EndPoint getEndPoint() {
            return HttpConnection.this.getEndPoint();
        }
    }

    private class DemandContentCallback
    implements Callback {
        private DemandContentCallback() {
        }

        public void succeeded() {
            Runnable task = HttpConnection.this._httpChannel.onContentAvailable();
            if (LOG.isDebugEnabled()) {
                LOG.debug("demand succeeded {}", (Object)task);
            }
            if (task != null) {
                task.run();
            }
        }

        public void failed(Throwable x) {
            Runnable task = HttpConnection.this._httpChannel.onFailure(x);
            if (LOG.isDebugEnabled()) {
                LOG.debug("demand failed {}", (Object)task, (Object)x);
            }
            if (task != null) {
                HttpConnection.this.getConnector().getExecutor().execute(task);
            }
        }

        public Invocable.InvocationType getInvocationType() {
            return Invocable.getInvocationType((Object)HttpConnection.this._httpChannel);
        }
    }

    private class SendCallback
    extends IteratingCallback {
        private MetaData.Response _info;
        private boolean _head;
        private ByteBuffer _content;
        private boolean _lastContent;
        private Callback _callback;
        private ByteBuffer _header;
        private ByteBuffer _chunk;
        private boolean _shutdownOut;

        private SendCallback() {
            super(true);
        }

        public Invocable.InvocationType getInvocationType() {
            return this._callback.getInvocationType();
        }

        private boolean reset(MetaData.Request request, MetaData.Response response, ByteBuffer content, boolean last, Callback callback) {
            if (this.reset()) {
                this._info = response;
                this._head = request != null && HttpMethod.HEAD.is(request.getMethod());
                this._content = content;
                this._lastContent = last;
                this._callback = callback;
                this._header = null;
                if (HttpConnection.this.getConnector().isShutdown()) {
                    HttpConnection.this._generator.setPersistent(false);
                }
                return true;
            }
            if (this.isClosed() && response == null && last && content == null) {
                callback.succeeded();
                return false;
            }
            LOG.warn("reset failed {}", (Object)this);
            if (this.isClosed()) {
                callback.failed((Throwable)new EofException());
            } else {
                callback.failed((Throwable)new WritePendingException());
            }
            return false;
        }

        public IteratingCallback.Action process() throws Exception {
            HttpGenerator.Result result;
            if (this._callback == null) {
                throw new IllegalStateException();
            }
            boolean useDirectByteBuffers = HttpConnection.this.isUseOutputDirectByteBuffers();
            block20: while (true) {
                result = HttpConnection.this._generator.generateResponse(this._info, this._head, this._header, this._chunk, this._content, this._lastContent);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("generate: {} for {} ({},{},{})@{}", new Object[]{result, this, BufferUtil.toSummaryString((ByteBuffer)this._header), BufferUtil.toSummaryString((ByteBuffer)this._content), this._lastContent, HttpConnection.this._generator.getState()});
                }
                switch (result) {
                    case NEED_INFO: {
                        throw new EofException("request lifecycle violation");
                    }
                    case NEED_HEADER: {
                        this._header = HttpConnection.this._bufferPool.acquire(Math.min(HttpConnection.this._configuration.getResponseHeaderSize(), HttpConnection.this._configuration.getOutputBufferSize()), useDirectByteBuffers);
                        continue block20;
                    }
                    case HEADER_OVERFLOW: {
                        if (this._header.capacity() >= HttpConnection.this._configuration.getResponseHeaderSize()) {
                            throw new BadMessageException(500, "Response header too large");
                        }
                        this.releaseHeader();
                        this._header = HttpConnection.this._bufferPool.acquire(HttpConnection.this._configuration.getResponseHeaderSize(), useDirectByteBuffers);
                        continue block20;
                    }
                    case NEED_CHUNK: {
                        this._chunk = HttpConnection.this._bufferPool.acquire(12, useDirectByteBuffers);
                        continue block20;
                    }
                    case NEED_CHUNK_TRAILER: {
                        this.releaseChunk();
                        this._chunk = HttpConnection.this._bufferPool.acquire(HttpConnection.this._configuration.getResponseHeaderSize(), useDirectByteBuffers);
                        continue block20;
                    }
                    case FLUSH: {
                        if (this._head || HttpConnection.this._generator.isNoContent()) {
                            BufferUtil.clear((ByteBuffer)this._chunk);
                            BufferUtil.clear((ByteBuffer)this._content);
                        }
                        int gatherWrite = 0;
                        long bytes = 0L;
                        if (BufferUtil.hasContent((ByteBuffer)this._header)) {
                            gatherWrite = (byte)(gatherWrite + 4);
                            bytes += (long)this._header.remaining();
                        }
                        if (BufferUtil.hasContent((ByteBuffer)this._chunk)) {
                            gatherWrite = (byte)(gatherWrite + 2);
                            bytes += (long)this._chunk.remaining();
                        }
                        if (BufferUtil.hasContent((ByteBuffer)this._content)) {
                            gatherWrite = (byte)(gatherWrite + 1);
                            bytes += (long)this._content.remaining();
                        }
                        HttpConnection.this.bytesOut.add(bytes);
                        switch (gatherWrite) {
                            case 7: {
                                HttpConnection.this.getEndPoint().write((Callback)this, new ByteBuffer[]{this._header, this._chunk, this._content});
                                break;
                            }
                            case 6: {
                                HttpConnection.this.getEndPoint().write((Callback)this, new ByteBuffer[]{this._header, this._chunk});
                                break;
                            }
                            case 5: {
                                HttpConnection.this.getEndPoint().write((Callback)this, new ByteBuffer[]{this._header, this._content});
                                break;
                            }
                            case 4: {
                                HttpConnection.this.getEndPoint().write((Callback)this, new ByteBuffer[]{this._header});
                                break;
                            }
                            case 3: {
                                HttpConnection.this.getEndPoint().write((Callback)this, new ByteBuffer[]{this._chunk, this._content});
                                break;
                            }
                            case 2: {
                                HttpConnection.this.getEndPoint().write((Callback)this, new ByteBuffer[]{this._chunk});
                                break;
                            }
                            case 1: {
                                HttpConnection.this.getEndPoint().write((Callback)this, new ByteBuffer[]{this._content});
                                break;
                            }
                            default: {
                                this.succeeded();
                            }
                        }
                        return IteratingCallback.Action.SCHEDULED;
                    }
                    case SHUTDOWN_OUT: {
                        this._shutdownOut = true;
                        continue block20;
                    }
                    case DONE: {
                        if (HttpConnection.this.getConnector().isShutdown() && HttpConnection.this._generator.isEnd() && HttpConnection.this._generator.isPersistent()) {
                            this._shutdownOut = true;
                        }
                        return IteratingCallback.Action.SUCCEEDED;
                    }
                    case CONTINUE: {
                        continue block20;
                    }
                }
                break;
            }
            throw new IllegalStateException("generateResponse=" + String.valueOf(result));
        }

        private Callback release() {
            Callback complete = this._callback;
            this._callback = null;
            this._info = null;
            this._content = null;
            this.releaseHeader();
            this.releaseChunk();
            return complete;
        }

        private void releaseHeader() {
            if (this._header != null) {
                HttpConnection.this._bufferPool.release(this._header);
            }
            this._header = null;
        }

        private void releaseChunk() {
            if (this._chunk != null) {
                HttpConnection.this._bufferPool.release(this._chunk);
            }
            this._chunk = null;
        }

        protected void onCompleteSuccess() {
            boolean upgrading = HttpConnection.this._httpChannel.getRequest() != null && HttpConnection.this._httpChannel.getRequest().getAttribute(HttpStream.UPGRADE_CONNECTION_ATTRIBUTE) != null;
            this.release().succeeded();
            if (this._shutdownOut && !upgrading) {
                HttpConnection.this.getEndPoint().shutdownOutput();
            }
        }

        public void onCompleteFailure(Throwable x) {
            HttpConnection.this.failedCallback(this.release(), x);
            if (this._shutdownOut) {
                HttpConnection.this.getEndPoint().shutdownOutput();
            }
        }

        public String toString() {
            return String.format("%s[i=%s,cb=%s]", super.toString(), this._info, this._callback);
        }
    }

    protected class RequestHandler
    implements HttpParser.RequestHandler,
    ComplianceViolation.Listener {
        private Throwable _failure;

        protected RequestHandler() {
        }

        public void startRequest(String method, String uri, HttpVersion version) {
            HttpStreamOverHTTP1 stream = HttpConnection.this.newHttpStream(method, uri, version);
            if (!HttpConnection.this._stream.compareAndSet(null, stream)) {
                throw new IllegalStateException("Stream pending");
            }
            HttpConnection.this._headerBuilder.clear();
            HttpConnection.this._httpChannel.setHttpStream(stream);
        }

        public void parsedHeader(HttpField field) {
            HttpConnection.this._stream.get().parsedHeader(field);
        }

        public boolean headerComplete() {
            HttpConnection.this._onRequest = HttpConnection.this._stream.get().headerComplete();
            return true;
        }

        public boolean content(ByteBuffer buffer) {
            HttpStreamOverHTTP1 stream = HttpConnection.this._stream.get();
            if (stream == null || stream._chunk != null || HttpConnection.this._retainableByteBuffer == null) {
                throw new IllegalStateException();
            }
            HttpConnection.this._retainableByteBuffer.retain();
            if (LOG.isDebugEnabled()) {
                LOG.debug("content {}/{} for {}", new Object[]{BufferUtil.toDetailString((ByteBuffer)buffer), HttpConnection.this._retainableByteBuffer, HttpConnection.this});
            }
            RetainableByteBuffer retainable = HttpConnection.this._retainableByteBuffer;
            stream._chunk = Content.Chunk.from((ByteBuffer)buffer, (boolean)false, (Retainable)new ChunkRetainable((Retainable)retainable, buffer));
            return true;
        }

        public boolean contentComplete() {
            return false;
        }

        public void parsedTrailer(HttpField field) {
            if (HttpConnection.this._trailers == null) {
                HttpConnection.this._trailers = HttpFields.build();
            }
            HttpConnection.this._trailers.add(field);
        }

        public boolean messageComplete() {
            HttpStreamOverHTTP1 stream = HttpConnection.this._stream.get();
            if (stream._chunk != null) {
                throw new IllegalStateException();
            }
            stream._chunk = HttpConnection.this._trailers != null ? new Trailers(HttpConnection.this._trailers.asImmutable()) : Content.Chunk.EOF;
            return false;
        }

        public void badMessage(BadMessageException failure) {
            Runnable task;
            if (LOG.isDebugEnabled()) {
                LOG.debug("badMessage {} {}", (Object)HttpConnection.this, (Object)failure);
            }
            this._failure = failure;
            HttpConnection.this._generator.setPersistent(false);
            HttpStreamOverHTTP1 stream = HttpConnection.this._stream.get();
            if (stream == null) {
                stream = HttpConnection.this.newHttpStream("GET", "/badMessage", HttpVersion.HTTP_1_0);
                HttpConnection.this._stream.set(stream);
                HttpConnection.this._httpChannel.setHttpStream(stream);
            }
            if (HttpConnection.this._httpChannel.getRequest() == null) {
                HttpURI.Mutable uri = stream._uri;
                if (uri.hasViolations()) {
                    uri = HttpURI.from((String)"/badURI");
                }
                HttpConnection.this._httpChannel.onRequest(new MetaData.Request(stream._method, (HttpURI)uri, stream._version, HttpFields.EMPTY));
            }
            if ((task = HttpConnection.this._httpChannel.onFailure((Throwable)failure)) != null) {
                HttpConnection.this.getServer().getThreadPool().execute(task);
            }
        }

        public void earlyEOF() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("early EOF {}", (Object)HttpConnection.this);
            }
            HttpConnection.this._generator.setPersistent(false);
            HttpStreamOverHTTP1 stream = HttpConnection.this._stream.get();
            if (stream != null) {
                BadMessageException bad = new BadMessageException("Early EOF");
                Content.Chunk chunk = stream._chunk;
                if (chunk instanceof Error) {
                    Error error = (Error)chunk;
                    error.getCause().addSuppressed((Throwable)bad);
                } else {
                    if (stream._chunk != null) {
                        stream._chunk.release();
                    }
                    stream._chunk = Content.Chunk.from((Throwable)bad);
                }
                Runnable todo = HttpConnection.this._httpChannel.onFailure((Throwable)bad);
                if (todo != null) {
                    HttpConnection.this.getServer().getThreadPool().execute(todo);
                }
            }
        }

        public void onComplianceViolation(ComplianceViolation.Mode mode, ComplianceViolation violation, String details) {
            HttpStreamOverHTTP1 stream;
            if (HttpConnection.this.isRecordHttpComplianceViolations() && (stream = HttpConnection.this._stream.get()) != null) {
                if (stream._complianceViolations == null) {
                    stream._complianceViolations = new ArrayList<String>();
                }
                String record = String.format("%s (see %s) in mode %s for %s in %s", violation.getDescription(), violation.getURL(), mode, details, HttpConnection.this);
                stream._complianceViolations.add(record);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(record);
                }
            }
        }
    }

    protected class HttpStreamOverHTTP1
    implements HttpStream {
        private final long _nanoTime = NanoTime.now();
        private final long _id;
        private final String _method;
        private final HttpURI.Mutable _uri;
        private final HttpVersion _version;
        private long _contentLength = -1L;
        private HostPortHttpField _hostField;
        private MetaData.Request _request;
        private HttpField _upgrade = null;
        private Content.Chunk _chunk;
        private boolean _connectionClose = false;
        private boolean _connectionKeepAlive = false;
        private boolean _connectionUpgrade = false;
        private boolean _unknownExpectation = false;
        private boolean _expects100Continue = false;
        private List<String> _complianceViolations;

        protected HttpStreamOverHTTP1(String method, String uri, HttpVersion version) {
            this._id = HttpConnection.this._streamIdGenerator.getAndIncrement();
            this._method = method;
            this._uri = uri == null ? null : HttpURI.build((String)method, (String)uri);
            this._version = version;
            if (this._uri != null && this._uri.getPath() == null && this._uri.getScheme() != null && this._uri.hasAuthority()) {
                this._uri.path("/");
            }
        }

        public void parsedHeader(HttpField field) {
            HttpHeader header = field.getHeader();
            String value = field.getValue();
            if (header != null) {
                switch (header) {
                    case CONNECTION: {
                        this._connectionClose |= field.contains(HttpHeaderValue.CLOSE.asString());
                        if (HttpVersion.HTTP_1_0.equals((Object)this._version)) {
                            this._connectionKeepAlive |= field.contains(HttpHeader.KEEP_ALIVE.asString());
                        }
                        this._connectionUpgrade |= field.contains(HttpHeaderValue.UPGRADE.asString());
                        break;
                    }
                    case HOST: {
                        if (value == null) {
                            value = "";
                        }
                        if (field instanceof HostPortHttpField) {
                            this._hostField = (HostPortHttpField)field;
                            break;
                        }
                        this._hostField = new HostPortHttpField(value);
                        field = this._hostField;
                        break;
                    }
                    case EXPECT: {
                        if (HttpHeaderValue.parseCsvIndex((String)value, t -> {
                            if (t == HttpHeaderValue.CONTINUE) {
                                this._expects100Continue = true;
                                return true;
                            }
                            return false;
                        }, s -> false)) break;
                        this._unknownExpectation = true;
                        this._expects100Continue = false;
                        break;
                    }
                    case UPGRADE: {
                        this._upgrade = field;
                        break;
                    }
                    case CONTENT_LENGTH: {
                        this._contentLength = field.getLongValue();
                        break;
                    }
                }
            }
            HttpConnection.this._headerBuilder.add(field);
        }

        public Runnable headerComplete() {
            boolean persistent;
            UriCompliance compliance;
            String badMessage;
            if (this._uri.hasViolations() && (badMessage = UriCompliance.checkUriCompliance((UriCompliance)(compliance = HttpConnection.this._configuration.getUriCompliance()), (HttpURI)this._uri)) != null) {
                throw new BadMessageException(badMessage);
            }
            if (this._hostField != null) {
                if (this._uri.isAbsolute()) {
                    if (!this._hostField.getValue().equals(this._uri.getAuthority())) {
                        throw new BadMessageException("Authority!=Host");
                    }
                } else if (StringUtil.isBlank((String)this._hostField.getHostPort().getHost())) {
                    throw new BadMessageException("Blank Host");
                }
            }
            if (!this._uri.isAbsolute()) {
                this._uri.scheme(HttpConnection.this.getEndPoint() instanceof SslConnection.DecryptedEndPoint ? HttpScheme.HTTPS : HttpScheme.HTTP);
            }
            if (!HttpMethod.CONNECT.is(this._method) && this._uri.getAuthority() == null) {
                HostPort hostPort = this._hostField == null ? HttpConnection.this.getServerAuthority() : this._hostField.getHostPort();
                int port = hostPort.getPort();
                if (port == HttpScheme.getDefaultPort((String)this._uri.getScheme())) {
                    port = -1;
                }
                this._uri.authority(hostPort.getHost(), port);
            }
            if (this._uri.getPath() == null) {
                this._uri.path("/");
            }
            this._request = new MetaData.Request(this._method, (HttpURI)this._uri.asImmutable(), this._version, (HttpFields)HttpConnection.this._headerBuilder, this._contentLength);
            Runnable handle = HttpConnection.this._httpChannel.onRequest(this._request);
            ++HttpConnection.this._requests;
            if (this._complianceViolations != null && !this._complianceViolations.isEmpty()) {
                HttpConnection.this._httpChannel.getRequest().setAttribute("org.eclipse.jetty.http.compliance.violations", this._complianceViolations);
                this._complianceViolations = null;
            }
            switch (this._request.getHttpVersion()) {
                case HTTP_0_9: {
                    persistent = false;
                    break;
                }
                case HTTP_1_0: {
                    persistent = HttpConnection.this.getHttpConfiguration().isPersistentConnectionsEnabled() && this._connectionKeepAlive && !this._connectionClose || HttpMethod.CONNECT.is(this._method);
                    HttpConnection.this._generator.setPersistent(persistent);
                    if (persistent) break;
                    this._connectionKeepAlive = false;
                    break;
                }
                case HTTP_1_1: {
                    if (this._unknownExpectation) {
                        HttpConnection.this._requestHandler.badMessage(new BadMessageException(417));
                        return null;
                    }
                    persistent = HttpConnection.this.getHttpConfiguration().isPersistentConnectionsEnabled() && !this._connectionClose || HttpMethod.CONNECT.is(this._method);
                    HttpConnection.this._generator.setPersistent(persistent);
                    if (this._upgrade == null || !HttpConnection.this.upgrade(HttpConnection.this._stream.get())) break;
                    return null;
                }
                case HTTP_2: {
                    this._upgrade = PREAMBLE_UPGRADE_H2C;
                    if (HttpMethod.PRI.is(this._method) && "*".equals(this._uri.getPath()) && HttpConnection.this._headerBuilder.size() == 0 && HttpConnection.this.upgrade(HttpConnection.this._stream.get())) {
                        return null;
                    }
                    HttpConnection.this._parser.close();
                    throw new BadMessageException(426, "Upgrade Required");
                }
                default: {
                    throw new IllegalStateException("unsupported version " + String.valueOf(this._version));
                }
            }
            if (!persistent) {
                HttpConnection.this._generator.setPersistent(false);
            }
            return handle;
        }

        @Override
        public String getId() {
            return "%s#%d".formatted(this._version, this._id);
        }

        @Override
        public long getNanoTimeStamp() {
            return this._nanoTime;
        }

        @Override
        public Content.Chunk read() {
            if (this._chunk == null) {
                if (HttpConnection.this._parser.isTerminated()) {
                    this._chunk = Content.Chunk.EOF;
                } else {
                    HttpConnection.this.parseAndFillForContent();
                }
            }
            Content.Chunk content = this._chunk;
            this._chunk = Content.Chunk.next((Content.Chunk)content);
            if (content != null && this._expects100Continue && content.hasRemaining()) {
                this._expects100Continue = false;
            }
            return content;
        }

        @Override
        public void demand() {
            if (this._chunk != null) {
                Runnable onContentAvailable = HttpConnection.this._httpChannel.onContentAvailable();
                if (onContentAvailable != null) {
                    onContentAvailable.run();
                }
                return;
            }
            HttpConnection.this.parseAndFillForContent();
            if (this._chunk != null) {
                Runnable onContentAvailable = HttpConnection.this._httpChannel.onContentAvailable();
                if (onContentAvailable != null) {
                    onContentAvailable.run();
                }
                return;
            }
            if (this._expects100Continue) {
                this._expects100Continue = false;
                this.send(this._request, HttpGenerator.CONTINUE_100_INFO, false, null, Callback.NOOP);
            }
            HttpConnection.this.tryFillInterested(HttpConnection.this._demandContentCallback);
        }

        @Override
        public void prepareResponse(HttpFields.Mutable headers) {
            if (this._connectionKeepAlive && this._version == HttpVersion.HTTP_1_0 && !headers.contains(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE.asString())) {
                headers.add(HttpFields.CONNECTION_KEEPALIVE);
            }
        }

        @Override
        public void send(MetaData.Request request, MetaData.Response response, boolean last, ByteBuffer content, Callback callback) {
            if (response == null) {
                if (!last && BufferUtil.isEmpty((ByteBuffer)content)) {
                    callback.succeeded();
                    return;
                }
            } else if (HttpConnection.this._generator.isCommitted()) {
                callback.failed((Throwable)new IllegalStateException("Committed"));
            } else if (this._expects100Continue) {
                if (response.getStatus() == 100) {
                    this._expects100Continue = false;
                } else {
                    HttpConnection.this._generator.setPersistent(false);
                }
            }
            if (HttpConnection.this._sendCallback.reset(this._request, response, content, last, callback)) {
                HttpConnection.this._sendCallback.iterate();
            }
        }

        @Override
        public boolean isCommitted() {
            return HttpConnection.this._stream.get() != this || HttpConnection.this._generator.isCommitted();
        }

        private boolean upgrade() {
            boolean isPriorKnowledgeH2C;
            if (LOG.isDebugEnabled()) {
                LOG.debug("upgrade {} {}", (Object)this, (Object)this._upgrade);
            }
            if (!this._connectionUpgrade && this._upgrade == null) {
                return false;
            }
            boolean bl = isPriorKnowledgeH2C = this._upgrade == PREAMBLE_UPGRADE_H2C;
            if (!isPriorKnowledgeH2C && !this._connectionUpgrade) {
                throw new BadMessageException(400);
            }
            ConnectionFactory.Upgrading factory = HttpConnection.this.getConnector().getConnectionFactories().stream().filter(f -> f instanceof ConnectionFactory.Upgrading).map(ConnectionFactory.Upgrading.class::cast).filter(f -> f.getProtocols().contains(this._upgrade.getValue())).findAny().orElse(null);
            if (factory == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No factory for {} in {}", (Object)this._upgrade, (Object)HttpConnection.this.getConnector());
                }
                return false;
            }
            HttpFields.Mutable response101 = HttpFields.build();
            Connection upgradeConnection = factory.upgradeConnection(HttpConnection.this.getConnector(), HttpConnection.this.getEndPoint(), this._request, response101);
            if (upgradeConnection == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Upgrade ignored for {} by {}", (Object)this._upgrade, (Object)factory);
                }
                return false;
            }
            if (!isPriorKnowledgeH2C) {
                this.send(this._request, new MetaData.Response(HttpVersion.HTTP_1_1, 101, (HttpFields)response101, 0L), false, null, Callback.NOOP);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Upgrading from {} to {}", (Object)HttpConnection.this.getEndPoint().getConnection(), (Object)upgradeConnection);
            }
            HttpConnection.this.getEndPoint().upgrade(upgradeConnection);
            return true;
        }

        @Override
        public TunnelSupport getTunnelSupport() {
            return HttpConnection.this._tunnelSupport;
        }

        public void succeeded() {
            HttpStreamOverHTTP1 stream = HttpConnection.this._stream.getAndSet(null);
            if (stream == null) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("succeeded {}", (Object)HttpConnection.this);
            }
            if (HttpConnection.this.isFillInterested()) {
                LOG.warn("Read pending {} {}", (Object)this, (Object)HttpConnection.this.getEndPoint());
                this.abort(new IOException("Pending read in onCompleted"));
                return;
            }
            Connection upgradeConnection = (Connection)HttpConnection.this._httpChannel.getRequest().getAttribute(HttpStream.UPGRADE_CONNECTION_ATTRIBUTE);
            if (upgradeConnection != null) {
                HttpConnection.this.getEndPoint().upgrade(upgradeConnection);
                HttpConnection.this._httpChannel.recycle();
                HttpConnection.this._parser.close();
                HttpConnection.this._generator.reset();
                return;
            }
            HttpConnection.this._httpChannel.recycle();
            if (this._expects100Continue) {
                this._expects100Continue = false;
                HttpConnection.this._parser.close();
            }
            if (!HttpConnection.this._parser.isClosed()) {
                if (HttpConnection.this._generator.isPersistent()) {
                    HttpConnection.this._parser.reset();
                } else {
                    HttpConnection.this._parser.close();
                }
            }
            HttpConnection.this._generator.reset();
            if (HttpConnection.this._handling.compareAndSet(true, false)) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("non-current completion {}", (Object)this);
            }
            if (HttpConnection.this._parser.isStart()) {
                if (HttpConnection.this.isRequestBufferEmpty()) {
                    HttpConnection.this.fillInterested();
                } else if (HttpConnection.this.getConnector().isRunning()) {
                    try {
                        HttpConnection.this.getExecutor().execute(HttpConnection.this);
                    }
                    catch (RejectedExecutionException e) {
                        if (HttpConnection.this.getConnector().isRunning()) {
                            LOG.warn("Failed dispatch of {}", (Object)this, (Object)e);
                        } else {
                            LOG.trace("IGNORED", (Throwable)e);
                        }
                        HttpConnection.this.getEndPoint().close();
                    }
                } else {
                    HttpConnection.this.getEndPoint().close();
                }
            } else if (HttpConnection.this.getEndPoint().isOpen()) {
                HttpConnection.this.fillInterested();
            }
        }

        public void failed(Throwable x) {
            HttpStreamOverHTTP1 stream = HttpConnection.this._stream.getAndSet(null);
            if (stream == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("ignored", x);
                }
                return;
            }
            this.abort(x);
        }

        private void abort(Throwable failure) {
            HttpConnection.this.getEndPoint().close(failure);
        }

        public Invocable.InvocationType getInvocationType() {
            return HttpStream.super.getInvocationType();
        }
    }

    private class ChunkRetainable
    extends Retainable.Wrapper {
        private final ByteBuffer buffer;

        private ChunkRetainable(Retainable retainable, ByteBuffer buffer) {
            super(retainable);
            this.buffer = buffer;
        }

        public boolean release() {
            boolean released = super.release();
            if (LOG.isDebugEnabled()) {
                LOG.debug("content released {} {}/{} for {}", new Object[]{released, BufferUtil.toDetailString((ByteBuffer)this.buffer), this.getWrapped(), HttpConnection.this});
            }
            return released;
        }
    }
}

