/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler.gzip;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http.GZIPContentDecoder;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.content.ContentSourceTransformer;
import org.eclipse.jetty.server.Components;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.server.handler.gzip.GzipResponse;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.compression.InflaterPool;

public class GzipRequest
extends Request.WrapperProcessor {
    private static final InflaterPool __inflaterPool = new InflaterPool(-1, true);
    private final boolean _inflateInput;
    private Decoder _decoder;
    private GzipTransformer gzipTransformer;
    private final int _inflateBufferSize;
    private final GzipHandler _gzipHandler;
    private final HttpFields _fields;

    public GzipRequest(Request wrapped, GzipHandler gzipHandler, boolean inflateInput, HttpFields fields) {
        super(wrapped);
        this._gzipHandler = gzipHandler;
        this._inflateInput = inflateInput;
        this._inflateBufferSize = gzipHandler.getInflateBufferSize();
        this._fields = fields;
    }

    @Override
    public HttpFields getHeaders() {
        if (this._fields == null) {
            return super.getHeaders();
        }
        return this._fields;
    }

    @Override
    public void process(Request request, Response response, Callback callback) throws Exception {
        if (this._inflateInput) {
            Components components = request.getComponents();
            this._decoder = new Decoder(__inflaterPool, components.getByteBufferPool(), this._inflateBufferSize);
            this.gzipTransformer = new GzipTransformer(request);
        }
        int outputBufferSize = request.getConnectionMetaData().getHttpConfiguration().getOutputBufferSize();
        GzipResponse gzipResponse = new GzipResponse(this, response, this._gzipHandler, this._gzipHandler.getVary(), outputBufferSize, this._gzipHandler.isSyncFlush());
        Callback cb = Callback.from(() -> this.destroy(gzipResponse), (Callback)callback);
        super.process(this, gzipResponse, cb);
    }

    @Override
    public Content.Chunk read() {
        if (this._inflateInput) {
            return this.gzipTransformer.read();
        }
        return super.read();
    }

    @Override
    public void demand(Runnable demandCallback) {
        if (this._inflateInput) {
            this.gzipTransformer.demand(demandCallback);
        } else {
            super.demand(demandCallback);
        }
    }

    private void destroy(GzipResponse response) {
        response.write(true, null, Callback.NOOP);
        if (this._decoder != null) {
            this._decoder.destroy();
            this._decoder = null;
        }
    }

    private static class Decoder
    extends GZIPContentDecoder {
        private ByteBuffer _decoded;

        private Decoder(InflaterPool inflaterPool, ByteBufferPool bufferPool, int bufferSize) {
            super(inflaterPool, bufferPool, bufferSize);
        }

        public ByteBuffer decode(Content.Chunk content) {
            this.decodeChunks(content.getByteBuffer());
            ByteBuffer chunk = this._decoded;
            this._decoded = null;
            return chunk;
        }

        protected boolean decodedChunk(ByteBuffer decoded) {
            this._decoded = decoded;
            return true;
        }

        public void decodeChunks(ByteBuffer compressed) {
            this._decoded = null;
            super.decodeChunks(compressed);
        }
    }

    private class GzipTransformer
    extends ContentSourceTransformer {
        private Content.Chunk _chunk;

        public GzipTransformer(Content.Source source) {
            super(source);
        }

        protected Content.Chunk transform(Content.Chunk inputChunk) {
            ByteBuffer decodedBuffer;
            boolean retain;
            boolean bl = retain = this._chunk == null;
            if (this._chunk == null) {
                this._chunk = inputChunk;
            }
            if (this._chunk == null) {
                return null;
            }
            if (this._chunk instanceof Content.Chunk.Error) {
                return this._chunk;
            }
            if (this._chunk.isLast() && !this._chunk.hasRemaining()) {
                return Content.Chunk.EOF;
            }
            if (retain) {
                this._chunk.retain();
            }
            if (BufferUtil.hasContent((ByteBuffer)(decodedBuffer = GzipRequest.this._decoder.decode(this._chunk)))) {
                return Content.Chunk.from((ByteBuffer)decodedBuffer, (this._chunk.isLast() && !this._chunk.hasRemaining() ? 1 : 0) != 0, arg_0 -> ((Decoder)GzipRequest.this._decoder).release(arg_0));
            }
            Content.Chunk result = this._chunk.isLast() ? Content.Chunk.EOF : null;
            this._chunk.release();
            this._chunk = null;
            return result;
        }
    }
}

