/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import org.eclipse.jetty.http.HostPortHttpField;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.QuotedCSV;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IncludeExcludeSet;
import org.eclipse.jetty.util.InetAddressSet;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.thread.AutoLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadLimitHandler
extends Handler.Wrapper {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadLimitHandler.class);
    private final boolean _rfc7239;
    private final String _forwardedHeader;
    private final IncludeExcludeSet<String, InetAddress> _includeExcludeSet = new IncludeExcludeSet(InetAddressSet.class);
    private final ConcurrentMap<String, Remote> _remotes = new ConcurrentHashMap<String, Remote>();
    private volatile boolean _enabled;
    private int _threadLimit = 10;

    public ThreadLimitHandler() {
        this(null, false);
    }

    public ThreadLimitHandler(@Name(value="forwardedHeader") String forwardedHeader) {
        this(forwardedHeader, HttpHeader.FORWARDED.is(forwardedHeader));
    }

    public ThreadLimitHandler(@Name(value="forwardedHeader") String forwardedHeader, @Name(value="rfc7239") boolean rfc7239) {
        this._rfc7239 = rfc7239;
        this._forwardedHeader = forwardedHeader;
        this._enabled = true;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        LOG.info(String.format("ThreadLimitHandler enable=%b limit=%d include=%s", this._enabled, this._threadLimit, this._includeExcludeSet));
    }

    @ManagedAttribute(value="true if this handler is enabled")
    public boolean isEnabled() {
        return this._enabled;
    }

    public void setEnabled(boolean enabled) {
        this._enabled = enabled;
        LOG.info(String.format("ThreadLimitHandler enable=%b limit=%d include=%s", this._enabled, this._threadLimit, this._includeExcludeSet));
    }

    @ManagedAttribute(value="The maximum threads that can be dispatched per remote IP")
    public int getThreadLimit() {
        return this._threadLimit;
    }

    protected int getThreadLimit(String ip) {
        if (!this._includeExcludeSet.isEmpty()) {
            try {
                if (!this._includeExcludeSet.test((Object)InetAddress.getByName(ip))) {
                    LOG.debug("excluded {}", (Object)ip);
                    return 0;
                }
            }
            catch (Exception e) {
                LOG.trace("IGNORED", (Throwable)e);
            }
        }
        return this._threadLimit;
    }

    public void setThreadLimit(int threadLimit) {
        if (threadLimit <= 0) {
            throw new IllegalArgumentException("limit must be >0");
        }
        this._threadLimit = threadLimit;
    }

    @ManagedOperation(value="Include IP in thread limits")
    public void include(String inetAddressPattern) {
        this._includeExcludeSet.include((Object)inetAddressPattern);
    }

    @ManagedOperation(value="Exclude IP from thread limits")
    public void exclude(String inetAddressPattern) {
        this._includeExcludeSet.exclude((Object)inetAddressPattern);
    }

    @Override
    public Request.Processor handle(Request request) throws Exception {
        Request.Processor baseProcessor = super.handle(request);
        if (baseProcessor == null) {
            return null;
        }
        if (!this._enabled) {
            return baseProcessor;
        }
        Remote remote = this.getRemote(request);
        if (remote == null) {
            return baseProcessor;
        }
        CompletableFuture<Closeable> futurePermit = remote.acquire();
        if (futurePermit.isDone()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Threadpermitted {}", (Object)remote);
            }
            return (rq, rs, cb) -> baseProcessor.process(rq, rs, Callback.from((Callback)cb, () -> ThreadLimitHandler.getAndClose(futurePermit)));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Threadlimited {}", (Object)remote);
        }
        return (rq, rs, cb) -> futurePermit.thenAccept(c -> {
            try {
                baseProcessor.process(rq, rs, Callback.from((Callback)cb, () -> ThreadLimitHandler.getAndClose(futurePermit)));
            }
            catch (Throwable x) {
                cb.failed(x);
            }
        });
    }

    private static void getAndClose(CompletableFuture<Closeable> cf) {
        try {
            LOG.debug("getting {}", cf);
            Closeable closeable = cf.get();
            LOG.debug("closing {}", (Object)closeable);
            closeable.close();
        }
        catch (IOException | InterruptedException | ExecutionException e) {
            LOG.warn("Error closing permit enclosed in {}", cf, (Object)e);
        }
    }

    private Remote getRemote(Request baseRequest) {
        Remote r;
        String ip = this.getRemoteIP(baseRequest);
        LOG.debug("ip={}", (Object)ip);
        if (ip == null) {
            return null;
        }
        int limit = this.getThreadLimit(ip);
        if (limit <= 0) {
            return null;
        }
        Remote remote = (Remote)this._remotes.get(ip);
        if (remote == null && (remote = this._remotes.putIfAbsent(ip, r = new Remote(ip, limit))) == null) {
            remote = r;
        }
        return remote;
    }

    protected String getRemoteIP(Request baseRequest) {
        InetSocketAddress inetAddr;
        SocketAddress socketAddress;
        if (this._forwardedHeader != null && !this._forwardedHeader.isEmpty()) {
            String remote;
            String string = remote = this._rfc7239 ? this.getForwarded(baseRequest) : this.getXForwardedFor(baseRequest);
            if (remote != null && !remote.isEmpty()) {
                return remote;
            }
        }
        if ((socketAddress = baseRequest.getConnectionMetaData().getRemoteSocketAddress()) instanceof InetSocketAddress && (inetAddr = (InetSocketAddress)socketAddress).getAddress() != null) {
            return inetAddr.getAddress().getHostAddress();
        }
        return null;
    }

    private String getForwarded(Request request) {
        RFC7239 rfc7239 = new RFC7239();
        for (HttpField field : request.getHeaders()) {
            if (!this._forwardedHeader.equalsIgnoreCase(field.getName())) continue;
            rfc7239.addValue(field.getValue());
        }
        if (rfc7239.getFor() != null) {
            return new HostPortHttpField(rfc7239.getFor()).getHost();
        }
        return null;
    }

    private String getXForwardedFor(Request request) {
        String forwardedFor = null;
        for (HttpField field : request.getHeaders()) {
            if (!this._forwardedHeader.equalsIgnoreCase(field.getName())) continue;
            forwardedFor = field.getValue();
        }
        if (forwardedFor == null || forwardedFor.isEmpty()) {
            return null;
        }
        int comma = forwardedFor.lastIndexOf(44);
        return comma >= 0 ? forwardedFor.substring(comma + 1).trim() : forwardedFor;
    }

    private static final class Remote
    implements Closeable {
        private final String _ip;
        private final int _limit;
        private final AutoLock _lock = new AutoLock();
        private int _permits;
        private final Deque<CompletableFuture<Closeable>> _queue = new ArrayDeque<CompletableFuture<Closeable>>();
        private final CompletableFuture<Closeable> _permitted = CompletableFuture.completedFuture(this);

        public Remote(String ip, int limit) {
            this._ip = ip;
            this._limit = limit;
        }

        public CompletableFuture<Closeable> acquire() {
            try (AutoLock lock = this._lock.lock();){
                if (this._permits < this._limit) {
                    ++this._permits;
                    CompletableFuture<Closeable> completableFuture = this._permitted;
                    return completableFuture;
                }
                CompletableFuture<Closeable> pass = new CompletableFuture<Closeable>();
                this._queue.addLast(pass);
                CompletableFuture<Closeable> completableFuture = pass;
                return completableFuture;
            }
        }

        @Override
        public void close() {
            block7: {
                try (AutoLock lock = this._lock.lock();){
                    CompletableFuture<Closeable> permit;
                    --this._permits;
                    do {
                        if ((permit = this._queue.pollFirst()) != null) continue;
                        break block7;
                    } while (!permit.complete(this));
                    ++this._permits;
                }
            }
        }

        public String toString() {
            try (AutoLock lock = this._lock.lock();){
                String string = String.format("R[ip=%s,p=%d,l=%d,q=%d]", this._ip, this._permits, this._limit, this._queue.size());
                return string;
            }
        }
    }

    private static final class RFC7239
    extends QuotedCSV {
        String _for;

        private RFC7239() {
            super(false, new String[0]);
        }

        String getFor() {
            return this._for;
        }

        protected void parsedParam(StringBuffer buffer, int valueLength, int paramName, int paramValue) {
            String name;
            if (valueLength == 0 && paramValue > paramName && "for".equalsIgnoreCase(name = StringUtil.asciiToLowerCase((String)buffer.substring(paramName, paramValue - 1)))) {
                String value = buffer.substring(paramValue);
                this._for = "unknown".equalsIgnoreCase(value) ? null : value;
            }
        }
    }
}

