/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.ErrorProcessor;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.ExceptionUtil;
import org.eclipse.jetty.util.thread.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReHandlingErrorProcessor
extends ErrorProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(ReHandlingErrorProcessor.class);
    private final Handler _handler;

    protected ReHandlingErrorProcessor(Handler handler) {
        this._handler = handler;
    }

    public Invocable.InvocationType getInvocationType() {
        return this._handler.getInvocationType();
    }

    @Override
    protected void generateResponse(Request request, Response response, int code, String message, Throwable cause, Callback callback) throws IOException {
        String pathInContext;
        if (request.getAttribute(ReHandlingErrorProcessor.class.getName()) == null && (pathInContext = this.getReHandlePathInContext(request, code, cause)) != null) {
            request.setAttribute(ReHandlingErrorProcessor.class.getName(), pathInContext);
            HttpURI uri = Request.newHttpURIFrom(request, pathInContext);
            ReHandleRequestWrapper wrapper = new ReHandleRequestWrapper(request, uri);
            try {
                Request.Processor processor = this._handler.handle(wrapper);
                if (processor != null) {
                    response.setStatus(200);
                    processor.process(wrapper, response, callback);
                    return;
                }
            }
            catch (Exception e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Unable to process error {}", (Object)wrapper, (Object)e);
                }
                if (cause != null && ExceptionUtil.areNotAssociated((Throwable)cause, (Throwable)e)) {
                    cause.addSuppressed(e);
                }
                response.setStatus(code);
            }
        }
        super.generateResponse(request, response, code, message, cause, callback);
    }

    protected abstract String getReHandlePathInContext(Request var1, int var2, Throwable var3);

    private static class ReHandleRequestWrapper
    extends Request.Wrapper {
        private final HttpURI _uri;

        public ReHandleRequestWrapper(Request request, HttpURI uri) {
            super(request);
            this._uri = uri;
        }

        @Override
        public HttpURI getHttpURI() {
            return this._uri;
        }
    }

    public static class ByHttpStatus
    extends ReHandlingErrorProcessor {
        private final Map<Integer, String> _statusMap = new ConcurrentHashMap<Integer, String>();

        public ByHttpStatus(Handler handler) {
            super(handler);
        }

        @Override
        protected String getReHandlePathInContext(Request request, int code, Throwable cause) {
            return this.get(code);
        }

        public String put(int code, String pathInContext) {
            return this._statusMap.put(code, pathInContext);
        }

        public String get(int code) {
            return this._statusMap.get(code);
        }

        public String remove(int code) {
            return this._statusMap.remove(code);
        }
    }
}

