/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.util.Collections;
import java.util.List;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.thread.Invocable;

public class HotSwapHandler
extends Handler.AbstractContainer
implements Handler.Nested {
    private volatile Handler _handler;

    @Override
    public Handler getHandler() {
        return this._handler;
    }

    @Override
    public List<Handler> getHandlers() {
        Handler next = this._handler;
        return next == null ? Collections.emptyList() : Collections.singletonList(next);
    }

    @Override
    public void setHandler(Handler handler) {
        Handler.Container container;
        Server server1 = this.getServer();
        if (server1 != null && server1.isStarted() && handler != null && server1.getInvocationType() != Invocable.combine((Invocable.InvocationType)server1.getInvocationType(), (Invocable.InvocationType)handler.getInvocationType())) {
            throw new IllegalArgumentException("Cannot change invocation type of started server");
        }
        if (handler == this || handler instanceof Handler.Container && (container = (Handler.Container)handler).getDescendants().contains(this)) {
            throw new IllegalStateException("setHandler loop");
        }
        try {
            Server server = this.getServer();
            if (handler == this._handler) {
                return;
            }
            Handler oldHandler = this._handler;
            if (handler != null) {
                handler.setServer(server);
                this.addBean(handler, true);
                if (oldHandler != null && oldHandler.isStarted()) {
                    handler.start();
                }
            }
            this._handler = handler;
            if (oldHandler != null) {
                this.removeBean(oldHandler);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Request.Processor handle(Request request) throws Exception {
        Handler next = this._handler;
        return next == null ? null : next.handle(request);
    }

    @Override
    public Invocable.InvocationType getInvocationType() {
        Handler next = this.getHandler();
        return next == null ? Invocable.InvocationType.NON_BLOCKING : next.getInvocationType();
    }

    @Override
    public void destroy() {
        if (!this.isStopped()) {
            throw new IllegalStateException("!STOPPED");
        }
        Handler child = this.getHandler();
        if (child != null) {
            this.setHandler((Handler)null);
            child.destroy();
        }
        super.destroy();
    }
}

