/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.function.BiConsumer;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.MultiPart;
import org.eclipse.jetty.http.MultiPartFormData;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.server.FormFields;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Fields;

public abstract class DelayedHandler
extends Handler.Wrapper {
    @Override
    public Request.Processor handle(Request request) throws Exception {
        Request.Processor processor = super.handle(request);
        if (processor == null) {
            return null;
        }
        return this.delayed(request, processor);
    }

    protected abstract Request.Processor delayed(Request var1, Request.Processor var2);

    public static class QualityOfService
    extends DelayedHandler {
        private final int _maxPermits;
        private final Queue<QualityOfServiceProcessor> _queue = new ArrayDeque<QualityOfServiceProcessor>();
        private int _permits;

        public QualityOfService(int permits) {
            this._maxPermits = permits;
        }

        @Override
        protected Request.Processor delayed(Request request, Request.Processor processor) {
            return new QualityOfServiceProcessor(request, processor);
        }

        private class QualityOfServiceProcessor
        implements Request.Processor,
        Callback {
            private final Request.Processor _processor;
            private final Request _request;
            private Response _response;
            private Callback _callback;

            private QualityOfServiceProcessor(Request request, Request.Processor processor) {
                this._processor = processor;
                this._request = request;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void process(Request request, Response response, Callback callback) throws Exception {
                boolean accepted;
                QualityOfService qualityOfService = QualityOfService.this;
                synchronized (qualityOfService) {
                    this._callback = callback;
                    boolean bl = accepted = QualityOfService.this._permits < QualityOfService.this._maxPermits;
                    if (accepted) {
                        ++QualityOfService.this._permits;
                    } else {
                        this._response = response;
                        QualityOfService.this._queue.add(this);
                    }
                }
                if (accepted) {
                    this._processor.process(request, response, this);
                }
            }

            public void succeeded() {
                try {
                    this._callback.succeeded();
                    this.release();
                }
                finally {
                    this.release();
                }
            }

            public void failed(Throwable x) {
                try {
                    this._callback.failed(x);
                    this.release();
                }
                finally {
                    this.release();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void release() {
                QualityOfServiceProcessor processor;
                QualityOfService qualityOfService = QualityOfService.this;
                synchronized (qualityOfService) {
                    processor = QualityOfService.this._queue.poll();
                    if (processor == null) {
                        --QualityOfService.this._permits;
                    }
                }
                if (processor != null) {
                    try {
                        processor._processor.process(processor._request, processor._response, processor);
                    }
                    catch (Throwable t) {
                        Response.writeError(processor._request, processor._response, (Callback)processor, t);
                    }
                }
            }
        }
    }

    public static class UntilMultiPartFormData
    extends DelayedHandler {
        @Override
        protected Request.Processor delayed(Request request, Request.Processor processor) {
            if (!request.getConnectionMetaData().getHttpConfiguration().isDelayDispatchUntilContent()) {
                return processor;
            }
            String contentType = request.getHeaders().get(HttpHeader.CONTENT_TYPE);
            if (contentType == null) {
                return processor;
            }
            String contentTypeValue = HttpField.valueParameters((String)contentType, null);
            if (!MimeTypes.Type.MULTIPART_FORM_DATA.is(contentTypeValue)) {
                return processor;
            }
            String boundary = MultiPart.extractBoundary((String)contentType);
            if (boundary == null) {
                return processor;
            }
            return new Processor(request, processor, boundary);
        }

        private static class Processor
        implements Request.Processor,
        Runnable,
        BiConsumer<MultiPartFormData.Parts, Throwable> {
            private final Request _request;
            private final Request.Processor _processor;
            private final String _boundary;
            private Response _response;
            private Callback _callback;
            private MultiPartFormData _formData;

            private Processor(Request request, Request.Processor processor, String boundary) {
                this._request = request;
                this._processor = processor;
                this._boundary = boundary;
            }

            @Override
            public void process(Request ignored, Response response, Callback callback) throws Exception {
                this._response = response;
                this._callback = callback;
                String contentType = this._request.getHeaders().get(HttpHeader.CONTENT_TYPE);
                this._formData = new MultiPartFormData(this._boundary);
                this._request.setAttribute(MultiPartFormData.class.getName(), this._formData);
                this.run();
                if (this._formData.isDone()) {
                    this._processor.process(this._request, response, callback);
                } else {
                    this._formData.whenComplete((BiConsumer)this);
                }
            }

            @Override
            public void run() {
                Content.Chunk chunk;
                do {
                    if ((chunk = this._request.read()) == null) {
                        this._request.demand(this);
                        return;
                    }
                    if (chunk instanceof Content.Chunk.Error) {
                        Content.Chunk.Error error = (Content.Chunk.Error)chunk;
                        this._formData.completeExceptionally(error.getCause());
                        return;
                    }
                    this._formData.parse(chunk);
                    chunk.release();
                } while (!chunk.isLast());
            }

            @Override
            public void accept(MultiPartFormData.Parts parts, Throwable throwable) {
                try {
                    this._processor.process(this._request, this._response, this._callback);
                }
                catch (Throwable x) {
                    Response.writeError(this._request, this._response, this._callback, x);
                }
            }
        }
    }

    private static class UntilFormFieldsProcessor
    implements Request.Processor,
    BiConsumer<Fields, Throwable> {
        private final Request _request;
        private final Request.Processor _processor;
        private Response _response;
        private Callback _callback;

        public UntilFormFieldsProcessor(Request request, Request.Processor processor) {
            this._processor = processor;
            this._request = request;
        }

        @Override
        public void process(Request ignored, Response response, Callback callback) throws Exception {
            this._response = response;
            this._callback = callback;
            FormFields.from(this._request).whenComplete((BiConsumer)this);
        }

        @Override
        public void accept(Fields fields, Throwable throwable) {
            try {
                this._processor.process(this._request, this._response, this._callback);
            }
            catch (Throwable t) {
                Response.writeError(this._request, this._response, this._callback, t);
            }
        }
    }

    public static class UntilFormFields
    extends DelayedHandler {
        @Override
        protected Request.Processor delayed(Request request, Request.Processor processor) {
            if (!request.getConnectionMetaData().getHttpConfiguration().isDelayDispatchUntilContent()) {
                return processor;
            }
            Charset charset = FormFields.getFormEncodedCharset(request);
            if (charset == null) {
                return processor;
            }
            return new UntilFormFieldsProcessor(request, processor);
        }
    }

    private static class UntilContentProcessor
    implements Request.Processor,
    Runnable {
        private final Request.Processor _processor;
        private final Request _request;
        private Response _response;
        private Callback _callback;

        public UntilContentProcessor(Request request, Request.Processor processor) {
            this._request = request;
            this._processor = processor;
        }

        @Override
        public void process(Request ignored, Response response, Callback callback) throws Exception {
            this._response = response;
            this._callback = callback;
            this._request.demand(this);
        }

        @Override
        public void run() {
            try {
                this._processor.process(this._request, this._response, this._callback);
            }
            catch (Throwable t) {
                Response.writeError(this._request, this._response, this._callback, t);
            }
        }
    }

    public static class UntilContent
    extends DelayedHandler {
        @Override
        protected Request.Processor delayed(Request request, Request.Processor processor) {
            if (!request.getConnectionMetaData().getHttpConfiguration().isDelayDispatchUntilContent()) {
                return processor;
            }
            if (request.getLength() <= 0L && !request.getHeaders().contains(HttpHeader.CONTENT_TYPE)) {
                return processor;
            }
            return new UntilContentProcessor(request, processor);
        }
    }
}

