/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Locale;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.server.AbstractConnector;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.DateCache;
import org.eclipse.jetty.util.RolloverFileOutputStream;

public class DebugHandler
extends Handler.Wrapper
implements Connection.Listener {
    private DateCache _date = new DateCache("HH:mm:ss", Locale.US);
    private OutputStream _out;
    private PrintStream _print;

    @Override
    public Request.Processor handle(Request request) throws Exception {
        return super.handle(request);
    }

    private void print(String name, String message) {
        long now = System.currentTimeMillis();
        String d = this._date.formatNow(now);
        int ms = (int)(now % 1000L);
        this._print.println(d + (ms > 99 ? "." : (ms > 9 ? ".0" : ".00")) + ms + ":" + name + " " + message);
    }

    @Override
    protected void doStart() throws Exception {
        if (this._out == null) {
            this._out = new RolloverFileOutputStream("./logs/yyyy_mm_dd.debug.log", true);
        }
        this._print = new PrintStream(this._out);
        for (Connector connector : this.getServer().getConnectors()) {
            if (!(connector instanceof AbstractConnector)) continue;
            ((AbstractConnector)connector).addBean(this, false);
        }
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        this._print.close();
        for (Connector connector : this.getServer().getConnectors()) {
            if (!(connector instanceof AbstractConnector)) continue;
            ((AbstractConnector)connector).removeBean(this);
        }
    }

    public OutputStream getOutputStream() {
        return this._out;
    }

    public void setOutputStream(OutputStream out) {
        this._out = out;
    }

    public void onOpened(Connection connection) {
        this.print(Thread.currentThread().getName(), "OPENED " + connection.toString());
    }

    public void onClosed(Connection connection) {
        this.print(Thread.currentThread().getName(), "CLOSED " + connection.toString());
    }
}

