/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.nio.ByteBuffer;
import java.util.ListIterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.CookieCompliance;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.Trailers;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.QuietException;
import org.eclipse.jetty.server.Context;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.ErrorProcessor;
import org.eclipse.jetty.server.internal.HttpChannelState;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Response
extends Content.Sink {
    public Request getRequest();

    public int getStatus();

    public void setStatus(int var1);

    public HttpFields.Mutable getHeaders();

    public Supplier<HttpFields> getTrailersSupplier();

    public void setTrailersSupplier(Supplier<HttpFields> var1);

    public boolean isCommitted();

    public boolean isCompletedSuccessfully();

    public void reset();

    public CompletableFuture<Void> writeInterim(int var1, HttpFields var2);

    public static Content.Chunk.Processor newTrailersChunkProcessor(Response response) {
        Supplier<HttpFields> supplier = response.getTrailersSupplier();
        if (supplier == null) {
            return (chunk, callback) -> false;
        }
        return (chunk, callback) -> {
            HttpFields responseTrailers;
            Trailers trailers;
            HttpFields requestTrailers;
            if (chunk instanceof Trailers && (requestTrailers = (trailers = (Trailers)chunk).getTrailers()) != null && (responseTrailers = (HttpFields)supplier.get()) instanceof HttpFields.Mutable) {
                HttpFields.Mutable mutable = (HttpFields.Mutable)responseTrailers;
                mutable.add(requestTrailers);
                callback.succeeded();
                return true;
            }
            return false;
        };
    }

    public static <T extends Wrapper> T as(Response response, Class<T> type) {
        while (response instanceof Wrapper) {
            Wrapper wrapper = (Wrapper)response;
            if (type.isInstance(wrapper)) {
                return (T)wrapper;
            }
            response = wrapper.getWrapped();
        }
        return null;
    }

    public static void sendRedirect(Request request, Response response, Callback callback, String location) {
        Response.sendRedirect(request, response, callback, 302, location, false);
    }

    public static void sendRedirect(Request request, Response response, Callback callback, int code, String location, boolean consumeAvailable) {
        if (!HttpStatus.isRedirection((int)code)) {
            throw new IllegalArgumentException("Not a 3xx redirect code");
        }
        if (location == null) {
            throw new IllegalArgumentException("No location");
        }
        if (response.isCommitted()) {
            throw new IllegalStateException("Committed");
        }
        if (consumeAvailable) {
            Content.Chunk chunk;
            while ((chunk = response.getRequest().read()) != null) {
                chunk.release();
                if (!chunk.isLast()) continue;
                break;
            }
        }
        response.getHeaders().put(HttpHeader.LOCATION, Request.toRedirectURI(request, location));
        response.setStatus(code);
        response.write(true, null, callback);
    }

    public static void addCookie(Response response, HttpCookie cookie) {
        if (StringUtil.isBlank((String)cookie.getName())) {
            throw new IllegalArgumentException("Cookie.name cannot be blank/null");
        }
        Request request = response.getRequest();
        response.getHeaders().add((HttpField)new HttpCookie.SetCookieHttpField(HttpCookie.checkSameSite((HttpCookie)cookie, (Attributes)request.getContext()), request.getConnectionMetaData().getHttpConfiguration().getResponseCookieCompliance()));
        response.getHeaders().put(HttpFields.EXPIRES_01JAN1970);
    }

    public static void replaceCookie(Response response, HttpCookie cookie) {
        if (StringUtil.isBlank((String)cookie.getName())) {
            throw new IllegalArgumentException("Cookie.name cannot be blank/null");
        }
        Request request = response.getRequest();
        HttpConfiguration httpConfiguration = request.getConnectionMetaData().getHttpConfiguration();
        ListIterator i = response.getHeaders().listIterator();
        while (i.hasNext()) {
            HttpField field = (HttpField)i.next();
            if (field.getHeader() != HttpHeader.SET_COOKIE) continue;
            CookieCompliance compliance = httpConfiguration.getResponseCookieCompliance();
            if (field instanceof HttpCookie.SetCookieHttpField ? !HttpCookie.match((HttpCookie)((HttpCookie.SetCookieHttpField)field).getHttpCookie(), (String)cookie.getName(), (String)cookie.getDomain(), (String)cookie.getPath()) : !HttpCookie.match((String)field.getValue(), (String)cookie.getName(), (String)cookie.getDomain(), (String)cookie.getPath())) continue;
            i.set(new HttpCookie.SetCookieHttpField(HttpCookie.checkSameSite((HttpCookie)cookie, (Attributes)request.getContext()), compliance));
            return;
        }
        Response.addCookie(response, cookie);
    }

    public static void writeError(Request request, Response response, Callback callback, Throwable cause) {
        if (cause == null) {
            cause = new Throwable("unknown cause");
        }
        int status = 500;
        String message = cause.toString();
        if (cause instanceof BadMessageException) {
            BadMessageException bad = (BadMessageException)cause;
            status = bad.getCode();
            message = bad.getReason();
        }
        Response.writeError(request, response, callback, status, message, cause);
    }

    public static void writeError(Request request, Response response, Callback callback, int status) {
        Response.writeError(request, response, callback, status, null, null);
    }

    public static void writeError(Request request, Response response, Callback callback, int status, String message) {
        Response.writeError(request, response, callback, status, message, null);
    }

    public static void writeError(Request request, Response response, Callback callback, int status, String message, Throwable cause) {
        block11: {
            Logger logger = LoggerFactory.getLogger(Response.class);
            if (logger.isDebugEnabled()) {
                logger.debug("writeError: status={}, message={}, response={}", new Object[]{status, message, response, cause});
            } else if (cause instanceof BadMessageException || cause instanceof QuietException) {
                logger.debug("writeError: status={}, message={}, response={} {}", new Object[]{status, message, response, cause.toString()});
            } else if (cause != null) {
                logger.warn("writeError: status={}, message={}, response={}", new Object[]{status, message, response, cause});
            }
            if (response.isCommitted()) {
                callback.failed(cause == null ? new IllegalStateException(message == null ? "Committed" : message) : cause);
                return;
            }
            Response.ensureConsumeAvailableOrNotPersistent(request, response);
            if (status <= 0) {
                status = 500;
            }
            if (message == null) {
                message = HttpStatus.getMessage((int)status);
            }
            response.setStatus(status);
            Context context = request.getContext();
            Request.Processor errorProcessor = context.getErrorProcessor();
            if (errorProcessor != null) {
                ErrorProcessor.ErrorRequest errorRequest = new ErrorProcessor.ErrorRequest(request, status, message, cause);
                try {
                    errorProcessor.process(errorRequest, response, callback);
                    return;
                }
                catch (Exception e) {
                    if (cause == null || cause == e) break block11;
                    cause.addSuppressed(e);
                }
            }
        }
        response.getHeaders().put(ErrorProcessor.ERROR_CACHE_CONTROL);
        response.write(true, null, callback);
    }

    public static Response getOriginalResponse(Response response) {
        while (response instanceof Wrapper) {
            Wrapper wrapped = (Wrapper)response;
            response = wrapped.getWrapped();
        }
        return response;
    }

    public static long getContentBytesWritten(Response response) {
        Response originalResponse = Response.getOriginalResponse(response);
        if (originalResponse instanceof HttpChannelState.ChannelResponse) {
            HttpChannelState.ChannelResponse channelResponse = (HttpChannelState.ChannelResponse)originalResponse;
            return channelResponse.getContentBytesWritten();
        }
        return -1L;
    }

    public static void ensureConsumeAvailableOrNotPersistent(Request request, Response response) {
        switch (request.getConnectionMetaData().getHttpVersion()) {
            case HTTP_1_0: {
                if (Response.consumeAvailable(request)) {
                    return;
                }
                response.getHeaders().computeField(HttpHeader.CONNECTION, (h, fields) -> {
                    if (fields == null || fields.isEmpty()) {
                        return null;
                    }
                    String v = fields.stream().flatMap(field -> Stream.of(field.getValues()).filter(s -> !HttpHeaderValue.KEEP_ALIVE.is(s))).collect(Collectors.joining(", "));
                    if (StringUtil.isEmpty((String)v)) {
                        return null;
                    }
                    return new HttpField(HttpHeader.CONNECTION, v);
                });
                break;
            }
            case HTTP_1_1: {
                if (Response.consumeAvailable(request)) {
                    return;
                }
                response.getHeaders().computeField(HttpHeader.CONNECTION, (h, fields) -> {
                    if (fields == null || fields.isEmpty()) {
                        return HttpFields.CONNECTION_CLOSE;
                    }
                    if (fields.stream().anyMatch(f -> f.contains(HttpHeaderValue.CLOSE.asString()))) {
                        HttpField f2;
                        if (fields.size() == 1 && HttpFields.CONNECTION_CLOSE.equals((Object)(f2 = (HttpField)fields.get(0)))) {
                            return f2;
                        }
                        return new HttpField(HttpHeader.CONNECTION, fields.stream().flatMap(field -> Stream.of(field.getValues()).filter(s -> !HttpHeaderValue.KEEP_ALIVE.is(s))).collect(Collectors.joining(", ")));
                    }
                    return new HttpField(HttpHeader.CONNECTION, Stream.concat(fields.stream().flatMap(field -> Stream.of(field.getValues()).filter(s -> !HttpHeaderValue.KEEP_ALIVE.is(s))), Stream.of(HttpHeaderValue.CLOSE.asString())).collect(Collectors.joining(", ")));
                });
                break;
            }
        }
    }

    public static boolean consumeAvailable(Request request) {
        Content.Chunk chunk;
        do {
            if ((chunk = request.read()) == null) {
                return false;
            }
            chunk.release();
        } while (!chunk.isLast());
        return true;
    }

    public static class Wrapper
    implements Response {
        private final Request _request;
        private final Response _wrapped;

        public Wrapper(Request request, Response wrapped) {
            this._request = request;
            this._wrapped = wrapped;
        }

        @Override
        public Request getRequest() {
            return this._request;
        }

        public Response getWrapped() {
            return this._wrapped;
        }

        @Override
        public int getStatus() {
            return this.getWrapped().getStatus();
        }

        @Override
        public void setStatus(int code) {
            this.getWrapped().setStatus(code);
        }

        @Override
        public HttpFields.Mutable getHeaders() {
            return this.getWrapped().getHeaders();
        }

        @Override
        public Supplier<HttpFields> getTrailersSupplier() {
            return this.getWrapped().getTrailersSupplier();
        }

        @Override
        public void setTrailersSupplier(Supplier<HttpFields> trailers) {
            this.getWrapped().setTrailersSupplier(trailers);
        }

        public void write(boolean last, ByteBuffer byteBuffer, Callback callback) {
            this.getWrapped().write(last, byteBuffer, callback);
        }

        @Override
        public boolean isCommitted() {
            return this.getWrapped().isCommitted();
        }

        @Override
        public boolean isCompletedSuccessfully() {
            return this.getWrapped().isCompletedSuccessfully();
        }

        @Override
        public void reset() {
            this.getWrapped().reset();
        }

        @Override
        public CompletableFuture<Void> writeInterim(int status, HttpFields headers) {
            return this.getWrapped().writeInterim(status, headers);
        }
    }
}

