/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.client.io;

import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLEngine;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.ManagedSelector;
import org.eclipse.jetty.io.SelectorManager;
import org.eclipse.jetty.io.SocketChannelEndPoint;
import org.eclipse.jetty.io.ssl.SslConnection;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.client.WebSocketClient;
import org.eclipse.jetty.websocket.client.io.ConnectPromise;
import org.eclipse.jetty.websocket.client.io.UpgradeConnection;

public class WebSocketClientSelectorManager
extends SelectorManager {
    private static final Logger LOG = Log.getLogger(WebSocketClientSelectorManager.class);
    private final WebSocketPolicy policy;
    private final ByteBufferPool bufferPool;
    private SslContextFactory sslContextFactory;

    public WebSocketClientSelectorManager(WebSocketClient client) {
        super(client.getExecutor(), client.getScheduler());
        this.bufferPool = client.getBufferPool();
        this.policy = client.getPolicy();
    }

    @Override
    protected void connectionFailed(SelectableChannel channel, Throwable ex, Object attachment) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Connection Failed", ex);
        }
        ConnectPromise connect = (ConnectPromise)attachment;
        connect.failed(ex);
    }

    public SslContextFactory getSslContextFactory() {
        return this.sslContextFactory;
    }

    @Override
    public Connection newConnection(SelectableChannel channel, EndPoint endPoint, Object attachment) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("newConnection({},{},{})", channel, endPoint, attachment);
        }
        ConnectPromise connectPromise = (ConnectPromise)attachment;
        try {
            String scheme = connectPromise.getRequest().getRequestURI().getScheme();
            if ("wss".equalsIgnoreCase(scheme)) {
                SslContextFactory sslContextFactory = this.getSslContextFactory();
                if (sslContextFactory != null) {
                    SSLEngine engine = this.newSSLEngine(sslContextFactory, channel);
                    SslConnection sslConnection = new SslConnection(this.bufferPool, this.getExecutor(), endPoint, engine);
                    sslConnection.setRenegotiationAllowed(sslContextFactory.isRenegotiationAllowed());
                    SslConnection.DecryptedEndPoint sslEndPoint = sslConnection.getDecryptedEndPoint();
                    UpgradeConnection connection = this.newUpgradeConnection(channel, sslEndPoint, connectPromise);
                    sslEndPoint.setIdleTimeout(connectPromise.getClient().getMaxIdleTimeout());
                    sslEndPoint.setConnection(connection);
                    return sslConnection;
                }
                throw new IOException("Cannot init SSL");
            }
            endPoint.setIdleTimeout(connectPromise.getDriver().getPolicy().getIdleTimeout());
            return this.newUpgradeConnection(channel, endPoint, connectPromise);
        }
        catch (IOException e) {
            LOG.ignore(e);
            connectPromise.failed(e);
            throw e;
        }
    }

    @Override
    protected EndPoint newEndPoint(SelectableChannel channel, ManagedSelector selector, SelectionKey selectionKey) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("newEndPoint({}, {}, {})", channel, selector, selectionKey);
        }
        SocketChannelEndPoint endp = new SocketChannelEndPoint(channel, selector, selectionKey, this.getScheduler());
        endp.setIdleTimeout(this.policy.getIdleTimeout());
        return endp;
    }

    public SSLEngine newSSLEngine(SslContextFactory sslContextFactory, SelectableChannel channel) {
        String peerHost = null;
        int peerPort = 0;
        if (channel instanceof SocketChannel) {
            SocketChannel sc = (SocketChannel)channel;
            peerHost = sc.socket().getInetAddress().getHostName();
            peerPort = sc.socket().getPort();
        }
        SSLEngine engine = sslContextFactory.newSSLEngine(peerHost, peerPort);
        engine.setUseClientMode(true);
        return engine;
    }

    public UpgradeConnection newUpgradeConnection(SelectableChannel channel, EndPoint endPoint, ConnectPromise connectPromise) {
        WebSocketClient client = connectPromise.getClient();
        Executor executor = client.getExecutor();
        UpgradeConnection connection = new UpgradeConnection(endPoint, executor, connectPromise);
        return connection;
    }

    public void setSslContextFactory(SslContextFactory sslContextFactory) {
        this.sslContextFactory = sslContextFactory;
    }

    public WebSocketPolicy getPolicy() {
        return this.policy;
    }
}

