/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlet;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.AsyncContext;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.DateParser;
import org.eclipse.jetty.http.HttpContent;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.http.PathMap;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.http.ResourceHttpContent;
import org.eclipse.jetty.io.WriterOutputStream;
import org.eclipse.jetty.server.HttpOutput;
import org.eclipse.jetty.server.InclusiveByteRange;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.ResourceCache;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.servlet.ServletHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.MultiPartOutputStream;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.util.resource.ResourceFactory;

public class DefaultServlet
extends HttpServlet
implements ResourceFactory {
    private static final Logger LOG = Log.getLogger(DefaultServlet.class);
    private static final long serialVersionUID = 4930458713846881193L;
    private static final PreEncodedHttpField ACCEPT_RANGES = new PreEncodedHttpField(HttpHeader.ACCEPT_RANGES, "bytes");
    private ServletContext _servletContext;
    private ContextHandler _contextHandler;
    private boolean _acceptRanges = true;
    private boolean _dirAllowed = true;
    private boolean _welcomeServlets = false;
    private boolean _welcomeExactServlets = false;
    private boolean _redirectWelcome = false;
    private boolean _gzip = false;
    private boolean _pathInfoOnly = false;
    private boolean _etags = false;
    private Resource _resourceBase;
    private ResourceCache _cache;
    private MimeTypes _mimeTypes;
    private String[] _welcomes;
    private Resource _stylesheet;
    private boolean _useFileMappedBuffer = false;
    private HttpField _cacheControl;
    private String _relativeResourceBase;
    private ServletHandler _servletHandler;
    private ServletHolder _defaultHolder;
    private List<String> _gzipEquivalentFileExtensions;

    @Override
    public void init() throws UnavailableException {
        this._servletContext = this.getServletContext();
        this._contextHandler = this.initContextHandler(this._servletContext);
        this._mimeTypes = this._contextHandler.getMimeTypes();
        this._welcomes = this._contextHandler.getWelcomeFiles();
        if (this._welcomes == null) {
            this._welcomes = new String[]{"index.html", "index.jsp"};
        }
        this._acceptRanges = this.getInitBoolean("acceptRanges", this._acceptRanges);
        this._dirAllowed = this.getInitBoolean("dirAllowed", this._dirAllowed);
        this._redirectWelcome = this.getInitBoolean("redirectWelcome", this._redirectWelcome);
        this._gzip = this.getInitBoolean("gzip", this._gzip);
        this._pathInfoOnly = this.getInitBoolean("pathInfoOnly", this._pathInfoOnly);
        if ("exact".equals(this.getInitParameter("welcomeServlets"))) {
            this._welcomeExactServlets = true;
            this._welcomeServlets = false;
        } else {
            this._welcomeServlets = this.getInitBoolean("welcomeServlets", this._welcomeServlets);
        }
        this._useFileMappedBuffer = this.getInitBoolean("useFileMappedBuffer", this._useFileMappedBuffer);
        this._relativeResourceBase = this.getInitParameter("relativeResourceBase");
        String rb = this.getInitParameter("resourceBase");
        if (rb != null) {
            if (this._relativeResourceBase != null) {
                throw new UnavailableException("resourceBase & relativeResourceBase");
            }
            try {
                this._resourceBase = this._contextHandler.newResource(rb);
            }
            catch (Exception e) {
                LOG.warn("EXCEPTION ", e);
                throw new UnavailableException(e.toString());
            }
        }
        String css = this.getInitParameter("stylesheet");
        try {
            if (css != null) {
                this._stylesheet = Resource.newResource(css);
                if (!this._stylesheet.exists()) {
                    LOG.warn("!" + css, new Object[0]);
                    this._stylesheet = null;
                }
            }
            if (this._stylesheet == null) {
                this._stylesheet = Resource.newResource(this.getClass().getResource("/jetty-dir.css"));
            }
        }
        catch (Exception e) {
            LOG.warn(e.toString(), new Object[0]);
            LOG.debug(e);
        }
        String cc = this.getInitParameter("cacheControl");
        if (cc != null) {
            this._cacheControl = new PreEncodedHttpField(HttpHeader.CACHE_CONTROL, cc);
        }
        String resourceCache = this.getInitParameter("resourceCache");
        int max_cache_size = this.getInitInt("maxCacheSize", -2);
        int max_cached_file_size = this.getInitInt("maxCachedFileSize", -2);
        int max_cached_files = this.getInitInt("maxCachedFiles", -2);
        if (resourceCache != null) {
            if (max_cache_size != -1 || max_cached_file_size != -2 || max_cached_files != -2) {
                LOG.debug("ignoring resource cache configuration, using resourceCache attribute", new Object[0]);
            }
            if (this._relativeResourceBase != null || this._resourceBase != null) {
                throw new UnavailableException("resourceCache specified with resource bases");
            }
            this._cache = (ResourceCache)this._servletContext.getAttribute(resourceCache);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cache {}={}", resourceCache, this._cache);
            }
        }
        this._etags = this.getInitBoolean("etags", this._etags);
        try {
            if (this._cache == null && (max_cached_files != -2 || max_cache_size != -2 || max_cached_file_size != -2)) {
                this._cache = new ResourceCache(null, this, this._mimeTypes, this._useFileMappedBuffer, this._etags);
                if (max_cache_size >= 0) {
                    this._cache.setMaxCacheSize(max_cache_size);
                }
                if (max_cached_file_size >= -1) {
                    this._cache.setMaxCachedFileSize(max_cached_file_size);
                }
                if (max_cached_files >= -1) {
                    this._cache.setMaxCachedFiles(max_cached_files);
                }
            }
        }
        catch (Exception e) {
            LOG.warn("EXCEPTION ", e);
            throw new UnavailableException(e.toString());
        }
        this._gzipEquivalentFileExtensions = new ArrayList<String>();
        String otherGzipExtensions = this.getInitParameter("otherGzipFileExtensions");
        if (otherGzipExtensions != null) {
            StringTokenizer tok = new StringTokenizer(otherGzipExtensions, ",", false);
            while (tok.hasMoreTokens()) {
                String s = tok.nextToken().trim();
                this._gzipEquivalentFileExtensions.add(s.charAt(0) == '.' ? s : "." + s);
            }
        } else {
            this._gzipEquivalentFileExtensions.add(".svgz");
        }
        this._servletHandler = this._contextHandler.getChildHandlerByClass(ServletHandler.class);
        for (ServletHolder h : this._servletHandler.getServlets()) {
            if (h.getServletInstance() != this) continue;
            this._defaultHolder = h;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("resource base = " + this._resourceBase, new Object[0]);
        }
    }

    protected ContextHandler initContextHandler(ServletContext servletContext) {
        ContextHandler.Context scontext = ContextHandler.getCurrentContext();
        if (scontext == null) {
            if (servletContext instanceof ContextHandler.Context) {
                return ((ContextHandler.Context)servletContext).getContextHandler();
            }
            throw new IllegalArgumentException("The servletContext " + servletContext + " " + servletContext.getClass().getName() + " is not " + ContextHandler.Context.class.getName());
        }
        return ContextHandler.getCurrentContext().getContextHandler();
    }

    @Override
    public String getInitParameter(String name) {
        String value = this.getServletContext().getInitParameter("org.eclipse.jetty.servlet.Default." + name);
        if (value == null) {
            value = super.getInitParameter(name);
        }
        return value;
    }

    private boolean getInitBoolean(String name, boolean dft) {
        String value = this.getInitParameter(name);
        if (value == null || value.length() == 0) {
            return dft;
        }
        return value.startsWith("t") || value.startsWith("T") || value.startsWith("y") || value.startsWith("Y") || value.startsWith("1");
    }

    private int getInitInt(String name, int dft) {
        String value = this.getInitParameter(name);
        if (value == null) {
            value = this.getInitParameter(name);
        }
        if (value != null && value.length() > 0) {
            return Integer.parseInt(value);
        }
        return dft;
    }

    @Override
    public Resource getResource(String pathInContext) {
        Resource r = null;
        if (this._relativeResourceBase != null) {
            pathInContext = URIUtil.addPaths(this._relativeResourceBase, pathInContext);
        }
        try {
            if (this._resourceBase != null) {
                r = this._resourceBase.addPath(pathInContext);
                if (!this._contextHandler.checkAlias(pathInContext, r)) {
                    r = null;
                }
            } else if (this._servletContext instanceof ContextHandler.Context) {
                r = this._contextHandler.getResource(pathInContext);
            } else {
                URL u = this._servletContext.getResource(pathInContext);
                r = this._contextHandler.newResource(u);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Resource " + pathInContext + "=" + r, new Object[0]);
            }
        }
        catch (IOException e) {
            LOG.ignore(e);
        }
        if ((r == null || !r.exists()) && pathInContext.endsWith("/jetty-dir.css")) {
            r = this._stylesheet;
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block50: {
            String servletPath = null;
            String pathInfo = null;
            Enumeration<String> reqRanges = null;
            Boolean included = request.getAttribute("javax.servlet.include.request_uri") != null;
            if (included != null && included.booleanValue()) {
                servletPath = (String)request.getAttribute("javax.servlet.include.servlet_path");
                pathInfo = (String)request.getAttribute("javax.servlet.include.path_info");
                if (servletPath == null) {
                    servletPath = request.getServletPath();
                    pathInfo = request.getPathInfo();
                }
            } else {
                included = Boolean.FALSE;
                servletPath = this._pathInfoOnly ? "/" : request.getServletPath();
                pathInfo = request.getPathInfo();
                reqRanges = request.getHeaders(HttpHeader.RANGE.asString());
                if (!this.hasDefinedRange(reqRanges)) {
                    reqRanges = null;
                }
            }
            String pathInContext = URIUtil.addPaths(servletPath, pathInfo);
            boolean endsWithSlash = (pathInfo == null ? request.getServletPath() : pathInfo).endsWith("/");
            Resource resource = null;
            HttpContent content = null;
            try {
                String pathInContextGz = null;
                boolean gzip = false;
                if (!included.booleanValue() && this._gzip && reqRanges == null && !endsWithSlash) {
                    pathInContextGz = pathInContext + ".gz";
                    if (this._cache == null) {
                        resource = this.getResource(pathInContextGz);
                    } else {
                        content = this._cache.lookup(pathInContextGz);
                        Resource resource2 = resource = content == null ? null : content.getResource();
                    }
                    if (resource != null && resource.exists() && !resource.isDirectory()) {
                        response.addHeader(HttpHeader.VARY.asString(), HttpHeader.ACCEPT_ENCODING.asString());
                        String accept = request.getHeader(HttpHeader.ACCEPT_ENCODING.asString());
                        if (accept != null && accept.indexOf("gzip") >= 0) {
                            gzip = true;
                        }
                    }
                }
                if (!gzip) {
                    if (this._cache == null) {
                        resource = this.getResource(pathInContext);
                    } else {
                        content = this._cache.lookup(pathInContext);
                        Resource resource3 = resource = content == null ? null : content.getResource();
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("uri=%s, resource=%s, content=%s", request.getRequestURI(), resource, content), new Object[0]);
                }
                if (resource == null || !resource.exists()) {
                    if (included.booleanValue()) {
                        throw new FileNotFoundException("!" + pathInContext);
                    }
                    response.sendError(404);
                    break block50;
                }
                if (!resource.isDirectory()) {
                    if (endsWithSlash && pathInContext.length() > 1) {
                        String q = request.getQueryString();
                        pathInContext = pathInContext.substring(0, pathInContext.length() - 1);
                        if (q != null && q.length() != 0) {
                            pathInContext = pathInContext + "?" + q;
                        }
                        response.sendRedirect(response.encodeRedirectURL(URIUtil.addPaths(this._servletContext.getContextPath(), pathInContext)));
                    } else {
                        if (content == null) {
                            content = new ResourceHttpContent(resource, this._mimeTypes.getMimeByExtension(resource.toString()), response.getBufferSize(), this._etags);
                        }
                        if (included.booleanValue() || this.passConditionalHeaders(request, response, resource, content)) {
                            if (gzip || this.isGzippedContent(pathInContext)) {
                                response.setHeader(HttpHeader.CONTENT_ENCODING.asString(), "gzip");
                                String mt = this._servletContext.getMimeType(pathInContext);
                                if (mt != null) {
                                    response.setContentType(mt);
                                }
                            }
                            this.sendData(request, response, included, resource, content, reqRanges);
                        }
                    }
                    break block50;
                }
                String welcome = null;
                if (!endsWithSlash || pathInContext.length() == 1 && request.getAttribute("org.eclipse.jetty.server.nullPathInfo") != null) {
                    StringBuffer buf;
                    StringBuffer stringBuffer = buf = request.getRequestURL();
                    synchronized (stringBuffer) {
                        int param = buf.lastIndexOf(";");
                        if (param < 0) {
                            buf.append('/');
                        } else {
                            buf.insert(param, '/');
                        }
                        String q = request.getQueryString();
                        if (q != null && q.length() != 0) {
                            buf.append('?');
                            buf.append(q);
                        }
                        response.setContentLength(0);
                        response.sendRedirect(response.encodeRedirectURL(buf.toString()));
                        break block50;
                    }
                }
                welcome = this.getWelcomeFile(pathInContext);
                if (null != welcome) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("welcome={}", welcome);
                    }
                    if (this._redirectWelcome) {
                        response.setContentLength(0);
                        String q = request.getQueryString();
                        if (q != null && q.length() != 0) {
                            response.sendRedirect(response.encodeRedirectURL(URIUtil.addPaths(this._servletContext.getContextPath(), welcome) + "?" + q));
                        } else {
                            response.sendRedirect(response.encodeRedirectURL(URIUtil.addPaths(this._servletContext.getContextPath(), welcome)));
                        }
                    } else {
                        RequestDispatcher dispatcher = request.getRequestDispatcher(welcome);
                        if (dispatcher != null) {
                            if (included.booleanValue()) {
                                dispatcher.include(request, response);
                            } else {
                                request.setAttribute("org.eclipse.jetty.server.welcome", welcome);
                                dispatcher.forward(request, response);
                            }
                        }
                    }
                } else {
                    content = new ResourceHttpContent(resource, this._mimeTypes.getMimeByExtension(resource.toString()), this._etags);
                    if (included.booleanValue() || this.passConditionalHeaders(request, response, resource, content)) {
                        this.sendDirectory(request, response, resource, pathInContext);
                    }
                }
            }
            catch (IllegalArgumentException e) {
                LOG.warn("EXCEPTION ", e);
                if (!response.isCommitted()) {
                    response.sendError(500, e.getMessage());
                }
            }
            finally {
                if (content != null) {
                    content.release();
                } else if (resource != null) {
                    resource.close();
                }
            }
        }
    }

    protected boolean isGzippedContent(String path) {
        if (path == null) {
            return false;
        }
        for (String suffix : this._gzipEquivalentFileExtensions) {
            if (!path.endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    private boolean hasDefinedRange(Enumeration<String> reqRanges) {
        return reqRanges != null && reqRanges.hasMoreElements();
    }

    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    @Override
    protected void doTrace(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.sendError(405);
    }

    @Override
    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setHeader("Allow", "GET,HEAD,POST,OPTIONS");
    }

    private String getWelcomeFile(String pathInContext) throws MalformedURLException, IOException {
        if (this._welcomes == null) {
            return null;
        }
        String welcome_servlet = null;
        for (int i = 0; i < this._welcomes.length; ++i) {
            PathMap.MappedEntry<ServletHolder> entry;
            String welcome_in_context = URIUtil.addPaths(pathInContext, this._welcomes[i]);
            Resource welcome = this.getResource(welcome_in_context);
            if (welcome != null && welcome.exists()) {
                return this._welcomes[i];
            }
            if (!this._welcomeServlets && !this._welcomeExactServlets || welcome_servlet != null || (entry = this._servletHandler.getHolderEntry(welcome_in_context)) == null || entry.getValue() == this._defaultHolder || !this._welcomeServlets && (!this._welcomeExactServlets || !entry.getKey().equals(welcome_in_context))) continue;
            welcome_servlet = welcome_in_context;
        }
        return welcome_servlet;
    }

    protected boolean passConditionalHeaders(HttpServletRequest request, HttpServletResponse response, Resource resource, HttpContent content) throws IOException {
        try {
            String ifm = null;
            String ifnm = null;
            String ifms = null;
            long ifums = -1L;
            if (request instanceof Request) {
                HttpFields fields = ((Request)request).getHttpFields();
                int i = fields.size();
                while (i-- > 0) {
                    HttpField field = fields.getField(i);
                    if (field.getHeader() == null) continue;
                    switch (field.getHeader()) {
                        case IF_MATCH: {
                            ifm = field.getValue();
                            break;
                        }
                        case IF_NONE_MATCH: {
                            ifnm = field.getValue();
                            break;
                        }
                        case IF_MODIFIED_SINCE: {
                            ifms = field.getValue();
                            break;
                        }
                        case IF_UNMODIFIED_SINCE: {
                            ifums = DateParser.parseDate(field.getValue());
                            break;
                        }
                    }
                }
            } else {
                ifm = request.getHeader(HttpHeader.IF_MATCH.asString());
                ifnm = request.getHeader(HttpHeader.IF_NONE_MATCH.asString());
                ifms = request.getHeader(HttpHeader.IF_MODIFIED_SINCE.asString());
                ifums = request.getDateHeader(HttpHeader.IF_UNMODIFIED_SINCE.asString());
            }
            if (!HttpMethod.HEAD.is(request.getMethod())) {
                if (this._etags) {
                    if (ifm != null) {
                        boolean match = false;
                        if (content.getETagValue() != null) {
                            QuotedStringTokenizer quoted = new QuotedStringTokenizer(ifm, ", ", false, true);
                            while (!match && quoted.hasMoreTokens()) {
                                String tag = quoted.nextToken();
                                if (!content.getETagValue().equals(tag)) continue;
                                match = true;
                            }
                        }
                        if (!match) {
                            response.setStatus(412);
                            return false;
                        }
                    }
                    if (ifnm != null && content.getETagValue() != null) {
                        if (content.getETagValue().equals(request.getAttribute("o.e.j.s.Gzip.ETag"))) {
                            response.setStatus(304);
                            response.setHeader(HttpHeader.ETAG.asString(), ifnm);
                            return false;
                        }
                        if (content.getETagValue().equals(ifnm)) {
                            response.setStatus(304);
                            response.setHeader(HttpHeader.ETAG.asString(), content.getETagValue());
                            return false;
                        }
                        QuotedStringTokenizer quoted = new QuotedStringTokenizer(ifnm, ", ", false, true);
                        while (quoted.hasMoreTokens()) {
                            String tag = quoted.nextToken();
                            if (!content.getETagValue().equals(tag)) continue;
                            response.setStatus(304);
                            response.setHeader(HttpHeader.ETAG.asString(), content.getETagValue());
                            return false;
                        }
                        return true;
                    }
                }
                if (ifms != null) {
                    String mdlm = content.getLastModifiedValue();
                    if (mdlm != null && ifms.equals(mdlm)) {
                        response.setStatus(304);
                        if (this._etags) {
                            response.setHeader(HttpHeader.ETAG.asString(), content.getETagValue());
                        }
                        response.flushBuffer();
                        return false;
                    }
                    long ifmsl = request.getDateHeader(HttpHeader.IF_MODIFIED_SINCE.asString());
                    if (ifmsl != -1L && resource.lastModified() / 1000L <= ifmsl / 1000L) {
                        response.setStatus(304);
                        if (this._etags) {
                            response.setHeader(HttpHeader.ETAG.asString(), content.getETagValue());
                        }
                        response.flushBuffer();
                        return false;
                    }
                }
                if (ifums != -1L && resource.lastModified() / 1000L > ifums / 1000L) {
                    response.sendError(412);
                    return false;
                }
            }
        }
        catch (IllegalArgumentException iae) {
            if (!response.isCommitted()) {
                response.sendError(400, iae.getMessage());
            }
            throw iae;
        }
        return true;
    }

    protected void sendDirectory(HttpServletRequest request, HttpServletResponse response, Resource resource, String pathInContext) throws IOException {
        String dir;
        if (!this._dirAllowed) {
            response.sendError(403);
            return;
        }
        byte[] data = null;
        String base = URIUtil.addPaths(request.getRequestURI(), "/");
        if (this._resourceBase != null) {
            if (this._resourceBase instanceof ResourceCollection) {
                resource = this._resourceBase.addPath(pathInContext);
            }
        } else if (this._contextHandler.getBaseResource() instanceof ResourceCollection) {
            resource = this._contextHandler.getBaseResource().addPath(pathInContext);
        }
        if ((dir = resource.getListHTML(base, pathInContext.length() > 1)) == null) {
            response.sendError(403, "No directory");
            return;
        }
        data = dir.getBytes("utf-8");
        response.setContentType("text/html;charset=utf-8");
        response.setContentLength(data.length);
        response.getOutputStream().write(data);
    }

    protected void sendData(HttpServletRequest request, HttpServletResponse response, boolean include, Resource resource, HttpContent content, Enumeration<String> reqRanges) throws IOException {
        boolean written;
        long content_length = content == null ? resource.length() : content.getContentLengthValue();
        OutputStream out = null;
        try {
            out = response.getOutputStream();
            written = out instanceof HttpOutput ? ((HttpOutput)out).isWritten() : true;
        }
        catch (IllegalStateException e) {
            out = new WriterOutputStream(response.getWriter());
            written = true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("sendData content=%s out=%s async=%b", content, out, request.isAsyncSupported()), new Object[0]);
        }
        if (reqRanges == null || !reqRanges.hasMoreElements() || content_length < 0L) {
            if (include) {
                resource.writeTo(out, 0L, content_length);
            } else if (content == null || written || !(out instanceof HttpOutput)) {
                ByteBuffer buffer;
                this.putHeaders(response, content, written ? -1L : 0L);
                ByteBuffer byteBuffer = buffer = content == null ? null : content.getIndirectBuffer();
                if (buffer != null) {
                    BufferUtil.writeTo(buffer, out);
                } else {
                    resource.writeTo(out, 0L, content_length);
                }
            } else {
                this.putHeaders(response, content, 0L);
                if (request.isAsyncSupported()) {
                    final AsyncContext context = request.startAsync();
                    context.setTimeout(0L);
                    ((HttpOutput)out).sendContent(content, new Callback(){

                        @Override
                        public void succeeded() {
                            context.complete();
                        }

                        @Override
                        public void failed(Throwable x) {
                            if (x instanceof IOException) {
                                LOG.debug(x);
                            } else {
                                LOG.warn(x);
                            }
                            context.complete();
                        }

                        public String toString() {
                            return String.format("DefaultServlet@%x$CB", DefaultServlet.this.hashCode());
                        }
                    });
                } else {
                    ((HttpOutput)out).sendContent(content);
                }
            }
        } else {
            InclusiveByteRange ibr;
            int i;
            String mimetype;
            List<InclusiveByteRange> ranges = InclusiveByteRange.satisfiableRanges(reqRanges, content_length);
            if (ranges == null || ranges.size() == 0) {
                this.putHeaders(response, content, 0L);
                response.setStatus(416);
                response.setHeader(HttpHeader.CONTENT_RANGE.asString(), InclusiveByteRange.to416HeaderRangeString(content_length));
                resource.writeTo(out, 0L, content_length);
                return;
            }
            if (ranges.size() == 1) {
                InclusiveByteRange singleSatisfiableRange = ranges.get(0);
                long singleLength = singleSatisfiableRange.getSize(content_length);
                this.putHeaders(response, content, singleLength);
                response.setStatus(206);
                if (!response.containsHeader(HttpHeader.DATE.asString())) {
                    response.addDateHeader(HttpHeader.DATE.asString(), System.currentTimeMillis());
                }
                response.setHeader(HttpHeader.CONTENT_RANGE.asString(), singleSatisfiableRange.toHeaderRangeString(content_length));
                resource.writeTo(out, singleSatisfiableRange.getFirst(content_length), singleLength);
                return;
            }
            this.putHeaders(response, content, -1L);
            String string = mimetype = content == null ? null : content.getContentTypeValue();
            if (mimetype == null) {
                LOG.warn("Unknown mimetype for " + request.getRequestURI(), new Object[0]);
            }
            MultiPartOutputStream multi = new MultiPartOutputStream(out);
            response.setStatus(206);
            if (!response.containsHeader(HttpHeader.DATE.asString())) {
                response.addDateHeader(HttpHeader.DATE.asString(), System.currentTimeMillis());
            }
            String ctp = request.getHeader(HttpHeader.REQUEST_RANGE.asString()) != null ? "multipart/x-byteranges; boundary=" : "multipart/byteranges; boundary=";
            response.setContentType(ctp + multi.getBoundary());
            InputStream in = resource.getInputStream();
            long pos = 0L;
            int length = 0;
            String[] header = new String[ranges.size()];
            for (i = 0; i < ranges.size(); ++i) {
                ibr = ranges.get(i);
                header[i] = ibr.toHeaderRangeString(content_length);
                length = (int)((long)length + ((long)((i > 0 ? 2 : 0) + 2 + multi.getBoundary().length() + 2 + (mimetype == null ? 0 : HttpHeader.CONTENT_TYPE.asString().length() + 2 + mimetype.length()) + 2 + HttpHeader.CONTENT_RANGE.asString().length() + 2 + header[i].length() + 2 + 2) + (ibr.getLast(content_length) - ibr.getFirst(content_length)) + 1L));
            }
            response.setContentLength(length += 4 + multi.getBoundary().length() + 2 + 2);
            for (i = 0; i < ranges.size(); ++i) {
                ibr = ranges.get(i);
                multi.startPart(mimetype, new String[]{(Object)((Object)HttpHeader.CONTENT_RANGE) + ": " + header[i]});
                long start = ibr.getFirst(content_length);
                long size = ibr.getSize(content_length);
                if (in != null) {
                    if (start < pos) {
                        in.close();
                        in = resource.getInputStream();
                        pos = 0L;
                    }
                    if (pos < start) {
                        in.skip(start - pos);
                        pos = start;
                    }
                    IO.copy(in, multi, size);
                    pos += size;
                    continue;
                }
                resource.writeTo(multi, start, size);
            }
            if (in != null) {
                in.close();
            }
            multi.close();
        }
    }

    protected void putHeaders(HttpServletResponse response, HttpContent content, long contentLength) {
        if (response instanceof Response) {
            Response r = (Response)response;
            r.putHeaders(content, contentLength, this._etags);
            HttpFields f = r.getHttpFields();
            if (this._acceptRanges) {
                f.put(ACCEPT_RANGES);
            }
            if (this._cacheControl != null) {
                f.put(this._cacheControl);
            }
        } else {
            Response.putHeaders(response, content, contentLength, this._etags);
            if (this._acceptRanges) {
                response.setHeader(ACCEPT_RANGES.getName(), ACCEPT_RANGES.getValue());
            }
            if (this._cacheControl != null) {
                response.setHeader(this._cacheControl.getName(), this._cacheControl.getValue());
            }
        }
    }

    @Override
    public void destroy() {
        if (this._cache != null) {
            this._cache.flushCache();
        }
        super.destroy();
    }
}

