/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.server;

import java.net.InetSocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.extensions.IncomingFrames;
import org.eclipse.jetty.websocket.common.io.AbstractWebSocketConnection;
import org.eclipse.jetty.websocket.server.WebSocketServerFactory;

public class WebSocketServerConnection
extends AbstractWebSocketConnection {
    private final WebSocketServerFactory factory;
    private final AtomicBoolean opened = new AtomicBoolean(false);

    public WebSocketServerConnection(EndPoint endp, Executor executor, Scheduler scheduler, WebSocketPolicy policy, ByteBufferPool bufferPool, WebSocketServerFactory factory) {
        super(endp, executor, scheduler, policy, bufferPool);
        if (policy.getIdleTimeout() > 0L) {
            endp.setIdleTimeout(policy.getIdleTimeout());
        }
        this.factory = factory;
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return this.getEndPoint().getLocalAddress();
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.getEndPoint().getRemoteAddress();
    }

    @Override
    public void onClose() {
        super.onClose();
        this.factory.sessionClosed(this.getSession());
    }

    @Override
    public void onOpen() {
        boolean beenOpened = this.opened.getAndSet(true);
        if (!beenOpened) {
            this.factory.sessionOpened(this.getSession());
        }
        super.onOpen();
    }

    @Override
    public void onWriteWebSocketClose() {
        this.disconnect();
    }

    @Override
    public void setNextIncomingFrames(IncomingFrames incoming) {
        this.getParser().setIncomingFramesHandler(incoming);
    }
}

