/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.reactive.client.internal;

import java.nio.ByteBuffer;
import java.util.function.BiFunction;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.reactive.client.ContentChunk;
import org.eclipse.jetty.reactive.client.ReactiveRequest;
import org.eclipse.jetty.reactive.client.ReactiveResponse;
import org.eclipse.jetty.reactive.client.internal.AbstractSingleProcessor;
import org.eclipse.jetty.reactive.client.internal.QueuedSinglePublisher;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseListenerPublisher<T>
extends AbstractSingleProcessor<T, T>
implements Response.Listener {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final QueuedSinglePublisher<ContentChunk> content = new QueuedSinglePublisher();
    private final ReactiveRequest request;
    private final BiFunction<ReactiveResponse, Publisher<ContentChunk>, Publisher<T>> contentFn;
    private boolean requestSent;
    private long demand;

    public ResponseListenerPublisher(ReactiveRequest request, BiFunction<ReactiveResponse, Publisher<ContentChunk>, Publisher<T>> contentFn) {
        this.request = request;
        this.contentFn = contentFn;
    }

    public void onBegin(Response response) {
    }

    public boolean onHeader(Response response, HttpField field) {
        return true;
    }

    public void onHeaders(Response response) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("received response headers {}", (Object)response);
        }
        Publisher<T> publisher = this.contentFn.apply(this.request.getReactiveResponse(), this.content);
        publisher.subscribe((Subscriber)this);
    }

    public void onContent(Response response, ByteBuffer buffer, Callback callback) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("received response chunk {} {}", (Object)response, (Object)BufferUtil.toSummaryString((ByteBuffer)buffer));
        }
        this.content.offer(new ContentChunk(buffer, callback));
    }

    public void onContent(Response response, ByteBuffer content) {
    }

    public void onSuccess(Response response) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("response complete {}", (Object)response);
        }
    }

    public void onFailure(Response response, Throwable failure) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("response failure " + response, failure);
        }
    }

    public void onComplete(Result result) {
        if (result.isSucceeded()) {
            this.content.complete();
        } else {
            this.content.fail(result.getFailure());
        }
    }

    @Override
    public void onSubscribe(Subscription subscription) {
        super.onSubscribe(subscription);
        subscription.request(this.demand);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onRequest(long n) {
        boolean send = false;
        ResponseListenerPublisher responseListenerPublisher = this;
        synchronized (responseListenerPublisher) {
            if (!this.requestSent) {
                this.requestSent = true;
                this.demand += n;
                send = true;
            }
        }
        if (send) {
            this.send();
        } else {
            super.onRequest(n);
        }
    }

    public void onNext(T t) {
        this.downStream().onNext(t);
    }

    private void send() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("sending request {}", (Object)this.request);
        }
        this.request.getRequest().send((Response.CompleteListener)this);
    }

    @Override
    public String toString() {
        return String.format("%s@%x[%s]", this.getClass().getSimpleName(), this.hashCode(), this.request);
    }
}

