/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.plugins;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.jetty.plugins.MavenService;
import org.eclipse.jetty.plugins.PluginManager;
import org.eclipse.jetty.plugins.model.Plugin;

public class DefaultPluginManager
implements PluginManager {
    private String _jettyHome;
    private MavenService _mavenService;
    private static List<String> excludes = Arrays.asList("META-INF");

    public DefaultPluginManager(MavenService mavenService, String jettyHome) {
        this._mavenService = mavenService;
        this._jettyHome = jettyHome;
    }

    @Override
    public Set<String> listAvailablePlugins() {
        return this._mavenService.listAvailablePlugins();
    }

    @Override
    public void installPlugin(String pluginName) {
        Plugin plugin = this._mavenService.getPlugin(pluginName);
        this.installPlugin(plugin);
    }

    private void installPlugin(Plugin plugin) {
        try {
            ZipFile pluginJar = new ZipFile(plugin.getPluginJar());
            this.extractJar(pluginJar);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private void extractJar(ZipFile file) {
        Enumeration<? extends ZipEntry> entries = file.entries();
        while (entries.hasMoreElements()) {
            this.extractFileFromJar(file, entries.nextElement());
        }
    }

    private void extractFileFromJar(ZipFile zipFile, ZipEntry zipEntry) {
        for (String exclude : excludes) {
            if (!zipEntry.getName().startsWith(exclude)) continue;
            return;
        }
        System.out.println("Extracting: " + zipEntry.getName());
        File f = new File(this._jettyHome + File.separator + zipEntry.getName());
        if (zipEntry.isDirectory()) {
            if (!f.mkdir()) {
                System.out.println("Can't create directory: " + f);
            }
            return;
        }
        try (InputStream is = zipFile.getInputStream(zipEntry);
             FileOutputStream fos = new FileOutputStream(f);){
            while (is.available() > 0) {
                fos.write(is.read());
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not extract plugin zip", e);
        }
    }
}

