/*
 * Decompiled with CFR 0.152.
 */
package embedded.client.http2;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http2.ErrorCode;
import org.eclipse.jetty.http2.api.Session;
import org.eclipse.jetty.http2.api.Stream;
import org.eclipse.jetty.http2.client.HTTP2Client;
import org.eclipse.jetty.http2.frames.DataFrame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.http2.frames.PushPromiseFrame;
import org.eclipse.jetty.http2.frames.ResetFrame;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class HTTP2ClientDocs {
    public void start() throws Exception {
        HTTP2Client http2Client = new HTTP2Client();
        http2Client.setStreamIdleTimeout(15000L);
        http2Client.start();
    }

    public void stop() throws Exception {
        HTTP2Client http2Client = new HTTP2Client();
        http2Client.start();
        http2Client.stop();
    }

    public void clearTextConnect() throws Exception {
        HTTP2Client http2Client = new HTTP2Client();
        http2Client.start();
        InetSocketAddress serverAddress = new InetSocketAddress("localhost", 8080);
        CompletableFuture sessionCF = http2Client.connect((SocketAddress)serverAddress, (Session.Listener)new Session.Listener.Adapter());
        Session session = (Session)sessionCF.get();
    }

    public void encryptedConnect() throws Exception {
        HTTP2Client http2Client = new HTTP2Client();
        http2Client.start();
        ClientConnector connector = http2Client.getClientConnector();
        InetSocketAddress serverAddress = new InetSocketAddress("localhost", 8443);
        CompletableFuture sessionCF = http2Client.connect((SslContextFactory)connector.getSslContextFactory(), (SocketAddress)serverAddress, (Session.Listener)new Session.Listener.Adapter());
        Session session = (Session)sessionCF.get();
    }

    public void configure() throws Exception {
        HTTP2Client http2Client = new HTTP2Client();
        http2Client.start();
        InetSocketAddress serverAddress = new InetSocketAddress("localhost", 8080);
        http2Client.connect((SocketAddress)serverAddress, (Session.Listener)new Session.Listener.Adapter(){

            public Map<Integer, Integer> onPreface(Session session) {
                HashMap<Integer, Integer> configuration = new HashMap<Integer, Integer>();
                configuration.put(2, 0);
                configuration.put(4, 0x100000);
                return configuration;
            }
        });
    }

    public void newStream() throws Exception {
        HTTP2Client http2Client = new HTTP2Client();
        http2Client.start();
        InetSocketAddress serverAddress = new InetSocketAddress("localhost", 8080);
        CompletableFuture sessionCF = http2Client.connect((SocketAddress)serverAddress, (Session.Listener)new Session.Listener.Adapter());
        Session session = (Session)sessionCF.get();
        HttpFields.Mutable requestHeaders = HttpFields.build().put(HttpHeader.USER_AGENT, "Jetty HTTP2Client {version}");
        MetaData.Request request = new MetaData.Request("GET", (HttpURI)HttpURI.from((String)"http://localhost:8080/path"), HttpVersion.HTTP_2, (HttpFields)requestHeaders);
        HeadersFrame headersFrame = new HeadersFrame((MetaData)request, null, true);
        session.newStream(headersFrame, (Stream.Listener)new Stream.Listener.Adapter());
    }

    public void newStreamWithData() throws Exception {
        HTTP2Client http2Client = new HTTP2Client();
        http2Client.start();
        InetSocketAddress serverAddress = new InetSocketAddress("localhost", 8080);
        CompletableFuture sessionCF = http2Client.connect((SocketAddress)serverAddress, (Session.Listener)new Session.Listener.Adapter());
        Session session = (Session)sessionCF.get();
        HttpFields.Mutable requestHeaders = HttpFields.build().put(HttpHeader.CONTENT_TYPE, "application/json");
        MetaData.Request request = new MetaData.Request("POST", (HttpURI)HttpURI.from((String)"http://localhost:8080/path"), HttpVersion.HTTP_2, (HttpFields)requestHeaders);
        HeadersFrame headersFrame = new HeadersFrame((MetaData)request, null, false);
        CompletableFuture streamCF = session.newStream(headersFrame, (Stream.Listener)new Stream.Listener.Adapter());
        Stream stream = (Stream)streamCF.get();
        String content1 = "{\"greet\": \"hello world\"}";
        ByteBuffer buffer1 = StandardCharsets.UTF_8.encode(content1);
        String content2 = "{\"user\": \"jetty\"}";
        ByteBuffer buffer2 = StandardCharsets.UTF_8.encode(content2);
        CompletableFuture dataCF1 = stream.data(new DataFrame(stream.getId(), buffer1, false));
        dataCF1.thenCompose(s -> s.data(new DataFrame(s.getId(), buffer2, true)));
    }

    public void responseListener() throws Exception {
        HTTP2Client http2Client = new HTTP2Client();
        http2Client.start();
        InetSocketAddress serverAddress = new InetSocketAddress("localhost", 8080);
        CompletableFuture sessionCF = http2Client.connect((SocketAddress)serverAddress, (Session.Listener)new Session.Listener.Adapter());
        Session session = (Session)sessionCF.get();
        HttpFields.Mutable requestHeaders = HttpFields.build().put(HttpHeader.USER_AGENT, "Jetty HTTP2Client {version}");
        MetaData.Request request = new MetaData.Request("GET", (HttpURI)HttpURI.from((String)"http://localhost:8080/path"), HttpVersion.HTTP_2, (HttpFields)requestHeaders);
        HeadersFrame headersFrame = new HeadersFrame((MetaData)request, null, true);
        session.newStream(headersFrame, (Stream.Listener)new Stream.Listener.Adapter(){

            public void onHeaders(Stream stream, HeadersFrame frame) {
                MetaData metaData = frame.getMetaData();
                if (metaData.isResponse()) {
                    MetaData.Response response = (MetaData.Response)metaData;
                    System.getLogger("http2").log(System.Logger.Level.INFO, "Received response {0}", response);
                } else {
                    System.getLogger("http2").log(System.Logger.Level.INFO, "Received trailers {0}", metaData.getFields());
                }
            }

            public void onData(Stream stream, DataFrame frame, Callback callback) {
                ByteBuffer buffer = frame.getData();
                System.getLogger("http2").log(System.Logger.Level.INFO, "Consuming buffer {0}", buffer);
                callback.succeeded();
            }
        });
    }

    public void reset() throws Exception {
        HTTP2Client http2Client = new HTTP2Client();
        http2Client.start();
        InetSocketAddress serverAddress = new InetSocketAddress("localhost", 8080);
        CompletableFuture sessionCF = http2Client.connect((SocketAddress)serverAddress, (Session.Listener)new Session.Listener.Adapter());
        Session session = (Session)sessionCF.get();
        HttpFields.Mutable requestHeaders = HttpFields.build().put(HttpHeader.USER_AGENT, "Jetty HTTP2Client {version}");
        MetaData.Request request = new MetaData.Request("GET", (HttpURI)HttpURI.from((String)"http://localhost:8080/path"), HttpVersion.HTTP_2, (HttpFields)requestHeaders);
        HeadersFrame headersFrame = new HeadersFrame((MetaData)request, null, true);
        CompletableFuture streamCF = session.newStream(headersFrame, (Stream.Listener)new Stream.Listener.Adapter(){

            public void onReset(Stream stream, ResetFrame frame) {
            }
        });
        Stream stream = (Stream)streamCF.get();
        stream.reset(new ResetFrame(stream.getId(), ErrorCode.CANCEL_STREAM_ERROR.code), Callback.NOOP);
    }

    public void push() throws Exception {
        HTTP2Client http2Client = new HTTP2Client();
        http2Client.start();
        InetSocketAddress serverAddress = new InetSocketAddress("localhost", 8080);
        CompletableFuture sessionCF = http2Client.connect((SocketAddress)serverAddress, (Session.Listener)new Session.Listener.Adapter());
        Session session = (Session)sessionCF.get();
        HttpFields.Mutable requestHeaders = HttpFields.build().put(HttpHeader.USER_AGENT, "Jetty HTTP2Client {version}");
        MetaData.Request request = new MetaData.Request("GET", (HttpURI)HttpURI.from((String)"http://localhost:8080/path"), HttpVersion.HTTP_2, (HttpFields)requestHeaders);
        HeadersFrame headersFrame = new HeadersFrame((MetaData)request, null, true);
        CompletableFuture streamCF = session.newStream(headersFrame, (Stream.Listener)new Stream.Listener.Adapter(){

            public Stream.Listener onPush(Stream pushedStream, PushPromiseFrame frame) {
                MetaData.Request pushedRequest = frame.getMetaData();
                HttpURI pushedURI = pushedRequest.getURI();
                HttpFields pushedRequestHeaders = pushedRequest.getFields();
                Stream primaryStream = pushedStream.getSession().getStream(frame.getStreamId());
                return new Stream.Listener.Adapter(){

                    public void onHeaders(Stream stream, HeadersFrame frame) {
                        MetaData metaData = frame.getMetaData();
                        if (metaData.isResponse()) {
                            HttpFields httpFields = metaData.getFields();
                        }
                    }

                    public void onData(Stream stream, DataFrame frame, Callback callback) {
                        ByteBuffer buffer = frame.getData();
                        callback.succeeded();
                    }
                };
            }
        });
    }

    public void pushReset() throws Exception {
        HTTP2Client http2Client = new HTTP2Client();
        http2Client.start();
        InetSocketAddress serverAddress = new InetSocketAddress("localhost", 8080);
        CompletableFuture sessionCF = http2Client.connect((SocketAddress)serverAddress, (Session.Listener)new Session.Listener.Adapter());
        Session session = (Session)sessionCF.get();
        HttpFields.Mutable requestHeaders = HttpFields.build().put(HttpHeader.USER_AGENT, "Jetty HTTP2Client {version}");
        MetaData.Request request = new MetaData.Request("GET", (HttpURI)HttpURI.from((String)"http://localhost:8080/path"), HttpVersion.HTTP_2, (HttpFields)requestHeaders);
        HeadersFrame headersFrame = new HeadersFrame((MetaData)request, null, true);
        CompletableFuture streamCF = session.newStream(headersFrame, (Stream.Listener)new Stream.Listener.Adapter(){

            public Stream.Listener onPush(Stream pushedStream, PushPromiseFrame frame) {
                pushedStream.reset(new ResetFrame(pushedStream.getId(), ErrorCode.CANCEL_STREAM_ERROR.code), Callback.NOOP);
                return null;
            }
        });
    }
}

