/*
 * Decompiled with CFR 0.152.
 */
package embedded.client;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.HashMap;
import java.util.concurrent.Executor;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.SelectorManager;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;

public class ClientConnectorDocSnippets {
    public void simplest() throws Exception {
        ClientConnector clientConnector = new ClientConnector();
        clientConnector.start();
    }

    public void typical() throws Exception {
        SslContextFactory.Client sslContextFactory = new SslContextFactory.Client();
        sslContextFactory.addExcludeProtocols(new String[]{"TLSv1", "TLSv1.1"});
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setName("client");
        ClientConnector clientConnector = new ClientConnector();
        clientConnector.setSslContextFactory(sslContextFactory);
        clientConnector.setExecutor((Executor)threadPool);
        clientConnector.start();
    }

    public void advanced() throws Exception {
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setName("client");
        ScheduledExecutorScheduler scheduler = new ScheduledExecutorScheduler("scheduler-client", false);
        class CustomClientConnector
        extends ClientConnector {
            CustomClientConnector() {
            }

            protected SelectorManager newSelectorManager() {
                return new ClientConnector.ClientSelectorManager(this.getExecutor(), this.getScheduler(), this.getSelectors()){

                    protected void endPointOpened(EndPoint endpoint) {
                        System.getLogger("endpoint").log(System.Logger.Level.INFO, "opened %s", endpoint);
                    }

                    protected void endPointClosed(EndPoint endpoint) {
                        System.getLogger("endpoint").log(System.Logger.Level.INFO, "closed %s", endpoint);
                    }
                };
            }
        }
        CustomClientConnector clientConnector = new CustomClientConnector();
        clientConnector.setExecutor((Executor)threadPool);
        clientConnector.setScheduler((Scheduler)scheduler);
        clientConnector.start();
    }

    public void connect() throws Exception {
        ClientConnector clientConnector = new ClientConnector();
        clientConnector.start();
        String host = "wikipedia.org";
        int port = 80;
        InetSocketAddress address = new InetSocketAddress(host, port);
        ClientConnectionFactory connectionFactory = (endPoint, context) -> {
            System.getLogger("connection").log(System.Logger.Level.INFO, "Creating connection for {0}", endPoint);
            class CustomHTTPConnection
            extends AbstractConnection {
                public CustomHTTPConnection(EndPoint endPoint, Executor executor) {
                    super(endPoint, executor);
                }

                public void onOpen() {
                    super.onOpen();
                }

                public void onFillable() {
                }
            }
            return new CustomHTTPConnection(endPoint, clientConnector.getExecutor());
        };
        HashMap<String, ClientConnectionFactory> context2 = new HashMap<String, ClientConnectionFactory>();
        context2.put("org.eclipse.jetty.client.connector.clientConnectionFactory", connectionFactory);
        clientConnector.connect((SocketAddress)address, context2);
    }

    public static void main(String[] args) throws Exception {
        new ClientConnectorDocSnippets().connect();
    }
}

