/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.deploy;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.jetty.deploy.ContextHandlerFactory;
import org.eclipse.jetty.deploy.Deployer;
import org.eclipse.jetty.deploy.StandardContextHandlerFactory;
import org.eclipse.jetty.deploy.StandardDeployer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.ExceptionUtil;
import org.eclipse.jetty.util.FileID;
import org.eclipse.jetty.util.Scanner;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.DumpableCollection;
import org.eclipse.jetty.util.component.DumpableMap;
import org.eclipse.jetty.util.component.Environment;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.resource.PathCollators;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject(value="Provider for dynamic deployment of contexts (and webapps) based on presence in directory")
public class DeploymentScanner
extends ContainerLifeCycle
implements Scanner.BulkListener {
    private static final Logger LOG = LoggerFactory.getLogger(DeploymentScanner.class);
    private static final String ATTRIBUTE_PREFIX = "jetty.deploy.attribute.";
    private final Server server;
    private final FilenameFilter filenameFilter;
    private final List<Path> webappDirs = new CopyOnWriteArrayList<Path>();
    private final ContextHandlerFactory contextHandlerFactory;
    private final Map<String, PathsApp> scannedApps = new HashMap<String, PathsApp>();
    private final Map<String, Attributes> environmentAttributesMap = new HashMap<String, Attributes>();
    private final List<String> enabledEnvironments = new ArrayList<String>();
    private List<String> environmentsOrder = new ArrayList<String>();
    private Deployer deployer;
    private Comparator<DeployAction> actionComparator = new DeployActionComparator();
    private Path environmentsDir;
    private int scanInterval = 0;
    private Scanner scanner;
    private boolean useRealPaths;
    private boolean deferInitialScan = false;

    public DeploymentScanner(@Name(value="server") Server server) {
        this(server, null, null, null);
    }

    public DeploymentScanner(@Name(value="server") Server server, @Name(value="deployer") Deployer deployer) {
        this(server, deployer, null, null);
    }

    public DeploymentScanner(@Name(value="server") Server server, @Name(value="deployer") Deployer deployer, @Name(value="filenameFilter") FilenameFilter filter) {
        this(server, deployer, filter, null);
    }

    public DeploymentScanner(@Name(value="server") Server server, @Name(value="deployer") Deployer deployer, @Name(value="contextHandlerFactory") ContextHandlerFactory contextHandlerFactory) {
        this(server, deployer, null, contextHandlerFactory);
    }

    public DeploymentScanner(@Name(value="server") Server server, @Name(value="deployer") Deployer deployer, @Name(value="filenameFilter") FilenameFilter filter, @Name(value="contextHandlerFactory") ContextHandlerFactory contextHandlerFactory) {
        this.contextHandlerFactory = contextHandlerFactory == null ? new StandardContextHandlerFactory() : contextHandlerFactory;
        this.installBean(this.contextHandlerFactory);
        this.server = Objects.requireNonNull(server);
        this.deployer = deployer == null ? (Deployer)server.getBean(Deployer.class) : deployer;
        this.installBean(deployer);
        this.filenameFilter = Objects.requireNonNullElse(filter, new WebappsPathFilter());
    }

    public void addWebappsDirectory(Path dir) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding webapps directory: {}", (Object)dir);
        }
        if (this.isStarted()) {
            throw new IllegalStateException("Unable to add webapps directory while running");
        }
        this.webappDirs.add(Objects.requireNonNull(dir));
    }

    void addScannerListener(Scanner.Listener listener) {
        this.scanner.addListener(listener);
    }

    public EnvironmentConfig configureEnvironment(String name) {
        Environment environment = Environment.get((String)name);
        if (environment == null) {
            throw new IllegalStateException("Environment [" + name + "] does not exist.");
        }
        this.enableEnvironment(name);
        return new EnvironmentConfig(environment);
    }

    public void dump(Appendable out, String indent) throws IOException {
        Dumpable.dumpObjects((Appendable)out, (String)indent, (Object)((Object)this), (Object[])new Object[]{new DumpableCollection("webappDirs", this.webappDirs), Dumpable.named((String)"environmentsDir", (Object)this.environmentsDir), Dumpable.named((String)"scanInterval", (Object)this.scanInterval), new DumpableCollection("enabledEnvironments", this.enabledEnvironments), Dumpable.named((String)"environmentsOrder", this.environmentsOrder), new DumpableMap("environmentAttributes", this.environmentAttributesMap), Dumpable.named((String)"contextHandlerFactory", (Object)this.contextHandlerFactory), Dumpable.named((String)"deferInitialScan", (Object)this.deferInitialScan), Dumpable.named((String)"useRealPaths", (Object)this.useRealPaths)});
    }

    public Comparator<DeployAction> getActionComparator() {
        return this.actionComparator;
    }

    public void setActionComparator(Comparator<DeployAction> actionComparator) {
        this.actionComparator = actionComparator;
    }

    public List<String> getEnvironmentsOrder() {
        return this.environmentsOrder;
    }

    public void setEnvironmentsOrder(List<String> environmentsOrder) {
        this.environmentsOrder = Objects.requireNonNull(environmentsOrder);
    }

    String getDefaultEnvironmentName() {
        return switch (this.enabledEnvironments.size()) {
            case 0 -> null;
            case 1 -> this.enabledEnvironments.get(0);
            default -> {
                List<String> order = this.getEnvironmentsOrder();
                if (order.isEmpty()) {
                    yield this.enabledEnvironments.get(0);
                }
                for (String name : order) {
                    if (!this.enabledEnvironments.contains(name)) continue;
                    yield name;
                }
                yield null;
            }
        };
    }

    private void enableEnvironment(String name) {
        if (this.enabledEnvironments.contains(name)) {
            throw new IllegalStateException("Environment [" + name + "] is already configured for deploy.");
        }
        this.enabledEnvironments.add(name);
    }

    public Path getEnvironmentsDirectory() {
        return this.environmentsDir;
    }

    public void setEnvironmentsDirectory(Path dir) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Setting Environments directory: {}", (Object)dir);
        }
        if (this.isStarted()) {
            throw new IllegalStateException("Unable to add environments directory while running");
        }
        this.environmentsDir = dir;
    }

    public List<Path> getWebappDirectories() {
        return this.webappDirs;
    }

    public void setWebappDirectories(Collection<Path> directories) {
        if (this.isStarted()) {
            throw new IllegalStateException("Unable to add webapp directories while running");
        }
        this.webappDirs.clear();
        for (Path dir : directories) {
            this.addWebappsDirectory(dir);
        }
    }

    @ManagedAttribute(value="scanning interval to detect changes which need reloaded")
    public int getScanInterval() {
        return this.scanInterval;
    }

    public void setScanInterval(int scanInterval) {
        this.scanInterval = scanInterval;
    }

    public boolean isDeferInitialScan() {
        return this.deferInitialScan;
    }

    public void setDeferInitialScan(boolean defer) {
        this.deferInitialScan = defer;
    }

    public boolean isUseRealPaths() {
        return this.useRealPaths;
    }

    public void setUseRealPaths(boolean useRealPaths) {
        this.useRealPaths = useRealPaths;
    }

    public void pathsChanged(Map<Path, Scanner.Notification> changeSet) {
        Objects.requireNonNull(changeSet);
        if (LOG.isDebugEnabled()) {
            LOG.debug("pathsChanged: {}", (Object)changeSet.entrySet().stream().map(e -> String.format("%s|%s", e.getKey(), e.getValue())).collect(Collectors.joining(", ", "[", "]")));
        }
        HashSet<String> changedBaseNames = new HashSet<String>();
        HashSet<String> changedEnvironments = new HashSet<String>();
        for (Map.Entry<Path, Scanner.Notification> entry : changeSet.entrySet()) {
            Path path = entry.getKey();
            PathsApp.State state = switch (entry.getValue()) {
                default -> throw new IncompatibleClassChangeError();
                case Scanner.Notification.ADDED -> PathsApp.State.ADDED;
                case Scanner.Notification.CHANGED -> PathsApp.State.CHANGED;
                case Scanner.Notification.REMOVED -> PathsApp.State.REMOVED;
            };
            String basename = FileID.getBasename((Path)path).toLowerCase();
            if (Files.isDirectory(path, new LinkOption[0]) && FileID.isExtension((Path)path, (String[])new String[]{"d"})) {
                basename = basename.substring(0, basename.length() - 2);
            }
            if (this.isWebappsPath(path)) {
                changedBaseNames.add(basename);
                PathsApp app = this.scannedApps.computeIfAbsent(basename, PathsApp::new);
                app.putPath(path, state);
                continue;
            }
            if (!this.isEnvironmentConfigPath(path)) continue;
            String envName = null;
            for (Environment environment : Environment.getAll()) {
                String name = environment.getName();
                if (!basename.startsWith(name)) continue;
                envName = name;
            }
            if (StringUtil.isBlank(envName)) {
                LOG.warn("Unable to determine Environment for file: {}", (Object)path);
                continue;
            }
            changedEnvironments.add(envName);
        }
        List<PathsApp> changedApps = changedBaseNames.stream().map(this::findApp).collect(Collectors.toList());
        if (!changedEnvironments.isEmpty()) {
            for (String changedEnvName : changedEnvironments) {
                for (PathsApp app : this.scannedApps.values()) {
                    if (changedBaseNames.contains(app.getName()) || !changedEnvName.equalsIgnoreCase(app.getEnvironmentName())) continue;
                    if (app.getState() == PathsApp.State.UNCHANGED) {
                        app.setState(PathsApp.State.CHANGED);
                    }
                    changedApps.add(app);
                    changedBaseNames.add(app.getName());
                }
                this.environmentAttributesMap.remove(changedEnvName);
                try {
                    Attributes envAttributes = this.loadEnvironmentAttributes(changedEnvName);
                    this.environmentAttributesMap.put(changedEnvName, envAttributes);
                }
                catch (IOException e2) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Unable to load environment properties for environment [{}]", (Object)changedEnvName, (Object)e2);
                }
            }
        } else {
            Environment.getAll().forEach(env -> this.environmentAttributesMap.put(env.getName(), (Attributes)env));
        }
        List<DeployAction> list = this.buildActionList(changedApps);
        this.performActions(list);
    }

    void resetAppState(String name) {
        PathsApp app = this.findApp(name);
        if (app == null) {
            return;
        }
        app.resetStates();
    }

    @ManagedOperation(value="Scan the webapps directories", impact="ACTION")
    public void scan() {
        LOG.info("Performing scan of webapps directories: {}", (Object)this.webappDirs.stream().map(Path::toUri).map(URI::toASCIIString).collect(Collectors.joining(", ", "[", "]")));
        this.scanner.nudge();
    }

    private List<DeployAction> buildActionList(List<PathsApp> changedApps) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("buildActionList: {}", changedApps);
        }
        ArrayList<DeployAction> actions = new ArrayList<DeployAction>();
        for (PathsApp app : changedApps) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("changed app: {}", (Object)app);
            }
            switch (app.getState().ordinal()) {
                case 1: {
                    this.startTracking(app);
                    actions.add(new DeployAction(DeployAction.Type.DEPLOY, app.getName()));
                    break;
                }
                case 2: {
                    actions.add(new DeployAction(DeployAction.Type.REDEPLOY, app.getName()));
                    break;
                }
                case 3: {
                    actions.add(new DeployAction(DeployAction.Type.UNDEPLOY, app.getName()));
                }
            }
        }
        return this.sortActions(actions);
    }

    protected void doStart() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} doStart()", (Object)this);
        }
        if (this.deployer == null) {
            Collection handlers;
            this.deployer = (Deployer)this.server.getBean(Deployer.class);
            if (this.deployer == null && (handlers = this.server.getContainedBeans(ContextHandlerCollection.class)).size() == 1) {
                this.deployer = new StandardDeployer((ContextHandlerCollection)handlers.iterator().next());
                this.addBean(this.deployer, true);
                LifeCycle.start((Object)this.deployer);
            }
            if (this.deployer == null) {
                throw new IllegalStateException("No deployer available");
            }
        }
        if (this.webappDirs.isEmpty()) {
            throw new IllegalStateException("No webapps dir specified");
        }
        LOG.info("Deployment monitoring of {} at intervals {}s {}", new Object[]{this.webappDirs, this.getScanInterval(), this.getScanInterval() <= 0 ? "(hot-redeploy disabled)" : ""});
        Predicate<Path> validDir = path -> {
            if (!Files.exists(path, new LinkOption[0])) {
                LOG.warn("Does not exist: {}", path);
                return false;
            }
            if (!Files.isDirectory(path, new LinkOption[0])) {
                LOG.warn("Is not a directory: {}", path);
                return false;
            }
            return true;
        };
        final ArrayList<Path> dirs = new ArrayList<Path>();
        for (Path dir : this.webappDirs) {
            if (!validDir.test(dir)) continue;
            dirs.add(dir);
        }
        if (this.environmentsDir != null && validDir.test(this.environmentsDir)) {
            dirs.add(this.environmentsDir);
        }
        this.scanner = new Scanner(null, this.useRealPaths);
        this.scanner.setScanDirs(dirs);
        this.scanner.setScanInterval(this.scanInterval);
        this.scanner.setFilenameFilter(this.filenameFilter);
        this.scanner.setReportDirs(true);
        this.scanner.setScanDepth(1);
        this.scanner.addListener((Scanner.Listener)this);
        this.scanner.setReportExistingFilesOnStartup(true);
        this.scanner.setAutoStartScanning(!this.deferInitialScan);
        this.addBean(this.scanner);
        if (this.isDeferInitialScan()) {
            if (this.server == null) {
                throw new IllegalStateException("Cannot defer initial scan with a null Server");
            }
            this.server.addEventListener((EventListener)new LifeCycle.Listener(){
                final /* synthetic */ DeploymentScanner this$0;
                {
                    this.this$0 = this$0;
                }

                public void lifeCycleStarted(LifeCycle event) {
                    if (event instanceof Server) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Triggering Deferred Scan of {}", (Object)dirs);
                        }
                        this.this$0.scanner.startScanning();
                    }
                }
            });
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.scanner != null) {
            this.removeBean(this.scanner);
            this.scanner.removeListener((Scanner.Listener)this);
            this.scanner = null;
        }
    }

    PathsApp findApp(String name) {
        return this.scannedApps.get(name);
    }

    private boolean isEnvironmentConfigPath(Path path) {
        if (this.environmentsDir == null) {
            return false;
        }
        if (!this.isSameDir(this.environmentsDir, path.getParent())) {
            return false;
        }
        return FileID.isExtension((Path)path, (String[])new String[]{"xml", "properties"});
    }

    private boolean isWebappsPath(Path path) {
        Path parentDir = path.getParent();
        for (Path dir : this.webappDirs) {
            if (!this.isSameDir(dir, parentDir)) continue;
            return true;
        }
        return false;
    }

    private boolean isSameDir(Path dirA, Path dirB) {
        try {
            if (!Files.exists(dirA, new LinkOption[0]) || !Files.exists(dirB, new LinkOption[0])) {
                return false;
            }
            return Files.isSameFile(dirA, dirB);
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ignoring: Unable to use Files.isSameFile({}, {})", new Object[]{dirA, dirB, e});
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void performActions(List<DeployAction> actions) {
        removedApps = new HashSet<PathsApp>();
lbl2:
        // 7 sources

        block10: for (DeployAction step : actions) {
            app = this.findApp(step.name());
            if (app == null) {
                throw new IllegalStateException("Unable to find app [" + step.name() + "]");
            }
            try {
                switch (step.type().ordinal()) {
                    case 0: {
                        removedApps.add(app);
                        this.deployer.undeploy(app.getContextHandler());
                        ** break;
                    }
                    case 2: {
                        removedApps.remove(app);
                        app.loadProperties();
                        envName = app.getEnvironmentName();
                        if (StringUtil.isBlank((String)envName)) {
                            envName = this.getDefaultEnvironmentName();
                            if (envName == null) {
                                throw new IllegalStateException("Unable to deploy %s to unknown environment".formatted(new Object[]{app.getName()}));
                            }
                            if (DeploymentScanner.LOG.isDebugEnabled()) {
                                DeploymentScanner.LOG.debug("Using default environment {} to deploy app {}", (Object)envName, (Object)app.getName());
                            }
                        }
                        if ((env = Environment.get((String)envName)) == null || !this.enabledEnvironments.contains(envName)) {
                            throw new IllegalStateException("Unable to deploy %s to environment %s. Available environments: %s".formatted(new Object[]{app.name, envName, this.enabledEnvironments}));
                        }
                        envAttributes = this.environmentAttributesMap.get(envName);
                        deployAttributes = envAttributes == null ? app.getAttributes() : new Attributes.Layer(envAttributes, app.getAttributes());
                        mainPath = app.getMainPath();
                        if (mainPath == null) {
                            throw new IllegalStateException("Unable to create ContextHandler for app with no main path defined: " + String.valueOf(app));
                        }
                        contextHandler = this.contextHandlerFactory.newContextHandler(this.server, env, mainPath, app.getPaths().keySet(), deployAttributes);
                        app.setContextHandler(contextHandler);
                        this.startTracking(app);
                        if (DeploymentScanner.LOG.isDebugEnabled()) {
                            DeploymentScanner.LOG.debug("Deploying {} to environment {}", (Object)app.getName(), (Object)envName);
                        }
                        this.deployer.deploy(app.getContextHandler());
                        ** break;
                    }
                    case 1: {
                        oldContextHandler = app.getContextHandler();
                        app.loadProperties();
                        envName = app.getEnvironmentName();
                        if (StringUtil.isBlank((String)envName)) {
                            envName = this.getDefaultEnvironmentName();
                            if (envName == null) {
                                throw new IllegalStateException("Unable to redeploy %s to unknown environment".formatted(new Object[]{app.getName()}));
                            }
                            if (DeploymentScanner.LOG.isDebugEnabled()) {
                                DeploymentScanner.LOG.debug("Using default environment {} to redeploy app {}", (Object)envName, (Object)app.getName());
                            }
                        }
                        if ((env = Environment.get((String)envName)) == null || !this.enabledEnvironments.contains(envName)) {
                            throw new IllegalStateException("Unable to redeploy %s to environment %s. Available environments: %s".formatted(new Object[]{app.name, envName, this.enabledEnvironments}));
                        }
                        envAttributes = this.environmentAttributesMap.get(envName);
                        deployAttributes = envAttributes == null ? app.getAttributes() : new Attributes.Layer(envAttributes, app.getAttributes());
                        mainPath = app.getMainPath();
                        if (mainPath == null) {
                            throw new IllegalStateException("Unable to create ContextHandler for app with no main path defined: " + String.valueOf(app));
                        }
                        contextHandler = this.contextHandlerFactory.newContextHandler(this.server, env, mainPath, app.getPaths().keySet(), deployAttributes);
                        app.setContextHandler(contextHandler);
                        this.startTracking(app);
                        if (DeploymentScanner.LOG.isDebugEnabled()) {
                            DeploymentScanner.LOG.debug("Redeploying {} to environment {}", (Object)app.getName(), (Object)envName);
                        }
                        this.deployer.redeploy(oldContextHandler, app.getContextHandler());
                        continue block10;
                    }
                    ** default:
lbl63:
                    // 1 sources

                    continue block10;
                }
            }
            catch (Throwable t) {
                DeploymentScanner.LOG.warn("Failed to to perform action {} on {}", new Object[]{step.type(), app, t});
                ExceptionUtil.ifExceptionThrowUnchecked((Throwable)t);
            }
            finally {
                app.resetStates();
            }
        }
        for (PathsApp removed : removedApps) {
            this.stopTracking(removed);
        }
    }

    private List<DeployAction> sortActions(List<DeployAction> actions) {
        Comparator<DeployAction> deployActionComparator = this.getActionComparator();
        if (deployActionComparator != null) {
            actions.sort(deployActionComparator);
        }
        return actions;
    }

    private Attributes loadEnvironmentAttributes(String env) throws IOException {
        Environment envAttributes = Environment.get((String)env);
        if (envAttributes == null) {
            LOG.warn("Not an environment: {}", (Object)env);
            return Attributes.NULL;
        }
        Path dir = this.getEnvironmentsDirectory();
        if (dir == null) {
            return envAttributes;
        }
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            LOG.warn("Not an environments directory: {}", (Object)dir);
            return envAttributes;
        }
        ArrayList envPropertyFiles = new ArrayList();
        ArrayList envXmlFiles = new ArrayList();
        try (Stream<Path> paths = Files.list(dir);){
            paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> FileID.isExtension((Path)p, (String[])new String[]{"properties", "xml"})).filter(p -> {
                String name = p.getFileName().toString();
                return name.startsWith(env);
            }).sorted(PathCollators.byName((boolean)true)).forEach(file -> {
                if (FileID.isExtension((Path)file, (String[])new String[]{"properties"})) {
                    envPropertyFiles.add(file);
                } else if (FileID.isExtension((Path)file, (String[])new String[]{"xml"})) {
                    envXmlFiles.add(file);
                }
            });
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Environment property files {}", envPropertyFiles);
            LOG.debug("Environment XML files {}", envXmlFiles);
        }
        Attributes.Layer envLayer = new Attributes.Layer((Attributes)envAttributes);
        envLayer.setAttribute("jetty.deploy.paths.environmentXmls", envXmlFiles);
        for (Path file2 : envPropertyFiles) {
            DeploymentScanner.loadPropertiesIntoAttributes(file2, (Attributes)envLayer);
        }
        return envLayer;
    }

    private static void loadPropertiesIntoAttributes(Path propFile, Attributes attributes) {
        try (InputStream inputStream = Files.newInputStream(propFile, new OpenOption[0]);){
            Properties props = new Properties();
            props.load(inputStream);
            for (String name : props.stringPropertyNames()) {
                String value = props.getProperty(name);
                if (name.startsWith(ATTRIBUTE_PREFIX)) {
                    LOG.warn("Deprecated Attribute Key prefix in use: {} (will be stripped, future support not certain)", (Object)name);
                    name = name.substring(ATTRIBUTE_PREFIX.length());
                }
                if (name.startsWith("jetty.deploy.environmentXml.") || name.equals("jetty.deploy.environmentXml")) {
                    LOG.warn("Deprecated Attribute Key prefix in use: {} (Key ignored, use ${jetty.base}/environments/*.xml instead)", (Object)name);
                    continue;
                }
                attributes.setAttribute(name, (Object)value);
            }
        }
        catch (IOException e) {
            LOG.warn("Unable to read properties file: {}", (Object)propFile, (Object)e);
        }
    }

    private void startTracking(PathsApp app) {
        this.scannedApps.put(app.getName(), app);
    }

    private void stopTracking(PathsApp app) {
        this.scannedApps.remove(app.getName());
    }

    public String toString() {
        return String.format("%s@%x[webappsDirs=%s]", ((Object)((Object)this)).getClass(), ((Object)((Object)this)).hashCode(), this.webappDirs);
    }

    static class DeployActionComparator
    implements Comparator<DeployAction> {
        private final Comparator<DeployAction> typeComparator = Comparator.comparing(DeployAction::type);
        private final Comparator<DeployAction> basenameComparator = Comparator.comparing(DeployAction::name);

        @Override
        public int compare(DeployAction o1, DeployAction o2) {
            int diff = this.typeComparator.compare(o1, o2);
            if (diff != 0) {
                return diff;
            }
            return switch (o1.type().ordinal()) {
                default -> throw new IncompatibleClassChangeError();
                case 0 -> this.basenameComparator.compare(o2, o1);
                case 1, 2 -> this.basenameComparator.compare(o1, o2);
            };
        }
    }

    private static class WebappsPathFilter
    implements FilenameFilter {
        private WebappsPathFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            Path path;
            block6: {
                if (dir == null || !dir.canRead()) {
                    return false;
                }
                path = dir.toPath().resolve(name);
                try {
                    if (name.startsWith(".")) {
                        return false;
                    }
                    if (Files.isHidden(path)) {
                        return false;
                    }
                }
                catch (IOException x) {
                    if (!LOG.isTraceEnabled()) break block6;
                    LOG.trace("IGNORED error from isHidden check", (Throwable)x);
                }
            }
            if (Files.isRegularFile(path, new LinkOption[0]) && FileID.isExtension((String)name, (String[])new String[]{"jar", "war", "xml", "properties"})) {
                return true;
            }
            return Files.isDirectory(path, new LinkOption[0]);
        }
    }

    public static class EnvironmentConfig {
        private final Environment _environment;

        private EnvironmentConfig(Environment environment) {
            this._environment = environment;
        }

        public void loadProperties(Path path) throws IOException {
            Properties props = new Properties();
            try (InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);){
                props.load(inputStream);
                props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> this._environment.setAttribute((String)key, value)));
            }
        }

        public void loadPropertiesFromPathName(String pathName) throws IOException {
            this.loadProperties(Path.of(pathName, new String[0]));
        }

        public void setConfigurationClasses(String configurations) {
            this.setConfigurationClasses(StringUtil.isBlank((String)configurations) ? null : configurations.split(","));
        }

        public void setConfigurationClasses(String[] configurations) {
            if (configurations == null) {
                this._environment.removeAttribute("jetty.deploy.configurationClasses");
            } else {
                this._environment.setAttribute("jetty.deploy.configurationClasses", (Object)configurations);
            }
        }

        public void setContainerScanJarPattern(String pattern) {
            this._environment.setAttribute("jetty.deploy.containerScanJarPattern", (Object)pattern);
        }

        public void setDefaultContextHandlerClass(Class<? extends ContextHandler> contextHandlerClass) {
            this.setDefaultContextHandlerClassName(contextHandlerClass.getName());
        }

        public void setDefaultContextHandlerClassName(String className) {
            this._environment.setAttribute("jetty.deploy.defaultContextHandlerClass", (Object)className);
        }

        public void setDefaultsDescriptor(String defaultsDescriptor) {
            this._environment.setAttribute("jetty.deploy.defaultsDescriptor", (Object)defaultsDescriptor);
        }

        public void setExtractWars(boolean extractWars) {
            this._environment.setAttribute("jetty.deploy.extractWars", (Object)extractWars);
        }

        public void setParentLoaderPriority(boolean parentLoaderPriority) {
            this._environment.setAttribute("jetty.deploy.parentLoaderPriority", (Object)parentLoaderPriority);
        }

        public void setServletContainerInitializerExclusionPattern(String pattern) {
            this._environment.setAttribute("jetty.deploy.servletContainerInitializerExclusionPattern", (Object)pattern);
        }

        public void setServletContainerInitializerOrder(String order) {
            this._environment.setAttribute("jetty.deploy.servletContainerInitializerOrder", (Object)order);
        }

        public void setWebInfScanJarPattern(String pattern) {
            this._environment.setAttribute("jetty.deploy.webInfScanJarPattern", (Object)pattern);
        }
    }

    static class PathsApp {
        private static final Logger LOG = LoggerFactory.getLogger(PathsApp.class);
        private final String name;
        private final Map<Path, State> paths = new HashMap<Path, State>();
        private final Attributes attributes = new Attributes.Mapped();
        private Path mainPath;
        private State state;
        private ContextHandler contextHandler;

        public PathsApp(String name) {
            this.name = name;
            this.state = this.calcState();
        }

        private static String asStringList(Collection<Path> paths) {
            return paths.stream().sorted(PathCollators.byName((boolean)true)).map(Path::toString).collect(Collectors.joining(", ", "[", "]"));
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PathsApp that = (PathsApp)o;
            return Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hashCode(this.name);
        }

        public Attributes getAttributes() {
            return this.attributes;
        }

        public ContextHandler getContextHandler() {
            return this.contextHandler;
        }

        public void setContextHandler(ContextHandler contextHandler) {
            this.contextHandler = contextHandler;
        }

        public String getEnvironmentName() {
            Object obj = this.attributes.getAttribute("environment");
            if (obj instanceof String) {
                String str = (String)obj;
                return str;
            }
            if (obj instanceof Environment) {
                Environment env = (Environment)obj;
                return env.getName();
            }
            return null;
        }

        public Path getMainPath() {
            return this.mainPath;
        }

        public void setMainPath(Path mainPath) {
            this.mainPath = mainPath;
        }

        private Path filterPath(List<Path> paths, String type, Predicate<Path> predicate) {
            List<Path> hits = paths.stream().filter(predicate).toList();
            if (hits.size() == 1) {
                return hits.get(0);
            }
            if (hits.size() > 1) {
                throw new IllegalStateException("More than 1 " + type + " for deployable " + PathsApp.asStringList(hits));
            }
            return null;
        }

        private Path calcMainPath() {
            List<Path> livePaths = this.paths.entrySet().stream().filter(e -> e.getValue() != State.REMOVED).map(Map.Entry::getKey).sorted(PathCollators.byName((boolean)true)).toList();
            if (livePaths.isEmpty()) {
                return null;
            }
            Path xml = this.filterPath(livePaths, "XML", FileID::isXml);
            if (xml != null) {
                return xml;
            }
            Path war = this.filterPath(livePaths, "WAR", FileID::isWebArchive);
            if (war != null) {
                return war;
            }
            Path jar = this.filterPath(livePaths, "JAR", FileID::isJavaArchive);
            if (jar != null) {
                return jar;
            }
            Path zip = this.filterPath(livePaths, "ZIP", p -> FileID.isExtension((Path)p, (String[])new String[]{"zip"}));
            if (zip != null) {
                return zip;
            }
            Path dir = this.filterPath(livePaths, "Directory", PathsApp::isDeployableDirectory);
            if (dir != null) {
                return dir;
            }
            Path propertyFile = this.filterPath(livePaths, "Property File", p -> FileID.isExtension((Path)p, (String[])new String[]{"properties"}));
            if (propertyFile != null) {
                return propertyFile;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unable to determine main deployable for {}", (Object)this);
            }
            return null;
        }

        private static boolean isDeployableDirectory(Path p) {
            if (p == null) {
                return false;
            }
            if (Files.isDirectory(p, new LinkOption[0])) {
                return !FileID.isExtension((URI)p.toUri(), (String[])new String[]{"d"});
            }
            return false;
        }

        public String getName() {
            return this.name;
        }

        public Map<Path, State> getPaths() {
            return Collections.unmodifiableMap(this.paths);
        }

        public State getState() {
            return this.state;
        }

        public void setState(State state) {
            this.state = state;
        }

        public void loadProperties() {
            String propFilename = String.format("%s.properties", this.getName());
            List<Path> propFiles = this.paths.keySet().stream().filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.getFileName().toString().equalsIgnoreCase(propFilename)).sorted(PathCollators.byName((boolean)true)).toList();
            if (propFiles.isEmpty()) {
                return;
            }
            if (propFiles.size() > 1) {
                LOG.warn("Multiple matching files with name [{}]: {}", (Object)propFilename, (Object)PathsApp.asStringList(propFiles));
            }
            for (Path propFile : propFiles) {
                DeploymentScanner.loadPropertiesIntoAttributes(propFile, this.getAttributes());
            }
            Object envObj = this.getAttributes().getAttribute("environment");
            if (envObj != null) {
                if (envObj instanceof String) {
                    Environment env;
                    String environmentName = (String)envObj;
                    if (StringUtil.isNotBlank((String)environmentName) && (env = Environment.get((String)environmentName)) == null) {
                        LOG.warn("Environment not found {}", (Object)environmentName);
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug("Unable to use attribute {} as type {}", (Object)"environment", (Object)envObj.getClass().getName());
                }
            }
        }

        public void putPath(Path path, State state) {
            this.paths.put(path, state);
            this.setState(this.calcState());
            this.setMainPath(this.calcMainPath());
        }

        public void resetStates() {
            List<Path> removedPaths = this.paths.entrySet().stream().filter(e -> e.getValue() == State.REMOVED).map(Map.Entry::getKey).toList();
            for (Path removedPath : removedPaths) {
                this.paths.remove(removedPath);
            }
            this.paths.replaceAll((p, v) -> State.UNCHANGED);
            this.state = this.calcState();
        }

        private State calcState() {
            if (this.paths.isEmpty()) {
                return State.REMOVED;
            }
            State ret = null;
            for (State pathState : this.paths.values()) {
                switch (pathState.ordinal()) {
                    case 0: {
                        if (ret == null) {
                            ret = State.UNCHANGED;
                            break;
                        }
                        if (ret == State.UNCHANGED) break;
                        ret = State.CHANGED;
                        break;
                    }
                    case 1: {
                        if (ret == null) {
                            ret = State.ADDED;
                            break;
                        }
                        if (ret == State.ADDED) break;
                        ret = State.CHANGED;
                        break;
                    }
                    case 2: {
                        ret = State.CHANGED;
                        break;
                    }
                    case 3: {
                        if (ret == null) {
                            ret = State.REMOVED;
                            break;
                        }
                        if (ret == State.REMOVED) break;
                        ret = State.CHANGED;
                    }
                }
            }
            return ret != null ? ret : State.UNCHANGED;
        }

        public String toString() {
            StringBuilder str = new StringBuilder("%s@%x".formatted(TypeUtil.toShortName(this.getClass()), this.hashCode()));
            str.append("[").append(this.name);
            str.append("|").append((Object)this.getState());
            str.append(", env=").append(this.getEnvironmentName());
            str.append(", mainPath=").append(this.getMainPath());
            str.append(", paths=");
            str.append(this.paths.entrySet().stream().map(e -> String.format("%s|%s", e.getKey(), e.getValue())).collect(Collectors.joining(", ", "[", "]")));
            str.append(", contextHandler=");
            if (this.contextHandler == null) {
                str.append("<unset>");
            } else {
                str.append(this.contextHandler);
            }
            str.append("]");
            return str.toString();
        }

        public static enum State {
            UNCHANGED,
            ADDED,
            CHANGED,
            REMOVED;

        }
    }

    public record DeployAction(Type type, String name) {

        public static enum Type {
            UNDEPLOY,
            REDEPLOY,
            DEPLOY;

        }
    }
}

