/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.http;

import java.io.EOFException;
import java.nio.ByteBuffer;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpReceiver;
import org.eclipse.jetty.client.HttpResponse;
import org.eclipse.jetty.client.HttpResponseException;
import org.eclipse.jetty.client.http.HttpChannelOverHTTP;
import org.eclipse.jetty.client.http.HttpConnectionOverHTTP;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.CompletableCallback;

public class HttpReceiverOverHTTP
extends HttpReceiver
implements HttpParser.ResponseHandler {
    private final HttpParser parser = new HttpParser((HttpParser.ResponseHandler)this);
    private ByteBuffer buffer;
    private boolean shutdown;

    public HttpReceiverOverHTTP(HttpChannelOverHTTP channel) {
        super(channel);
    }

    @Override
    public HttpChannelOverHTTP getHttpChannel() {
        return (HttpChannelOverHTTP)super.getHttpChannel();
    }

    private HttpConnectionOverHTTP getHttpConnection() {
        return this.getHttpChannel().getHttpConnection();
    }

    protected ByteBuffer getResponseBuffer() {
        return this.buffer;
    }

    public void receive() {
        if (this.buffer == null) {
            this.acquireBuffer();
        }
        this.process();
    }

    private void acquireBuffer() {
        HttpClient client = this.getHttpDestination().getHttpClient();
        ByteBufferPool bufferPool = client.getByteBufferPool();
        this.buffer = bufferPool.acquire(client.getResponseBufferSize(), true);
    }

    private void releaseBuffer() {
        if (this.buffer == null) {
            throw new IllegalStateException();
        }
        if (BufferUtil.hasContent((ByteBuffer)this.buffer)) {
            throw new IllegalStateException();
        }
        HttpClient client = this.getHttpDestination().getHttpClient();
        ByteBufferPool bufferPool = client.getByteBufferPool();
        bufferPool.release(this.buffer);
        this.buffer = null;
    }

    protected ByteBuffer onUpgradeFrom() {
        if (BufferUtil.hasContent((ByteBuffer)this.buffer)) {
            ByteBuffer upgradeBuffer = ByteBuffer.allocate(this.buffer.remaining());
            upgradeBuffer.put(this.buffer);
            return upgradeBuffer;
        }
        return null;
    }

    private void process() {
        try {
            int read;
            block10: {
                HttpConnectionOverHTTP connection = this.getHttpConnection();
                EndPoint endPoint = connection.getEndPoint();
                do {
                    boolean upgraded;
                    boolean bl = upgraded = connection != endPoint.getConnection();
                    if (connection.isClosed() || upgraded) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("{} {}", new Object[]{connection, upgraded ? "upgraded" : "closed"});
                        }
                        this.releaseBuffer();
                        return;
                    }
                    if (this.parse()) {
                        return;
                    }
                    read = endPoint.fill(this.buffer);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Read {} bytes {} from {}", new Object[]{read, BufferUtil.toDetailString((ByteBuffer)this.buffer), endPoint});
                    }
                    if (read <= 0) break block10;
                } while (!this.parse());
                return;
            }
            if (read == 0) {
                this.releaseBuffer();
                this.fillInterested();
                return;
            }
            this.releaseBuffer();
            this.shutdown();
            return;
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(x);
            }
            BufferUtil.clear((ByteBuffer)this.buffer);
            if (this.buffer != null) {
                this.releaseBuffer();
            }
            this.failAndClose(x);
            return;
        }
    }

    private boolean parse() {
        boolean handle;
        do {
            handle = this.parser.parseNext(this.buffer);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Parsed {}, remaining {} {}", new Object[]{handle, this.buffer.remaining(), this.parser});
        } while (!handle && this.buffer.hasRemaining());
        return handle;
    }

    protected void fillInterested() {
        this.getHttpConnection().fillInterested();
    }

    private void shutdown() {
        this.shutdown = true;
        this.parser.atEOF();
        this.parser.parseNext(BufferUtil.EMPTY_BUFFER);
    }

    protected boolean isShutdown() {
        return this.shutdown;
    }

    public int getHeaderCacheSize() {
        return 256;
    }

    public boolean startResponse(HttpVersion version, int status, String reason) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return false;
        }
        String method = exchange.getRequest().getMethod();
        this.parser.setHeadResponse(HttpMethod.HEAD.is(method) || HttpMethod.CONNECT.is(method) && status == 200);
        exchange.getResponse().version(version).status(status).reason(reason);
        return !this.responseBegin(exchange);
    }

    public void parsedHeader(HttpField field) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return;
        }
        this.responseHeader(exchange, field);
    }

    public boolean headerComplete() {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return false;
        }
        return !this.responseHeaders(exchange);
    }

    public boolean content(ByteBuffer buffer) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return false;
        }
        CompletableCallback callback = new CompletableCallback(){

            public void resume() {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Content consumed asynchronously, resuming processing", new Object[0]);
                }
                HttpReceiverOverHTTP.this.process();
            }

            public void abort(Throwable x) {
                HttpReceiverOverHTTP.this.failAndClose(x);
            }
        };
        boolean proceed = this.responseContent(exchange, buffer, (Callback)callback);
        boolean async = callback.tryComplete();
        return !proceed || async;
    }

    public boolean messageComplete() {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return false;
        }
        boolean proceed = this.responseSuccess(exchange);
        if (!proceed) {
            return true;
        }
        int status = exchange.getResponse().getStatus();
        if (status == 101) {
            return true;
        }
        return HttpMethod.CONNECT.is(exchange.getRequest().getMethod()) && status == 200;
    }

    public void earlyEOF() {
        HttpExchange exchange = this.getHttpExchange();
        HttpConnectionOverHTTP connection = this.getHttpConnection();
        if (exchange == null) {
            connection.close();
        } else {
            this.failAndClose(new EOFException(String.valueOf(connection)));
        }
    }

    public void badMessage(int status, String reason) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange != null) {
            HttpResponse response = exchange.getResponse();
            response.status(status).reason(reason);
            this.failAndClose(new HttpResponseException("HTTP protocol violation: bad response on " + this.getHttpConnection(), response));
        }
    }

    @Override
    protected void reset() {
        super.reset();
        this.parser.reset();
    }

    @Override
    protected void dispose() {
        super.dispose();
        this.parser.close();
    }

    private void failAndClose(Throwable failure) {
        if (this.responseFailure(failure)) {
            this.getHttpConnection().close(failure);
        }
    }

    @Override
    public String toString() {
        return String.format("%s[%s]", super.toString(), this.parser);
    }
}

