/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.client.ContentDecoder;
import org.eclipse.jetty.client.HttpChannel;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpConversation;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpResponse;
import org.eclipse.jetty.client.ProtocolHandler;
import org.eclipse.jetty.client.ResponseNotifier;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.CountingCallback;
import org.eclipse.jetty.util.component.Destroyable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public abstract class HttpReceiver {
    protected static final Logger LOG = Log.getLogger(HttpReceiver.class);
    private final AtomicReference<ResponseState> responseState = new AtomicReference<ResponseState>(ResponseState.IDLE);
    private final HttpChannel channel;
    private ContentDecoder decoder;
    private Throwable failure;

    protected HttpReceiver(HttpChannel channel) {
        this.channel = channel;
    }

    protected HttpChannel getHttpChannel() {
        return this.channel;
    }

    protected HttpExchange getHttpExchange() {
        return this.channel.getHttpExchange();
    }

    protected HttpDestination getHttpDestination() {
        return this.channel.getHttpDestination();
    }

    protected boolean responseBegin(HttpExchange exchange) {
        if (!this.updateResponseState(ResponseState.IDLE, ResponseState.TRANSIENT)) {
            return false;
        }
        HttpConversation conversation = exchange.getConversation();
        HttpResponse response = exchange.getResponse();
        HttpDestination destination = this.getHttpDestination();
        HttpClient client = destination.getHttpClient();
        ProtocolHandler protocolHandler = client.findProtocolHandler(exchange.getRequest(), response);
        Response.Listener handlerListener = null;
        if (protocolHandler != null) {
            handlerListener = protocolHandler.getResponseListener();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found protocol handler {}", new Object[]{protocolHandler});
            }
        }
        exchange.getConversation().updateResponseListeners(handlerListener);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Response begin {}", new Object[]{response});
        }
        ResponseNotifier notifier = destination.getResponseNotifier();
        notifier.notifyBegin(conversation.getResponseListeners(), (Response)response);
        if (this.updateResponseState(ResponseState.TRANSIENT, ResponseState.BEGIN)) {
            return true;
        }
        this.terminateResponse(exchange);
        return false;
    }

    protected boolean responseHeader(HttpExchange exchange, HttpField field) {
        block6: while (true) {
            ResponseState current = this.responseState.get();
            switch (current) {
                case BEGIN: 
                case HEADER: {
                    if (!this.updateResponseState(current, ResponseState.TRANSIENT)) continue block6;
                    break block6;
                }
                default: {
                    return false;
                }
            }
            break;
        }
        HttpResponse response = exchange.getResponse();
        ResponseNotifier notifier = this.getHttpDestination().getResponseNotifier();
        boolean process = notifier.notifyHeader(exchange.getConversation().getResponseListeners(), (Response)response, field);
        if (process) {
            response.getHeaders().add(field);
            HttpHeader fieldHeader = field.getHeader();
            if (fieldHeader != null) {
                switch (fieldHeader) {
                    case SET_COOKIE: 
                    case SET_COOKIE2: {
                        URI uri = exchange.getRequest().getURI();
                        if (uri == null) break;
                        this.storeCookie(uri, field);
                        break;
                    }
                }
            }
        }
        if (this.updateResponseState(ResponseState.TRANSIENT, ResponseState.HEADER)) {
            return true;
        }
        this.terminateResponse(exchange);
        return false;
    }

    protected void storeCookie(URI uri, HttpField field) {
        block3: {
            try {
                String value = field.getValue();
                if (value != null) {
                    HashMap<String, List<String>> header = new HashMap<String, List<String>>(1);
                    header.put(field.getHeader().asString(), Collections.singletonList(value));
                    this.getHttpDestination().getHttpClient().getCookieManager().put(uri, header);
                }
            }
            catch (IOException x) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug((Throwable)x);
            }
        }
    }

    protected boolean responseHeaders(HttpExchange exchange) {
        block3: while (true) {
            ResponseState current = this.responseState.get();
            switch (current) {
                case BEGIN: 
                case HEADER: {
                    if (!this.updateResponseState(current, ResponseState.TRANSIENT)) continue block3;
                    break block3;
                }
                default: {
                    return false;
                }
            }
            break;
        }
        HttpResponse response = exchange.getResponse();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Response headers {}{}{}", new Object[]{response, System.lineSeparator(), response.getHeaders().toString().trim()});
        }
        ResponseNotifier notifier = this.getHttpDestination().getResponseNotifier();
        notifier.notifyHeaders(exchange.getConversation().getResponseListeners(), (Response)response);
        Enumeration contentEncodings = response.getHeaders().getValues(HttpHeader.CONTENT_ENCODING.asString(), ",");
        if (contentEncodings != null) {
            block4: for (ContentDecoder.Factory factory : this.getHttpDestination().getHttpClient().getContentDecoderFactories()) {
                while (contentEncodings.hasMoreElements()) {
                    if (!factory.getEncoding().equalsIgnoreCase((String)contentEncodings.nextElement())) continue;
                    this.decoder = factory.newContentDecoder();
                    continue block4;
                }
            }
        }
        if (this.updateResponseState(ResponseState.TRANSIENT, ResponseState.HEADERS)) {
            return true;
        }
        this.terminateResponse(exchange);
        return false;
    }

    protected boolean responseContent(HttpExchange exchange, ByteBuffer buffer, Callback callback) {
        block5: while (true) {
            ResponseState current = this.responseState.get();
            switch (current) {
                case HEADERS: 
                case CONTENT: {
                    if (!this.updateResponseState(current, ResponseState.TRANSIENT)) continue block5;
                    break block5;
                }
                default: {
                    callback.failed((Throwable)new IllegalStateException("Invalid response state " + (Object)((Object)current)));
                    return false;
                }
            }
            break;
        }
        HttpResponse response = exchange.getResponse();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Response content {}{}{}", new Object[]{response, System.lineSeparator(), BufferUtil.toDetailString((ByteBuffer)buffer)});
        }
        ResponseNotifier notifier = this.getHttpDestination().getResponseNotifier();
        List<Response.ResponseListener> listeners = exchange.getConversation().getResponseListeners();
        ContentDecoder decoder = this.decoder;
        if (decoder == null) {
            notifier.notifyContent(listeners, (Response)response, buffer, callback);
        } else {
            try {
                ArrayList<ByteBuffer> decodeds = new ArrayList<ByteBuffer>(2);
                while (buffer.hasRemaining()) {
                    ByteBuffer decoded = decoder.decode(buffer);
                    if (!decoded.hasRemaining()) continue;
                    decodeds.add(decoded);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Response content decoded ({}) {}{}{}", new Object[]{decoder, response, System.lineSeparator(), BufferUtil.toDetailString((ByteBuffer)decoded)});
                }
                if (decodeds.isEmpty()) {
                    callback.succeeded();
                } else {
                    int size = decodeds.size();
                    CountingCallback counter = new CountingCallback(callback, size);
                    for (int i = 0; i < size; ++i) {
                        notifier.notifyContent(listeners, (Response)response, (ByteBuffer)decodeds.get(i), (Callback)counter);
                    }
                }
            }
            catch (Throwable x) {
                callback.failed(x);
            }
        }
        if (this.updateResponseState(ResponseState.TRANSIENT, ResponseState.CONTENT)) {
            return true;
        }
        this.terminateResponse(exchange);
        return false;
    }

    protected boolean responseSuccess(HttpExchange exchange) {
        if (!exchange.responseComplete(null)) {
            return false;
        }
        this.responseState.set(ResponseState.IDLE);
        this.reset();
        HttpResponse response = exchange.getResponse();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Response success {}", new Object[]{response});
        }
        List<Response.ResponseListener> listeners = exchange.getConversation().getResponseListeners();
        ResponseNotifier notifier = this.getHttpDestination().getResponseNotifier();
        notifier.notifySuccess(listeners, (Response)response);
        if (exchange.getResponse().getStatus() == 100) {
            return true;
        }
        Result result = exchange.terminateResponse();
        this.terminateResponse(exchange, result);
        return true;
    }

    protected boolean responseFailure(Throwable failure) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return false;
        }
        if (exchange.responseComplete(failure)) {
            return this.abort(exchange, failure);
        }
        return false;
    }

    private void terminateResponse(HttpExchange exchange) {
        Result result = exchange.terminateResponse();
        this.terminateResponse(exchange, result);
    }

    private void terminateResponse(HttpExchange exchange, Result result) {
        HttpResponse response = exchange.getResponse();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Response complete {}", new Object[]{response});
        }
        if (result != null) {
            result = this.channel.exchangeTerminating(exchange, result);
            boolean ordered = this.getHttpDestination().getHttpClient().isStrictEventOrdering();
            if (!ordered) {
                this.channel.exchangeTerminated(exchange, result);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Request/Response {}: {}", new Object[]{this.failure == null ? "succeeded" : "failed", result});
            }
            List<Response.ResponseListener> listeners = exchange.getConversation().getResponseListeners();
            ResponseNotifier notifier = this.getHttpDestination().getResponseNotifier();
            notifier.notifyComplete(listeners, result);
            if (ordered) {
                this.channel.exchangeTerminated(exchange, result);
            }
        }
    }

    protected void reset() {
        HttpReceiver.destroyDecoder(this.decoder);
        this.decoder = null;
    }

    protected void dispose() {
        HttpReceiver.destroyDecoder(this.decoder);
        this.decoder = null;
    }

    private static void destroyDecoder(ContentDecoder decoder) {
        if (decoder instanceof Destroyable) {
            ((Destroyable)decoder).destroy();
        }
    }

    public boolean abort(HttpExchange exchange, Throwable failure) {
        ResponseState current;
        do {
            current = this.responseState.get();
            switch (current) {
                case FAILURE: {
                    return false;
                }
            }
        } while (!this.updateResponseState(current, ResponseState.FAILURE));
        boolean terminate = current != ResponseState.TRANSIENT;
        this.failure = failure;
        this.dispose();
        HttpResponse response = exchange.getResponse();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Response failure {} {} on {}: {}", new Object[]{response, exchange, this.getHttpChannel(), failure});
        }
        List<Response.ResponseListener> listeners = exchange.getConversation().getResponseListeners();
        ResponseNotifier notifier = this.getHttpDestination().getResponseNotifier();
        notifier.notifyFailure(listeners, (Response)response, failure);
        if (terminate) {
            Result result = exchange.terminateResponse();
            this.terminateResponse(exchange, result);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Concurrent failure: response termination skipped, performed by helpers", new Object[0]);
        }
        return true;
    }

    private boolean updateResponseState(ResponseState from, ResponseState to) {
        boolean updated = this.responseState.compareAndSet(from, to);
        if (!updated && LOG.isDebugEnabled()) {
            LOG.debug("State update failed: {} -> {}: {}", new Object[]{from, to, this.responseState.get()});
        }
        return updated;
    }

    public String toString() {
        return String.format("%s@%x(rsp=%s,failure=%s)", this.getClass().getSimpleName(), this.hashCode(), this.responseState, this.failure);
    }

    private static enum ResponseState {
        TRANSIENT,
        IDLE,
        BEGIN,
        HEADER,
        HEADERS,
        CONTENT,
        FAILURE;

    }
}

