/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.annotations;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.annotation.HandlesTypes;
import org.eclipse.jetty.annotations.AbstractDiscoverableAnnotationHandler;
import org.eclipse.jetty.annotations.AnnotationDecorator;
import org.eclipse.jetty.annotations.AnnotationParser;
import org.eclipse.jetty.annotations.ClassInheritanceHandler;
import org.eclipse.jetty.annotations.ClassNameResolver;
import org.eclipse.jetty.annotations.ContainerInitializerAnnotationHandler;
import org.eclipse.jetty.annotations.WebFilterAnnotationHandler;
import org.eclipse.jetty.annotations.WebListenerAnnotationHandler;
import org.eclipse.jetty.annotations.WebServletAnnotationHandler;
import org.eclipse.jetty.plus.annotation.ContainerInitializer;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.AbstractConfiguration;
import org.eclipse.jetty.webapp.DiscoveredAnnotation;
import org.eclipse.jetty.webapp.FragmentDescriptor;
import org.eclipse.jetty.webapp.MetaDataComplete;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.webapp.WebDescriptor;

public class AnnotationConfiguration
extends AbstractConfiguration {
    public static final String CLASS_INHERITANCE_MAP = "org.eclipse.jetty.classInheritanceMap";

    public void preConfigure(WebAppContext context) throws Exception {
    }

    public void configure(WebAppContext context) throws Exception {
        boolean metadataComplete = context.getMetaData().isMetaDataComplete();
        context.addDecorator((ServletContextHandler.Decorator)new AnnotationDecorator(context));
        if (metadataComplete) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)("Metadata-complete==true,  not processing annotations for context " + context));
            }
            return;
        }
        if (Log.isDebugEnabled()) {
            Log.debug((String)"parsing annotations");
        }
        AnnotationParser parser = this.createAnnotationParser();
        parser.registerAnnotationHandler("javax.servlet.annotation.WebServlet", new WebServletAnnotationHandler(context));
        parser.registerAnnotationHandler("javax.servlet.annotation.WebFilter", new WebFilterAnnotationHandler(context));
        parser.registerAnnotationHandler("javax.servlet.annotation.WebListener", new WebListenerAnnotationHandler(context));
        ClassInheritanceHandler classHandler = new ClassInheritanceHandler();
        parser.registerClassHandler(classHandler);
        this.registerServletContainerInitializerAnnotationHandlers(context, parser);
        if (context.getServletContext().getEffectiveMajorVersion() >= 3 || context.isConfigurationDiscovered()) {
            if (Log.isDebugEnabled()) {
                Log.debug((String)("Scanning all classses for annotations: webxmlVersion=" + context.getServletContext().getEffectiveMajorVersion() + " configurationDiscovered=" + context.isConfigurationDiscovered()));
            }
            this.parseContainerPath(context, parser);
            this.parseWebInfClasses(context, parser);
            this.parseWebInfLib(context, parser);
        }
        context.setAttribute(CLASS_INHERITANCE_MAP, (Object)classHandler.getMap());
    }

    protected AnnotationParser createAnnotationParser() {
        return new AnnotationParser();
    }

    public void cloneConfigure(WebAppContext template, WebAppContext context) throws Exception {
        context.addDecorator((ServletContextHandler.Decorator)new AnnotationDecorator(context));
    }

    public void registerServletContainerInitializerAnnotationHandlers(WebAppContext context, AnnotationParser parser) throws Exception {
        ArrayList<ContainerInitializer> initializers = new ArrayList<ContainerInitializer>();
        context.setAttribute("org.eclipse.jetty.containerInitializers", initializers);
        ServiceLoader<ServletContainerInitializer> loadedInitializers = ServiceLoader.load(ServletContainerInitializer.class, context.getClassLoader());
        if (loadedInitializers != null) {
            for (ServletContainerInitializer service : loadedInitializers) {
                if (this.isFromExcludedJar(context, service)) continue;
                HandlesTypes annotation = service.getClass().getAnnotation(HandlesTypes.class);
                ContainerInitializer initializer = new ContainerInitializer();
                initializer.setTarget(service);
                initializers.add(initializer);
                if (annotation != null) {
                    Class[] classes = annotation.value();
                    if (classes != null) {
                        initializer.setInterestedTypes(classes);
                        for (Class c : classes) {
                            if (!c.isAnnotation()) continue;
                            if (Log.isDebugEnabled()) {
                                Log.debug((String)("Registering annotation handler for " + c.getName()));
                            }
                            parser.registerAnnotationHandler(c.getName(), new ContainerInitializerAnnotationHandler(initializer, c));
                        }
                        continue;
                    }
                    if (!Log.isDebugEnabled()) continue;
                    Log.debug((String)("No classes in HandlesTypes on initializer " + service.getClass()));
                    continue;
                }
                if (!Log.isDebugEnabled()) continue;
                Log.debug((String)("No annotation on initializer " + service.getClass()));
            }
        }
    }

    public boolean isFromExcludedJar(WebAppContext context, ServletContainerInitializer service) throws Exception {
        List orderedJars = context.getMetaData().getOrderedWebInfJars();
        if (context.getMetaData().getOrdering() == null) {
            return false;
        }
        if (orderedJars.isEmpty()) {
            return true;
        }
        String loadingJarName = Thread.currentThread().getContextClassLoader().getResource(service.getClass().getName().replace('.', '/') + ".class").toString();
        int i = loadingJarName.indexOf(".jar");
        if (i < 0) {
            return false;
        }
        loadingJarName = (loadingJarName = loadingJarName.substring(0, i + 4)).startsWith("jar:") ? loadingJarName.substring(4) : loadingJarName;
        URI loadingJarURI = Resource.newResource((String)loadingJarName).getURI();
        boolean found = false;
        Iterator itor = orderedJars.iterator();
        while (!found && itor.hasNext()) {
            Resource r = (Resource)itor.next();
            found = r.getURI().equals(loadingJarURI);
        }
        return !found;
    }

    public void parseContainerPath(final WebAppContext context, AnnotationParser parser) throws Exception {
        Log.debug((String)"Scanning container jars");
        this.clearAnnotationList(parser.getAnnotationHandlers());
        ArrayList<URI> containerUris = new ArrayList<URI>();
        for (Resource r : context.getMetaData().getOrderedContainerJars()) {
            URI uri = r.getURI();
            containerUris.add(uri);
        }
        parser.parse(containerUris.toArray(new URI[containerUris.size()]), new ClassNameResolver(){

            @Override
            public boolean isExcluded(String name) {
                if (context.isSystemClass(name)) {
                    return false;
                }
                return context.isServerClass(name);
            }

            @Override
            public boolean shouldOverride(String name) {
                return context.isParentLoaderPriority();
            }
        });
        ArrayList<DiscoveredAnnotation> annotations = new ArrayList<DiscoveredAnnotation>();
        this.gatherAnnotations(annotations, parser.getAnnotationHandlers());
        context.getMetaData().addDiscoveredAnnotations(annotations);
    }

    public void parseWebInfLib(final WebAppContext context, AnnotationParser parser) throws Exception {
        List frags = context.getMetaData().getFragments();
        ArrayList webInfUris = new ArrayList();
        List jars = context.getMetaData().getOrderedWebInfJars();
        if (jars == null || jars.isEmpty()) {
            jars = context.getMetaData().getWebInfJars();
        }
        for (Resource r : jars) {
            this.clearAnnotationList(parser.getAnnotationHandlers());
            URI uri = r.getURI();
            FragmentDescriptor f = this.getFragmentFromJar(r, frags);
            if (f != null && this.isMetaDataComplete((WebDescriptor)f)) continue;
            parser.parse(uri, new ClassNameResolver(){

                @Override
                public boolean isExcluded(String name) {
                    if (context.isSystemClass(name)) {
                        return true;
                    }
                    if (context.isServerClass(name)) {
                        return false;
                    }
                    return false;
                }

                @Override
                public boolean shouldOverride(String name) {
                    return !context.isParentLoaderPriority();
                }
            });
            ArrayList<DiscoveredAnnotation> annotations = new ArrayList<DiscoveredAnnotation>();
            this.gatherAnnotations(annotations, parser.getAnnotationHandlers());
            context.getMetaData().addDiscoveredAnnotations(r, annotations);
        }
    }

    public void parseWebInfClasses(final WebAppContext context, AnnotationParser parser) throws Exception {
        Resource classesDir;
        Log.debug((String)"Scanning classes in WEB-INF/classes");
        if (context.getWebInf() != null && (classesDir = context.getWebInf().addPath("classes/")).exists()) {
            this.clearAnnotationList(parser.getAnnotationHandlers());
            parser.parse(classesDir, new ClassNameResolver(){

                @Override
                public boolean isExcluded(String name) {
                    if (context.isSystemClass(name)) {
                        return true;
                    }
                    if (context.isServerClass(name)) {
                        return false;
                    }
                    return false;
                }

                @Override
                public boolean shouldOverride(String name) {
                    return !context.isParentLoaderPriority();
                }
            });
            ArrayList<DiscoveredAnnotation> annotations = new ArrayList<DiscoveredAnnotation>();
            this.gatherAnnotations(annotations, parser.getAnnotationHandlers());
            context.getMetaData().addDiscoveredAnnotations(annotations);
        }
    }

    public FragmentDescriptor getFragmentFromJar(Resource jar, List<FragmentDescriptor> frags) throws Exception {
        FragmentDescriptor d = null;
        for (FragmentDescriptor frag : frags) {
            Resource fragResource = frag.getResource();
            if (!Resource.isContainedIn((Resource)fragResource, (Resource)jar)) continue;
            d = frag;
            break;
        }
        return d;
    }

    public boolean isMetaDataComplete(WebDescriptor d) {
        return d != null && d.getMetaDataComplete() == MetaDataComplete.True;
    }

    protected void clearAnnotationList(List<AnnotationParser.DiscoverableAnnotationHandler> handlers) {
        if (handlers == null) {
            return;
        }
        for (AnnotationParser.DiscoverableAnnotationHandler h : handlers) {
            if (!(h instanceof AbstractDiscoverableAnnotationHandler)) continue;
            ((AbstractDiscoverableAnnotationHandler)h).resetList();
        }
    }

    protected void gatherAnnotations(List<DiscoveredAnnotation> annotations, List<AnnotationParser.DiscoverableAnnotationHandler> handlers) {
        for (AnnotationParser.DiscoverableAnnotationHandler h : handlers) {
            if (!(h instanceof AbstractDiscoverableAnnotationHandler)) continue;
            annotations.addAll(((AbstractDiscoverableAnnotationHandler)h).getAnnotationList());
        }
    }
}

