/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.annotations;

import java.util.List;
import org.eclipse.jetty.annotations.AnnotationParser;
import org.eclipse.jetty.annotations.WebServletAnnotation;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.webapp.WebAppContext;

public class WebServletAnnotationHandler
implements AnnotationParser.DiscoverableAnnotationHandler {
    protected WebAppContext _context;

    public WebServletAnnotationHandler(WebAppContext wac) {
        this._context = wac;
    }

    @Override
    public void handleClass(String className, int version, int access, String signature, String superName, String[] interfaces, String annotationName, List<AnnotationParser.Value> values) {
        if (!"javax.servlet.annotation.WebServlet".equals(annotationName)) {
            return;
        }
        WebServletAnnotation annotation = new WebServletAnnotation(this._context, className);
        ((List)this._context.getAttribute("org.eclipse.jetty.discoveredAnnotations")).add(annotation);
    }

    @Override
    public void handleField(String className, String fieldName, int access, String fieldType, String signature, Object value, String annotation, List<AnnotationParser.Value> values) {
        Log.warn((String)"@WebServlet annotation not supported for fields");
    }

    @Override
    public void handleMethod(String className, String methodName, int access, String params, String signature, String[] exceptions, String annotation, List<AnnotationParser.Value> values) {
        Log.warn((String)"@WebServlet annotation not supported for methods");
    }
}

